/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;
import libcore.io.Streams;

public class CipherInputStream
extends FilterInputStream {
    private static final int I_BUFFER_SIZE = 20;
    private final Cipher cipher;
    private final byte[] inputBuffer = new byte[20];
    private byte[] outputBuffer;
    private int outputIndex;
    private int outputLength;
    private boolean finished;

    public CipherInputStream(InputStream is, Cipher c) {
        super(is);
        this.cipher = c;
    }

    protected CipherInputStream(InputStream is) {
        this(is, new NullCipher());
    }

    public int read() throws IOException {
        if (this.finished) {
            return this.outputIndex == this.outputLength ? -1 : this.outputBuffer[this.outputIndex++] & 0xFF;
        }
        if (this.outputIndex < this.outputLength) {
            return this.outputBuffer[this.outputIndex++] & 0xFF;
        }
        this.outputIndex = 0;
        this.outputLength = 0;
        while (this.outputLength == 0) {
            int byteCount;
            int outputSize = this.cipher.getOutputSize(this.inputBuffer.length);
            if (this.outputBuffer == null || this.outputBuffer.length < outputSize) {
                this.outputBuffer = new byte[outputSize];
            }
            if ((byteCount = this.in.read(this.inputBuffer)) == -1) {
                try {
                    this.outputLength = this.cipher.doFinal(this.outputBuffer, 0);
                }
                catch (Exception e) {
                    throw new IOException("Error while finalizing cipher", e);
                }
                this.finished = true;
                break;
            }
            try {
                this.outputLength = this.cipher.update(this.inputBuffer, 0, byteCount, this.outputBuffer, 0);
            }
            catch (ShortBufferException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int i;
        if (this.in == null) {
            throw new NullPointerException("in == null");
        }
        for (i = 0; i < len; ++i) {
            int b = this.read();
            if (b == -1) {
                return i == 0 ? -1 : i;
            }
            if (buf == null) continue;
            buf[off + i] = (byte)b;
        }
        return i;
    }

    public long skip(long byteCount) throws IOException {
        return Streams.skipByReading(this, byteCount);
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        this.in.close();
        try {
            this.cipher.doFinal();
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    public boolean markSupported() {
        return false;
    }
}

