/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();

    public GZIPOutputStream(OutputStream os) throws IOException {
        this(os, 512, true);
    }

    public GZIPOutputStream(OutputStream os, boolean syncFlush) throws IOException {
        this(os, 512, syncFlush);
    }

    public GZIPOutputStream(OutputStream os, int bufferSize) throws IOException {
        this(os, bufferSize, true);
    }

    public GZIPOutputStream(OutputStream os, int bufferSize, boolean syncFlush) throws IOException {
        super(os, new Deflater(-1, true), bufferSize, syncFlush);
        this.writeShort(35615);
        this.out.write(8);
        this.out.write(0);
        this.writeLong(0L);
        this.out.write(0);
        this.out.write(0);
    }

    public void finish() throws IOException {
        super.finish();
        this.writeLong(this.crc.getValue());
        this.writeLong(this.crc.tbytes);
    }

    public void write(byte[] buffer, int off, int nbytes) throws IOException {
        super.write(buffer, off, nbytes);
        this.crc.update(buffer, off, nbytes);
    }

    private long writeLong(long i) throws IOException {
        int unsigned = (int)i;
        this.out.write(unsigned & 0xFF);
        this.out.write(unsigned >> 8 & 0xFF);
        this.out.write(unsigned >> 16 & 0xFF);
        this.out.write(unsigned >> 24 & 0xFF);
        return i;
    }

    private int writeShort(int i) throws IOException {
        this.out.write(i & 0xFF);
        this.out.write(i >> 8 & 0xFF);
        return i;
    }
}

