/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.prefs.BackingStoreException;
import java.util.prefs.FilePreferencesFactoryImpl;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.PreferencesFactory;
import java.util.prefs.XMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preferences {
    public static final int MAX_KEY_LENGTH = 80;
    public static final int MAX_NAME_LENGTH = 80;
    public static final int MAX_VALUE_LENGTH = 8192;
    private static final PreferencesFactory factory = Preferences.findPreferencesFactory();

    private static PreferencesFactory findPreferencesFactory() {
        PreferencesFactory result = ServiceLoader.loadFromSystemProperty(PreferencesFactory.class);
        if (result != null) {
            return result;
        }
        Iterator<PreferencesFactory> i$ = ServiceLoader.load(PreferencesFactory.class).iterator();
        if (i$.hasNext()) {
            PreferencesFactory impl = i$.next();
            return impl;
        }
        return new FilePreferencesFactoryImpl();
    }

    protected Preferences() {
    }

    public abstract String absolutePath();

    public abstract String[] childrenNames() throws BackingStoreException;

    public abstract void clear() throws BackingStoreException;

    public abstract void exportNode(OutputStream var1) throws IOException, BackingStoreException;

    public abstract void exportSubtree(OutputStream var1) throws IOException, BackingStoreException;

    public abstract void flush() throws BackingStoreException;

    public abstract String get(String var1, String var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract byte[] getByteArray(String var1, byte[] var2);

    public abstract double getDouble(String var1, double var2);

    public abstract float getFloat(String var1, float var2);

    public abstract int getInt(String var1, int var2);

    public abstract long getLong(String var1, long var2);

    public static void importPreferences(InputStream istream) throws InvalidPreferencesFormatException, IOException {
        if (istream == null) {
            throw new MalformedURLException("Inputstream cannot be null");
        }
        XMLParser.importPrefs(istream);
    }

    public abstract boolean isUserNode();

    public abstract String[] keys() throws BackingStoreException;

    public abstract String name();

    public abstract Preferences node(String var1);

    public abstract boolean nodeExists(String var1) throws BackingStoreException;

    public abstract Preferences parent();

    public abstract void put(String var1, String var2);

    public abstract void putBoolean(String var1, boolean var2);

    public abstract void putByteArray(String var1, byte[] var2);

    public abstract void putDouble(String var1, double var2);

    public abstract void putFloat(String var1, float var2);

    public abstract void putInt(String var1, int var2);

    public abstract void putLong(String var1, long var2);

    public abstract void remove(String var1);

    public abstract void removeNode() throws BackingStoreException;

    public abstract void addNodeChangeListener(NodeChangeListener var1);

    public abstract void addPreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void removeNodeChangeListener(NodeChangeListener var1);

    public abstract void removePreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void sync() throws BackingStoreException;

    public static Preferences systemNodeForPackage(Class<?> c) {
        return factory.systemRoot().node(Preferences.getNodeName(c));
    }

    public static Preferences systemRoot() {
        return factory.systemRoot();
    }

    public static Preferences userNodeForPackage(Class<?> c) {
        return factory.userRoot().node(Preferences.getNodeName(c));
    }

    private static String getNodeName(Class<?> c) {
        Package p = c.getPackage();
        if (p == null) {
            return "/<unnamed>";
        }
        return "/" + p.getName().replace('.', '/');
    }

    public static Preferences userRoot() {
        return factory.userRoot();
    }

    public abstract String toString();
}

