/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class MemoryHandler
extends Handler {
    private static final int DEFAULT_SIZE = 1000;
    private Handler target;
    private int size = 1000;
    private Level push = Level.SEVERE;
    private final LogManager manager = LogManager.getLogManager();
    private LogRecord[] buffer;
    private int cursor;

    public MemoryHandler() {
        String pushName;
        String className = this.getClass().getName();
        String targetName = this.manager.getProperty(className + ".target");
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<?> targetClass = loader.loadClass(targetName);
            this.target = (Handler)targetClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load target handler '" + targetName + "'");
        }
        String sizeString = this.manager.getProperty(className + ".size");
        if (sizeString != null) {
            try {
                this.size = Integer.parseInt(sizeString);
                if (this.size <= 0) {
                    this.size = 1000;
                }
            }
            catch (Exception e) {
                this.printInvalidPropMessage(className + ".size", sizeString, e);
            }
        }
        if ((pushName = this.manager.getProperty(className + ".push")) != null) {
            try {
                this.push = Level.parse(pushName);
            }
            catch (Exception e) {
                this.printInvalidPropMessage(className + ".push", pushName, e);
            }
        }
        this.initProperties("ALL", null, "java.util.logging.SimpleFormatter", null);
        this.buffer = new LogRecord[this.size];
    }

    public MemoryHandler(Handler target, int size, Level pushLevel) {
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        target.getLevel();
        pushLevel.intValue();
        this.target = target;
        this.size = size;
        this.push = pushLevel;
        this.initProperties("ALL", null, "java.util.logging.SimpleFormatter", null);
        this.buffer = new LogRecord[size];
    }

    public void close() {
        this.manager.checkAccess();
        this.target.close();
        this.setLevel(Level.OFF);
    }

    public void flush() {
        this.target.flush();
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (this.cursor >= this.size) {
            this.cursor = 0;
        }
        this.buffer[this.cursor++] = record;
        if (record.getLevel().intValue() >= this.push.intValue()) {
            this.push();
        }
    }

    public Level getPushLevel() {
        return this.push;
    }

    public boolean isLoggable(LogRecord record) {
        return super.isLoggable(record);
    }

    public void push() {
        int i;
        for (i = this.cursor; i < this.size; ++i) {
            if (this.buffer[i] != null) {
                this.target.publish(this.buffer[i]);
            }
            this.buffer[i] = null;
        }
        for (i = 0; i < this.cursor; ++i) {
            if (this.buffer[i] != null) {
                this.target.publish(this.buffer[i]);
            }
            this.buffer[i] = null;
        }
        this.cursor = 0;
    }

    public void setPushLevel(Level newLevel) {
        this.manager.checkAccess();
        newLevel.intValue();
        this.push = newLevel;
    }
}

