/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CyclicBarrier {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition trip = this.lock.newCondition();
    private final int parties;
    private final Runnable barrierCommand;
    private Generation generation = new Generation();
    private int count;

    private void nextGeneration() {
        this.trip.signalAll();
        this.count = this.parties;
        this.generation = new Generation();
    }

    private void breakBarrier() {
        this.generation.broken = true;
        this.count = this.parties;
        this.trip.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int dowait(boolean timed, long nanos) throws InterruptedException, BrokenBarrierException, TimeoutException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int index;
            Generation g = this.generation;
            if (g.broken) {
                throw new BrokenBarrierException();
            }
            if (Thread.interrupted()) {
                this.breakBarrier();
                throw new InterruptedException();
            }
            if ((index = --this.count) == 0) {
                int n;
                boolean ranAction = false;
                try {
                    Runnable command = this.barrierCommand;
                    if (command != null) {
                        command.run();
                    }
                    ranAction = true;
                    this.nextGeneration();
                    n = 0;
                    Object var11_11 = null;
                    if (!ranAction) {
                        this.breakBarrier();
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (ranAction) throw throwable;
                    this.breakBarrier();
                    throw throwable;
                }
                Object var13_13 = null;
                lock.unlock();
                return n;
            }
            do {
                block16: {
                    try {
                        if (!timed) {
                            this.trip.await();
                            break block16;
                        }
                        if (nanos > 0L) {
                            nanos = this.trip.awaitNanos(nanos);
                        }
                    }
                    catch (InterruptedException ie) {
                        if (g == this.generation && !g.broken) {
                            this.breakBarrier();
                            throw ie;
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                if (g.broken) {
                    throw new BrokenBarrierException();
                }
                if (g == this.generation) continue;
                int n = index;
                Object var13_14 = null;
                lock.unlock();
                return n;
            } while (!timed || nanos > 0L);
            this.breakBarrier();
            throw new TimeoutException();
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public CyclicBarrier(int parties, Runnable barrierAction) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties = parties;
        this.count = parties;
        this.barrierCommand = barrierAction;
    }

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    public int getParties() {
        return this.parties;
    }

    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            return this.dowait(false, 0L);
        }
        catch (TimeoutException toe) {
            throw new Error(toe);
        }
    }

    public int await(long timeout, TimeUnit unit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        return this.dowait(true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroken() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.generation.broken;
            Object var4_3 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.breakBarrier();
            this.nextGeneration();
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberWaiting() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.parties - this.count;
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private static class Generation {
        boolean broken = false;

        private Generation() {
        }
    }
}

