/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import libcore.util.EmptyArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private Locale locale;
    private transient String[] strings;
    private int[] argumentNumbers;
    private Format[] formats;
    private int maxOffset;
    private transient int maxArgumentIndex;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("argumentNumbers", int[].class), new ObjectStreamField("formats", Format[].class), new ObjectStreamField("locale", Locale.class), new ObjectStreamField("maxOffset", Integer.TYPE), new ObjectStreamField("offsets", int[].class), new ObjectStreamField("pattern", String.class)};

    public MessageFormat(String template, Locale locale) {
        this.locale = locale;
        this.applyPattern(template);
    }

    public MessageFormat(String template) {
        this(template, Locale.getDefault());
    }

    public void applyPattern(String template) {
        int length = template.length();
        StringBuffer buffer = new StringBuffer();
        ParsePosition position = new ParsePosition(0);
        ArrayList<String> localStrings = new ArrayList<String>();
        int argCount = 0;
        int[] args = new int[10];
        int maxArg = -1;
        ArrayList<Format> localFormats = new ArrayList<Format>();
        while (position.getIndex() < length) {
            if (Format.upTo(template, position, buffer, '{')) {
                char ch;
                int arg = 0;
                int offset = position.getIndex();
                if (offset >= length) {
                    throw new IllegalArgumentException("Invalid argument number");
                }
                while ((ch = template.charAt(offset++)) != '}' && ch != ',') {
                    if (ch < '0' && ch > '9') {
                        throw new IllegalArgumentException("Invalid argument number");
                    }
                    if ((arg = arg * 10 + (ch - 48)) >= 0 && offset < length) continue;
                    throw new IllegalArgumentException("Invalid argument number");
                }
                position.setIndex(--offset);
                localFormats.add(this.parseVariable(template, position));
                if (argCount >= args.length) {
                    int[] newArgs = new int[args.length * 2];
                    System.arraycopy(args, 0, newArgs, 0, args.length);
                    args = newArgs;
                }
                args[argCount++] = arg;
                if (arg > maxArg) {
                    maxArg = arg;
                }
            }
            localStrings.add(buffer.toString());
            buffer.setLength(0);
        }
        this.strings = localStrings.toArray(new String[localStrings.size()]);
        this.argumentNumbers = args;
        this.formats = localFormats.toArray(new Format[argCount]);
        this.maxOffset = argCount - 1;
        this.maxArgumentIndex = maxArg;
    }

    @Override
    public Object clone() {
        MessageFormat clone = (MessageFormat)super.clone();
        Format[] array2 = new Format[this.formats.length];
        int i = this.formats.length;
        while (--i >= 0) {
            if (this.formats[i] == null) continue;
            array2[i] = (Format)this.formats[i].clone();
        }
        clone.formats = array2;
        return clone;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFormat)) {
            return false;
        }
        MessageFormat format = (MessageFormat)object;
        if (this.maxOffset != format.maxOffset) {
            return false;
        }
        for (int i = 0; i <= this.maxOffset; ++i) {
            if (this.argumentNumbers[i] == format.argumentNumbers[i]) continue;
            return false;
        }
        return this.locale.equals(format.locale) && Arrays.equals(this.strings, format.strings) && Arrays.equals(this.formats, format.formats);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        if (object == null) {
            throw new NullPointerException("object == null");
        }
        StringBuffer buffer = new StringBuffer();
        ArrayList<FieldContainer> fields = new ArrayList<FieldContainer>();
        this.formatImpl((Object[])object, buffer, new FieldPosition(0), fields);
        AttributedString as = new AttributedString(buffer.toString());
        for (FieldContainer fc : fields) {
            as.addAttribute(fc.attribute, fc.value, fc.start, fc.end);
        }
        return as.getIterator();
    }

    public final StringBuffer format(Object[] objects, StringBuffer buffer, FieldPosition field) {
        return this.formatImpl(objects, buffer, field, null);
    }

    private StringBuffer formatImpl(Object[] objects, StringBuffer buffer, FieldPosition position, List<FieldContainer> fields) {
        FieldPosition passedField = new FieldPosition(0);
        for (int i = 0; i <= this.maxOffset; ++i) {
            buffer.append(this.strings[i]);
            int begin = buffer.length();
            if (objects == null || this.argumentNumbers[i] >= objects.length) {
                buffer.append('{');
                buffer.append(this.argumentNumbers[i]);
                buffer.append('}');
                this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                continue;
            }
            Object arg = objects[this.argumentNumbers[i]];
            Format format = this.formats[i];
            if (format == null || arg == null) {
                if (arg instanceof Number) {
                    format = NumberFormat.getInstance();
                } else if (arg instanceof Date) {
                    format = DateFormat.getInstance();
                } else {
                    buffer.append(arg);
                    this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                    continue;
                }
            }
            if (format instanceof ChoiceFormat) {
                String result = format.format(arg);
                MessageFormat mf = new MessageFormat(result);
                mf.setLocale(this.locale);
                mf.format(objects, buffer, passedField);
                this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                this.handleFormat(format, arg, begin, fields);
                continue;
            }
            format.format(arg, buffer, passedField);
            this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
            this.handleFormat(format, arg, begin, fields);
        }
        if (this.maxOffset + 1 < this.strings.length) {
            buffer.append(this.strings[this.maxOffset + 1]);
        }
        return buffer;
    }

    private void handleArgumentField(int begin, int end, int argIndex, FieldPosition position, List<FieldContainer> fields) {
        if (fields != null) {
            fields.add(new FieldContainer(begin, end, Field.ARGUMENT, argIndex));
        } else if (position != null && position.getFieldAttribute() == Field.ARGUMENT && position.getEndIndex() == 0) {
            position.setBeginIndex(begin);
            position.setEndIndex(end);
        }
    }

    private void handleFormat(Format format, Object arg, int begin, List<FieldContainer> fields) {
        if (fields == null) {
            return;
        }
        AttributedCharacterIterator iterator = format.formatToCharacterIterator(arg);
        while (iterator.getIndex() != iterator.getEndIndex()) {
            int start = iterator.getRunStart();
            int end = iterator.getRunLimit();
            for (AttributedCharacterIterator.Attribute attribute : iterator.getAttributes().keySet()) {
                Object value = iterator.getAttribute(attribute);
                fields.add(new FieldContainer(begin + start, begin + end, attribute, value));
            }
            iterator.setIndex(end);
        }
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer buffer, FieldPosition field) {
        return this.format((Object[])object, buffer, field);
    }

    public static String format(String format, Object ... args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = "null";
            }
        }
        return new MessageFormat(format).format(args);
    }

    public Format[] getFormats() {
        return (Format[])this.formats.clone();
    }

    public Format[] getFormatsByArgumentIndex() {
        Format[] answer = new Format[this.maxArgumentIndex + 1];
        for (int i = 0; i < this.maxOffset + 1; ++i) {
            answer[this.argumentNumbers[i]] = this.formats[i];
        }
        return answer;
    }

    public void setFormatByArgumentIndex(int argIndex, Format format) {
        for (int i = 0; i < this.maxOffset + 1; ++i) {
            if (this.argumentNumbers[i] != argIndex) continue;
            this.formats[i] = format;
        }
    }

    public void setFormatsByArgumentIndex(Format[] formats) {
        for (int j = 0; j < formats.length; ++j) {
            for (int i = 0; i < this.maxOffset + 1; ++i) {
                if (this.argumentNumbers[i] != j) continue;
                this.formats[i] = formats[j];
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i <= this.maxOffset; ++i) {
            hashCode += this.argumentNumbers[i] + this.strings[i].hashCode();
            if (this.formats[i] == null) continue;
            hashCode += this.formats[i].hashCode();
        }
        if (this.maxOffset + 1 < this.strings.length) {
            hashCode += this.strings[this.maxOffset + 1].hashCode();
        }
        if (this.locale != null) {
            return hashCode + this.locale.hashCode();
        }
        return hashCode;
    }

    public Object[] parse(String string2) throws ParseException {
        ParsePosition position = new ParsePosition(0);
        Object[] result = this.parse(string2, position);
        if (position.getIndex() == 0) {
            throw new ParseException("Parse failure", position.getErrorIndex());
        }
        return result;
    }

    public Object[] parse(String string2, ParsePosition position) {
        if (string2 == null) {
            return EmptyArray.OBJECT;
        }
        ParsePosition internalPos = new ParsePosition(0);
        int offset = position.getIndex();
        Object[] result = new Object[this.maxArgumentIndex + 1];
        for (int i = 0; i <= this.maxOffset; ++i) {
            Object parse;
            String sub = this.strings[i];
            if (!string2.startsWith(sub, offset)) {
                position.setErrorIndex(offset);
                return null;
            }
            offset += sub.length();
            Format format = this.formats[i];
            if (format == null) {
                if (i + 1 < this.strings.length) {
                    int next = string2.indexOf(this.strings[i + 1], offset);
                    if (next == -1) {
                        position.setErrorIndex(offset);
                        return null;
                    }
                    parse = string2.substring(offset, next);
                    offset = next;
                } else {
                    parse = string2.substring(offset);
                    offset = string2.length();
                }
            } else {
                internalPos.setIndex(offset);
                parse = format.parseObject(string2, internalPos);
                if (internalPos.getErrorIndex() != -1) {
                    position.setErrorIndex(offset);
                    return null;
                }
                offset = internalPos.getIndex();
            }
            result[this.argumentNumbers[i]] = parse;
        }
        if (this.maxOffset + 1 < this.strings.length) {
            String sub = this.strings[this.maxOffset + 1];
            if (!string2.startsWith(sub, offset)) {
                position.setErrorIndex(offset);
                return null;
            }
            offset += sub.length();
        }
        position.setIndex(offset);
        return result;
    }

    @Override
    public Object parseObject(String string2, ParsePosition position) {
        return this.parse(string2, position);
    }

    private int match(String string2, ParsePosition position, boolean last, String[] tokens) {
        char ch;
        int offset;
        int length = string2.length();
        int token = -1;
        for (offset = position.getIndex(); offset < length && Character.isWhitespace(string2.charAt(offset)); ++offset) {
        }
        int i = tokens.length;
        while (--i >= 0) {
            if (!string2.regionMatches(true, offset, tokens[i], 0, tokens[i].length())) continue;
            token = i;
            break;
        }
        if (token == -1) {
            return -1;
        }
        offset += tokens[token].length();
        while (offset < length && Character.isWhitespace(string2.charAt(offset))) {
            ++offset;
        }
        if (offset < length && ((ch = string2.charAt(offset)) == '}' || !last && ch == ',')) {
            position.setIndex(offset + 1);
            return token;
        }
        return -1;
    }

    private Format parseVariable(String string2, ParsePosition position) {
        char ch;
        int length = string2.length();
        int offset = position.getIndex();
        if (offset >= length || (ch = string2.charAt(offset++)) != '}' && ch != ',') {
            throw new IllegalArgumentException("Missing element format");
        }
        position.setIndex(offset);
        if (ch == '}') {
            return null;
        }
        int type = this.match(string2, position, false, new String[]{"time", "date", "number", "choice"});
        if (type == -1) {
            throw new IllegalArgumentException("Unknown element format");
        }
        StringBuffer buffer = new StringBuffer();
        ch = string2.charAt(position.getIndex() - 1);
        switch (type) {
            case 0: 
            case 1: {
                if (ch == '}') {
                    return type == 1 ? DateFormat.getDateInstance(2, this.locale) : DateFormat.getTimeInstance(2, this.locale);
                }
                int dateStyle = this.match(string2, position, true, new String[]{"full", "long", "medium", "short"});
                if (dateStyle == -1) {
                    Format.upToWithQuotes(string2, position, buffer, '}', '{');
                    return new SimpleDateFormat(buffer.toString(), this.locale);
                }
                switch (dateStyle) {
                    case 0: {
                        dateStyle = 0;
                        break;
                    }
                    case 1: {
                        dateStyle = 1;
                        break;
                    }
                    case 2: {
                        dateStyle = 2;
                        break;
                    }
                    case 3: {
                        dateStyle = 3;
                    }
                }
                return type == 1 ? DateFormat.getDateInstance(dateStyle, this.locale) : DateFormat.getTimeInstance(dateStyle, this.locale);
            }
            case 2: {
                if (ch == '}') {
                    return NumberFormat.getInstance(this.locale);
                }
                int numberStyle = this.match(string2, position, true, new String[]{"currency", "percent", "integer"});
                if (numberStyle == -1) {
                    Format.upToWithQuotes(string2, position, buffer, '}', '{');
                    return new DecimalFormat(buffer.toString(), new DecimalFormatSymbols(this.locale));
                }
                switch (numberStyle) {
                    case 0: {
                        return NumberFormat.getCurrencyInstance(this.locale);
                    }
                    case 1: {
                        return NumberFormat.getPercentInstance(this.locale);
                    }
                }
                return NumberFormat.getIntegerInstance(this.locale);
            }
        }
        try {
            Format.upToWithQuotes(string2, position, buffer, '}', '{');
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return new ChoiceFormat(buffer.toString());
    }

    public void setFormat(int offset, Format format) {
        this.formats[offset] = format;
    }

    public void setFormats(Format[] formats) {
        int min = this.formats.length;
        if (formats.length < min) {
            min = formats.length;
        }
        for (int i = 0; i < min; ++i) {
            this.formats[i] = formats[i];
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        for (int i = 0; i <= this.maxOffset; ++i) {
            Format format = this.formats[i];
            if (format instanceof DecimalFormat) {
                try {
                    this.formats[i] = new DecimalFormat(((DecimalFormat)format).toPattern(), new DecimalFormatSymbols(locale));
                }
                catch (NullPointerException npe) {
                    this.formats[i] = null;
                }
                continue;
            }
            if (!(format instanceof SimpleDateFormat)) continue;
            try {
                this.formats[i] = new SimpleDateFormat(((SimpleDateFormat)format).toPattern(), locale);
                continue;
            }
            catch (NullPointerException npe) {
                this.formats[i] = null;
            }
        }
    }

    private String decodeDecimalFormat(StringBuffer buffer, Format format) {
        buffer.append(",number");
        if (!format.equals(NumberFormat.getNumberInstance(this.locale))) {
            if (format.equals(NumberFormat.getIntegerInstance(this.locale))) {
                buffer.append(",integer");
            } else if (format.equals(NumberFormat.getCurrencyInstance(this.locale))) {
                buffer.append(",currency");
            } else if (format.equals(NumberFormat.getPercentInstance(this.locale))) {
                buffer.append(",percent");
            } else {
                buffer.append(',');
                return ((DecimalFormat)format).toPattern();
            }
        }
        return null;
    }

    private String decodeSimpleDateFormat(StringBuffer buffer, Format format) {
        if (format.equals(DateFormat.getTimeInstance(2, this.locale))) {
            buffer.append(",time");
        } else if (format.equals(DateFormat.getDateInstance(2, this.locale))) {
            buffer.append(",date");
        } else if (format.equals(DateFormat.getTimeInstance(3, this.locale))) {
            buffer.append(",time,short");
        } else if (format.equals(DateFormat.getDateInstance(3, this.locale))) {
            buffer.append(",date,short");
        } else if (format.equals(DateFormat.getTimeInstance(1, this.locale))) {
            buffer.append(",time,long");
        } else if (format.equals(DateFormat.getDateInstance(1, this.locale))) {
            buffer.append(",date,long");
        } else if (format.equals(DateFormat.getTimeInstance(0, this.locale))) {
            buffer.append(",time,full");
        } else if (format.equals(DateFormat.getDateInstance(0, this.locale))) {
            buffer.append(",date,full");
        } else {
            buffer.append(",date,");
            return ((SimpleDateFormat)format).toPattern();
        }
        return null;
    }

    public String toPattern() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i <= this.maxOffset; ++i) {
            this.appendQuoted(buffer, this.strings[i]);
            buffer.append('{');
            buffer.append(this.argumentNumbers[i]);
            Format format = this.formats[i];
            String pattern = null;
            if (format instanceof ChoiceFormat) {
                buffer.append(",choice,");
                pattern = ((ChoiceFormat)format).toPattern();
            } else if (format instanceof DecimalFormat) {
                pattern = this.decodeDecimalFormat(buffer, format);
            } else if (format instanceof SimpleDateFormat) {
                pattern = this.decodeSimpleDateFormat(buffer, format);
            } else if (format != null) {
                throw new IllegalArgumentException("Unknown format");
            }
            if (pattern != null) {
                boolean quote = false;
                int index = 0;
                int length = pattern.length();
                int count = 0;
                while (index < length) {
                    int ch;
                    if ((ch = pattern.charAt(index++)) == 39) {
                        boolean bl = quote = !quote;
                    }
                    if (!quote) {
                        if (ch == 123) {
                            ++count;
                        }
                        if (ch == 125) {
                            if (count > 0) {
                                --count;
                            } else {
                                buffer.append("'}");
                                ch = 39;
                            }
                        }
                    }
                    buffer.append((char)ch);
                }
            }
            buffer.append('}');
        }
        if (this.maxOffset + 1 < this.strings.length) {
            this.appendQuoted(buffer, this.strings[this.maxOffset + 1]);
        }
        return buffer.toString();
    }

    private void appendQuoted(StringBuffer buffer, String string2) {
        int length = string2.length();
        for (int i = 0; i < length; ++i) {
            char ch = string2.charAt(i);
            if (ch == '{' || ch == '}') {
                buffer.append('\'');
                buffer.append(ch);
                buffer.append('\'');
                continue;
            }
            buffer.append(ch);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("argumentNumbers", this.argumentNumbers);
        Format[] compatibleFormats = this.formats;
        fields.put("formats", compatibleFormats);
        fields.put("locale", this.locale);
        fields.put("maxOffset", this.maxOffset);
        int offset = 0;
        int offsetsLength = this.maxOffset + 1;
        int[] offsets = new int[offsetsLength];
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i <= this.maxOffset; ++i) {
            offsets[i] = offset += this.strings[i].length();
            pattern.append(this.strings[i]);
        }
        if (this.maxOffset + 1 < this.strings.length) {
            pattern.append(this.strings[this.maxOffset + 1]);
        }
        fields.put("offsets", offsets);
        fields.put("pattern", pattern.toString());
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.argumentNumbers = (int[])fields.get("argumentNumbers", null);
        this.formats = (Format[])fields.get("formats", null);
        this.locale = (Locale)fields.get("locale", null);
        this.maxOffset = fields.get("maxOffset", 0);
        int[] offsets = (int[])fields.get("offsets", null);
        String pattern = (String)fields.get("pattern", null);
        int length = this.maxOffset < 0 ? (pattern.length() > 0 ? 1 : 0) : this.maxOffset + (offsets[this.maxOffset] == pattern.length() ? 1 : 2);
        this.strings = new String[length];
        int last = 0;
        for (int i = 0; i <= this.maxOffset; ++i) {
            this.strings[i] = pattern.substring(last, offsets[i]);
            last = offsets[i];
        }
        if (this.maxOffset + 1 < this.strings.length) {
            this.strings[this.strings.length - 1] = pattern.substring(last, pattern.length());
        }
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7899943957617360810L;
        public static final Field ARGUMENT = new Field("message argument field");

        protected Field(String fieldName) {
            super(fieldName);
        }
    }

    private static class FieldContainer {
        int start;
        int end;
        AttributedCharacterIterator.Attribute attribute;
        Object value;

        public FieldContainer(int start, int end, AttributedCharacterIterator.Attribute attribute, Object value) {
            this.start = start;
            this.end = end;
            this.attribute = attribute;
            this.value = value;
        }
    }
}

