/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FileDescriptorChannel;
import java.nio.SocketChannelImpl;
import java.nio.channels.Pipe;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;

final class PipeImpl
extends Pipe {
    private final PipeSinkChannel sink;
    private final PipeSourceChannel source;

    public PipeImpl(SelectorProvider selectorProvider) throws IOException {
        try {
            FileDescriptor fd1 = new FileDescriptor();
            FileDescriptor fd2 = new FileDescriptor();
            Libcore.os.socketpair(OsConstants.AF_UNIX, OsConstants.SOCK_STREAM, 0, fd1, fd2);
            this.sink = new PipeSinkChannel(selectorProvider, fd1);
            this.source = new PipeSourceChannel(selectorProvider, fd2);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    private class PipeSinkChannel
    extends Pipe.SinkChannel
    implements FileDescriptorChannel {
        private final FileDescriptor fd;
        private final SocketChannel channel;

        private PipeSinkChannel(SelectorProvider selectorProvider, FileDescriptor fd) throws IOException {
            super(selectorProvider);
            this.fd = fd;
            this.channel = new SocketChannelImpl(selectorProvider, fd);
        }

        protected void implCloseSelectableChannel() throws IOException {
            this.channel.close();
        }

        protected void implConfigureBlocking(boolean blocking) throws IOException {
            IoUtils.setBlocking(this.getFD(), blocking);
        }

        public int write(ByteBuffer buffer) throws IOException {
            return this.channel.write(buffer);
        }

        public long write(ByteBuffer[] buffers) throws IOException {
            return this.channel.write(buffers);
        }

        public long write(ByteBuffer[] buffers, int offset, int length) throws IOException {
            return this.channel.write(buffers, offset, length);
        }

        public FileDescriptor getFD() {
            return this.fd;
        }
    }

    private class PipeSourceChannel
    extends Pipe.SourceChannel
    implements FileDescriptorChannel {
        private final FileDescriptor fd;
        private final SocketChannel channel;

        private PipeSourceChannel(SelectorProvider selectorProvider, FileDescriptor fd) throws IOException {
            super(selectorProvider);
            this.fd = fd;
            this.channel = new SocketChannelImpl(selectorProvider, fd);
        }

        protected void implCloseSelectableChannel() throws IOException {
            this.channel.close();
        }

        protected void implConfigureBlocking(boolean blocking) throws IOException {
            IoUtils.setBlocking(this.getFD(), blocking);
        }

        public int read(ByteBuffer buffer) throws IOException {
            return this.channel.read(buffer);
        }

        public long read(ByteBuffer[] buffers) throws IOException {
            return this.channel.read(buffers);
        }

        public long read(ByteBuffer[] buffers, int offset, int length) throws IOException {
            return this.channel.read(buffers, offset, length);
        }

        public FileDescriptor getFD() {
            return this.fd;
        }
    }
}

