/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;

final class IntArrayBuffer
extends IntBuffer {
    private final int[] backingArray;
    private final int arrayOffset;
    private final boolean isReadOnly;

    IntArrayBuffer(int[] array2) {
        this(array2.length, array2, 0, false);
    }

    private IntArrayBuffer(int capacity, int[] backingArray, int arrayOffset, boolean isReadOnly) {
        super(capacity);
        this.backingArray = backingArray;
        this.arrayOffset = arrayOffset;
        this.isReadOnly = isReadOnly;
    }

    private static IntArrayBuffer copy(IntArrayBuffer other, int markOfOther, boolean isReadOnly) {
        IntArrayBuffer buf = new IntArrayBuffer(other.capacity(), other.backingArray, other.arrayOffset, isReadOnly);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    public IntBuffer asReadOnlyBuffer() {
        return IntArrayBuffer.copy(this, this.mark, true);
    }

    public IntBuffer compact() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        System.arraycopy(this.backingArray, this.position + this.arrayOffset, this.backingArray, this.arrayOffset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public IntBuffer duplicate() {
        return IntArrayBuffer.copy(this, this.mark, this.isReadOnly);
    }

    public IntBuffer slice() {
        return new IntArrayBuffer(this.remaining(), this.backingArray, this.arrayOffset + this.position, this.isReadOnly);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    int[] protectedArray() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.backingArray;
    }

    int protectedArrayOffset() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.arrayOffset;
    }

    boolean protectedHasArray() {
        return !this.isReadOnly;
    }

    public final int get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.arrayOffset + this.position++];
    }

    public final int get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.arrayOffset + index];
    }

    public final IntBuffer get(int[] dst, int dstOffset, int intCount) {
        if (intCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.arrayOffset + this.position, dst, dstOffset, intCount);
        this.position += intCount;
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public IntBuffer put(int c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.arrayOffset + this.position++] = c;
        return this;
    }

    public IntBuffer put(int index, int c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index);
        this.backingArray[this.arrayOffset + index] = c;
        return this;
    }

    public IntBuffer put(int[] src, int srcOffset, int intCount) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (intCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, srcOffset, this.backingArray, this.arrayOffset + this.position, intCount);
        this.position += intCount;
        return this;
    }
}

