/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import libcore.io.OsConstants;

public final class Inet6Address
extends InetAddress {
    private static final long serialVersionUID = 6880410070516793377L;
    public static final InetAddress ANY = new Inet6Address(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, null, 0);
    public static final InetAddress LOOPBACK = new Inet6Address(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, "localhost", 0);
    private boolean scope_id_set;
    private int scope_id;
    private boolean scope_ifname_set;
    private String ifname;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("ipaddress", byte[].class), new ObjectStreamField("scope_id", Integer.TYPE), new ObjectStreamField("scope_id_set", Boolean.TYPE), new ObjectStreamField("scope_ifname_set", Boolean.TYPE), new ObjectStreamField("ifname", String.class)};

    Inet6Address(byte[] ipaddress, String hostName, int scope_id) {
        super(OsConstants.AF_INET6, ipaddress, hostName);
        this.scope_id = scope_id;
        this.scope_id_set = scope_id != 0;
    }

    public static Inet6Address getByAddress(String host, byte[] addr, int scope_id) throws UnknownHostException {
        if (addr == null || addr.length != 16) {
            throw new UnknownHostException("Not an IPv6 address: " + Arrays.toString(addr));
        }
        if (scope_id < 0) {
            scope_id = 0;
        }
        return new Inet6Address(addr, host, scope_id);
    }

    public static Inet6Address getByAddress(String host, byte[] addr, NetworkInterface nif) throws UnknownHostException {
        Inet6Address address = Inet6Address.getByAddress(host, addr, 0);
        if (nif == null) {
            return address;
        }
        Enumeration<InetAddress> addressList = nif.getInetAddresses();
        while (addressList.hasMoreElements()) {
            Inet6Address v6ia;
            boolean isSameType;
            InetAddress ia = addressList.nextElement();
            if (ia.getAddress().length != 16 || !(isSameType = (v6ia = (Inet6Address)ia).compareLocalType(address))) continue;
            address.scope_id_set = true;
            address.scope_id = v6ia.scope_id;
            address.scope_ifname_set = true;
            address.ifname = nif.getName();
            break;
        }
        if (!address.scope_id_set) {
            throw new UnknownHostException("Scope id not found for address: " + Arrays.toString(addr));
        }
        return address;
    }

    private boolean compareLocalType(Inet6Address ia) {
        if (ia.isSiteLocalAddress() && this.isSiteLocalAddress()) {
            return true;
        }
        if (ia.isLinkLocalAddress() && this.isLinkLocalAddress()) {
            return true;
        }
        return !ia.isSiteLocalAddress() && !ia.isLinkLocalAddress();
    }

    public boolean isAnyLocalAddress() {
        return Arrays.equals(this.ipaddress, Inet6Address.ANY.ipaddress);
    }

    public boolean isIPv4CompatibleAddress() {
        for (int i = 0; i < 12; ++i) {
            if (this.ipaddress[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isLinkLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 128;
    }

    public boolean isLoopbackAddress() {
        return Arrays.equals(this.ipaddress, Inet6Address.LOOPBACK.ipaddress);
    }

    public boolean isMCGlobal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 14;
    }

    public boolean isMCLinkLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 2;
    }

    public boolean isMCNodeLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 1;
    }

    public boolean isMCOrgLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 8;
    }

    public boolean isMCSiteLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 5;
    }

    public boolean isMulticastAddress() {
        return (this.ipaddress[0] & 0xFF) == 255;
    }

    public boolean isSiteLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 192;
    }

    public int getScopeId() {
        return this.scope_id_set ? this.scope_id : 0;
    }

    public NetworkInterface getScopedInterface() {
        try {
            return this.scope_ifname_set && this.ifname != null ? NetworkInterface.getByName(this.ifname) : null;
        }
        catch (SocketException ex) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        if (this.ipaddress == null) {
            fields.put("ipaddress", null);
        } else {
            fields.put("ipaddress", this.ipaddress);
        }
        fields.put("scope_id", this.scope_id);
        fields.put("scope_id_set", this.scope_id_set);
        fields.put("scope_ifname_set", this.scope_ifname_set);
        fields.put("ifname", this.ifname);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.ipaddress = (byte[])fields.get("ipaddress", null);
        this.scope_id = fields.get("scope_id", 0);
        this.scope_id_set = fields.get("scope_id_set", false);
        this.ifname = (String)fields.get("ifname", null);
        this.scope_ifname_set = fields.get("scope_ifname_set", false);
    }

    public String toString() {
        if (this.ifname != null) {
            return super.toString() + "%" + this.ifname;
        }
        if (this.scope_id != 0) {
            return super.toString() + "%" + this.scope_id;
        }
        return super.toString();
    }
}

