/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileDescriptor;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.StructStat;
import libcore.io.StructStatVfs;
import org.apache.harmony.luni.util.DeleteOnExit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
implements Serializable,
Comparable<File> {
    private static final long serialVersionUID = 301077366599181567L;
    private static final Random tempFileRandom = new Random();
    public static final char separatorChar = System.getProperty("file.separator", "/").charAt(0);
    public static final String separator;
    public static final char pathSeparatorChar;
    public static final String pathSeparator;
    private String path;

    public File(File dir, String name) {
        this(dir == null ? null : dir.getPath(), name);
    }

    public File(String path) {
        this.path = File.fixSlashes(path);
    }

    public File(String dirPath, String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.path = dirPath == null || dirPath.isEmpty() ? File.fixSlashes(name) : (name.isEmpty() ? File.fixSlashes(dirPath) : File.fixSlashes(File.join(dirPath, name)));
    }

    public File(URI uri) {
        File.checkURI(uri);
        this.path = File.fixSlashes(uri.getPath());
    }

    private static String fixSlashes(String origPath) {
        boolean lastWasSlash = false;
        char[] newPath = origPath.toCharArray();
        int length = newPath.length;
        int newLength = 0;
        for (int i = 0; i < length; ++i) {
            char ch = newPath[i];
            if (ch == '/') {
                if (lastWasSlash) continue;
                newPath[newLength++] = separatorChar;
                lastWasSlash = true;
                continue;
            }
            newPath[newLength++] = ch;
            lastWasSlash = false;
        }
        if (lastWasSlash && newLength > 1) {
            --newLength;
        }
        return newLength != length ? new String(newPath, 0, newLength) : origPath;
    }

    private static String join(String prefix, String suffix) {
        boolean haveSlash;
        int prefixLength = prefix.length();
        boolean bl = haveSlash = prefixLength > 0 && prefix.charAt(prefixLength - 1) == separatorChar;
        if (!haveSlash) {
            haveSlash = suffix.length() > 0 && suffix.charAt(0) == separatorChar;
        }
        return haveSlash ? prefix + suffix : prefix + separatorChar + suffix;
    }

    private static void checkURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute: " + uri);
        }
        if (!uri.getRawSchemeSpecificPart().startsWith("/")) {
            throw new IllegalArgumentException("URI is not hierarchical: " + uri);
        }
        if (!"file".equals(uri.getScheme())) {
            throw new IllegalArgumentException("Expected file scheme in URI: " + uri);
        }
        String rawPath = uri.getRawPath();
        if (rawPath == null || rawPath.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty path in URI: " + uri);
        }
        if (uri.getRawAuthority() != null) {
            throw new IllegalArgumentException("Found authority in URI: " + uri);
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException("Found query in URI: " + uri);
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException("Found fragment in URI: " + uri);
        }
    }

    public static File[] listRoots() {
        return new File[]{new File("/")};
    }

    public boolean canExecute() {
        return this.doAccess(OsConstants.X_OK);
    }

    public boolean canRead() {
        return this.doAccess(OsConstants.R_OK);
    }

    public boolean canWrite() {
        return this.doAccess(OsConstants.W_OK);
    }

    private boolean doAccess(int mode) {
        try {
            return Libcore.os.access(this.path, mode);
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    @Override
    public int compareTo(File another) {
        return this.getPath().compareTo(another.getPath());
    }

    public boolean delete() {
        try {
            Libcore.os.remove(this.path);
            return true;
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    public void deleteOnExit() {
        DeleteOnExit.getInstance().addFile(this.getAbsolutePath());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof File)) {
            return false;
        }
        return this.path.equals(((File)obj).getPath());
    }

    public boolean exists() {
        return this.doAccess(OsConstants.F_OK);
    }

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.path;
        }
        String userDir = System.getProperty("user.dir");
        return this.path.isEmpty() ? userDir : File.join(userDir, this.path);
    }

    public File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    public String getCanonicalPath() throws IOException {
        return File.realpath(this.getAbsolutePath());
    }

    private static native String realpath(String var0);

    private static native String readlink(String var0);

    public File getCanonicalFile() throws IOException {
        return new File(this.getCanonicalPath());
    }

    public String getName() {
        int separatorIndex = this.path.lastIndexOf(separator);
        return separatorIndex < 0 ? this.path : this.path.substring(separatorIndex + 1, this.path.length());
    }

    public String getParent() {
        int index;
        int length = this.path.length();
        int firstInPath = 0;
        if (separatorChar == '\\' && length > 2 && this.path.charAt(1) == ':') {
            firstInPath = 2;
        }
        if ((index = this.path.lastIndexOf(separatorChar)) == -1 && firstInPath > 0) {
            index = 2;
        }
        if (index == -1 || this.path.charAt(length - 1) == separatorChar) {
            return null;
        }
        if (this.path.indexOf(separatorChar) == index && this.path.charAt(firstInPath) == separatorChar) {
            return this.path.substring(0, index + 1);
        }
        return this.path.substring(0, index);
    }

    public File getParentFile() {
        String tempParent = this.getParent();
        if (tempParent == null) {
            return null;
        }
        return new File(tempParent);
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.getPath().hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        return this.path.length() > 0 && this.path.charAt(0) == separatorChar;
    }

    public boolean isDirectory() {
        try {
            return OsConstants.S_ISDIR(Libcore.os.stat((String)this.path).st_mode);
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    public boolean isFile() {
        try {
            return OsConstants.S_ISREG(Libcore.os.stat((String)this.path).st_mode);
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    public boolean isHidden() {
        if (this.path.isEmpty()) {
            return false;
        }
        return this.getName().startsWith(".");
    }

    public long lastModified() {
        try {
            return Libcore.os.stat((String)this.path).st_mtime * 1000L;
        }
        catch (ErrnoException errnoException) {
            return 0L;
        }
    }

    public boolean setLastModified(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("time < 0");
        }
        return File.setLastModifiedImpl(this.path, time);
    }

    private static native boolean setLastModifiedImpl(String var0, long var1);

    public boolean setReadOnly() {
        return this.setWritable(false, false);
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return this.doChmod(ownerOnly ? OsConstants.S_IXUSR : OsConstants.S_IXUSR | OsConstants.S_IXGRP | OsConstants.S_IXOTH, executable);
    }

    public boolean setExecutable(boolean executable) {
        return this.setExecutable(executable, true);
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return this.doChmod(ownerOnly ? OsConstants.S_IRUSR : OsConstants.S_IRUSR | OsConstants.S_IRGRP | OsConstants.S_IROTH, readable);
    }

    public boolean setReadable(boolean readable) {
        return this.setReadable(readable, true);
    }

    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return this.doChmod(ownerOnly ? OsConstants.S_IWUSR : OsConstants.S_IWUSR | OsConstants.S_IWGRP | OsConstants.S_IWOTH, writable);
    }

    public boolean setWritable(boolean writable) {
        return this.setWritable(writable, true);
    }

    private boolean doChmod(int mask, boolean set) {
        try {
            StructStat sb = Libcore.os.stat(this.path);
            int newMode = set ? sb.st_mode | mask : sb.st_mode & ~mask;
            Libcore.os.chmod(this.path, newMode);
            return true;
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    public long length() {
        try {
            return Libcore.os.stat((String)this.path).st_size;
        }
        catch (ErrnoException errnoException) {
            return 0L;
        }
    }

    public String[] list() {
        return File.listImpl(this.path);
    }

    private static native String[] listImpl(String var0);

    public String[] list(FilenameFilter filter) {
        String[] filenames = this.list();
        if (filter == null || filenames == null) {
            return filenames;
        }
        ArrayList<String> result = new ArrayList<String>(filenames.length);
        for (String filename : filenames) {
            if (!filter.accept(this, filename)) continue;
            result.add(filename);
        }
        return result.toArray(new String[result.size()]);
    }

    public File[] listFiles() {
        return this.filenamesToFiles(this.list());
    }

    public File[] listFiles(FilenameFilter filter) {
        return this.filenamesToFiles(this.list(filter));
    }

    public File[] listFiles(FileFilter filter) {
        File[] files = this.listFiles();
        if (filter == null || files == null) {
            return files;
        }
        ArrayList<File> result = new ArrayList<File>(files.length);
        for (File file : files) {
            if (!filter.accept(file)) continue;
            result.add(file);
        }
        return result.toArray(new File[result.size()]);
    }

    private File[] filenamesToFiles(String[] filenames) {
        if (filenames == null) {
            return null;
        }
        int count = filenames.length;
        File[] result = new File[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new File(this, filenames[i]);
        }
        return result;
    }

    public boolean mkdir() {
        try {
            this.mkdirErrno();
            return true;
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    private void mkdirErrno() throws ErrnoException {
        Libcore.os.mkdir(this.path, OsConstants.S_IRWXU);
    }

    public boolean mkdirs() {
        return this.mkdirs(false);
    }

    private boolean mkdirs(boolean resultIfExists) {
        try {
            this.mkdirErrno();
            return true;
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.ENOENT) {
                File parent = this.getParentFile();
                return parent != null && parent.mkdirs(true) && this.mkdir();
            }
            if (errnoException.errno == OsConstants.EEXIST) {
                return resultIfExists;
            }
            return false;
        }
    }

    public boolean createNewFile() throws IOException {
        boolean bl;
        FileDescriptor fd = null;
        try {
            fd = Libcore.os.open(this.path, OsConstants.O_RDWR | OsConstants.O_CREAT | OsConstants.O_EXCL, 384);
            bl = true;
        }
        catch (ErrnoException errnoException) {
            block5: {
                boolean bl2;
                try {
                    if (errnoException.errno != OsConstants.EEXIST) break block5;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    IoUtils.close(fd);
                    throw throwable;
                }
                IoUtils.close(fd);
                return bl2;
            }
            throw errnoException.rethrowAsIOException();
        }
        IoUtils.close(fd);
        return bl;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File result;
        File tmpDirFile;
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("prefix must be at least 3 characters");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        if ((tmpDirFile = directory) == null) {
            String tmpDir = System.getProperty("java.io.tmpdir", ".");
            tmpDirFile = new File(tmpDir);
        }
        while (!(result = new File(tmpDirFile, prefix + tempFileRandom.nextInt() + suffix)).createNewFile()) {
        }
        return result;
    }

    public boolean renameTo(File newPath) {
        try {
            Libcore.os.rename(this.path, newPath.path);
            return true;
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    public String toString() {
        return this.path;
    }

    public URI toURI() {
        String name = this.getAbsoluteName();
        try {
            if (!name.startsWith("/")) {
                return new URI("file", null, "/" + name, null, null);
            }
            if (name.startsWith("//")) {
                return new URI("file", "", name, null);
            }
            return new URI("file", null, name, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Deprecated
    public URL toURL() throws MalformedURLException {
        String name = this.getAbsoluteName();
        if (!name.startsWith("/")) {
            return new URL("file", "", -1, "/" + name, null);
        }
        if (name.startsWith("//")) {
            return new URL("file:" + name);
        }
        return new URL("file", "", -1, name, null);
    }

    private String getAbsoluteName() {
        File f = this.getAbsoluteFile();
        String name = f.getPath();
        if (f.isDirectory() && name.charAt(name.length() - 1) != separatorChar) {
            name = name + "/";
        }
        if (separatorChar != '/') {
            name = name.replace(separatorChar, '/');
        }
        return name;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeChar(separatorChar);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        char inSeparator = stream.readChar();
        this.path = File.fixSlashes(this.path.replace(inSeparator, separatorChar));
    }

    public long getTotalSpace() {
        try {
            StructStatVfs sb = Libcore.os.statvfs(this.path);
            return sb.f_blocks * sb.f_bsize;
        }
        catch (ErrnoException errnoException) {
            return 0L;
        }
    }

    public long getUsableSpace() {
        try {
            StructStatVfs sb = Libcore.os.statvfs(this.path);
            return sb.f_bavail * sb.f_bsize;
        }
        catch (ErrnoException errnoException) {
            return 0L;
        }
    }

    public long getFreeSpace() {
        try {
            StructStatVfs sb = Libcore.os.statvfs(this.path);
            return sb.f_bfree * sb.f_bsize;
        }
        catch (ErrnoException errnoException) {
            return 0L;
        }
    }

    static {
        pathSeparatorChar = System.getProperty("path.separator", ":").charAt(0);
        separator = String.valueOf(separatorChar);
        pathSeparator = String.valueOf(pathSeparatorChar);
    }
}

