/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteOrder;
import java.nio.charset.ModifiedUtf8;
import libcore.io.Memory;
import libcore.io.Streams;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    private final byte[] scratch = new byte[8];

    public DataInputStream(InputStream in) {
        super(in);
    }

    public final int read(byte[] buffer) throws IOException {
        return super.read(buffer);
    }

    public final int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return this.in.read(buffer, byteOffset, byteCount);
    }

    public final boolean readBoolean() throws IOException {
        int temp = this.in.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp != 0;
    }

    public final byte readByte() throws IOException {
        int temp = this.in.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] dst) throws IOException {
        this.readFully(dst, 0, dst.length);
    }

    public final void readFully(byte[] dst, int offset, int byteCount) throws IOException {
        Streams.readFully(this.in, dst, offset, byteCount);
    }

    public final int readInt() throws IOException {
        Streams.readFully(this.in, this.scratch, 0, 4);
        return Memory.peekInt(this.scratch, 0, ByteOrder.BIG_ENDIAN);
    }

    @Deprecated
    public final String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        block5: while (true) {
            int nextByte = this.in.read();
            switch (nextByte) {
                case -1: {
                    if (line.length() == 0 && !foundTerminator) {
                        return null;
                    }
                    return line.toString();
                }
                case 13: {
                    if (foundTerminator) {
                        ((PushbackInputStream)this.in).unread(nextByte);
                        return line.toString();
                    }
                    foundTerminator = true;
                    if (this.in.getClass() == PushbackInputStream.class) continue block5;
                    this.in = new PushbackInputStream(this.in);
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                ((PushbackInputStream)this.in).unread(nextByte);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    public final long readLong() throws IOException {
        Streams.readFully(this.in, this.scratch, 0, 8);
        return Memory.peekLong(this.scratch, 0, ByteOrder.BIG_ENDIAN);
    }

    public final short readShort() throws IOException {
        Streams.readFully(this.in, this.scratch, 0, 2);
        return Memory.peekShort(this.scratch, 0, ByteOrder.BIG_ENDIAN);
    }

    public final int readUnsignedByte() throws IOException {
        int temp = this.in.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp;
    }

    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public final String readUTF() throws IOException {
        return this.decodeUTF(this.readUnsignedShort());
    }

    String decodeUTF(int utfSize) throws IOException {
        return DataInputStream.decodeUTF(utfSize, this);
    }

    private static String decodeUTF(int utfSize, DataInput in) throws IOException {
        byte[] buf = new byte[utfSize];
        in.readFully(buf, 0, utfSize);
        return ModifiedUtf8.decode(buf, new char[utfSize], 0, utfSize);
    }

    public static final String readUTF(DataInput in) throws IOException {
        return DataInputStream.decodeUTF(in.readUnsignedShort(), in);
    }

    public final int skipBytes(int count) throws IOException {
        long skip;
        int skipped = 0;
        while (skipped < count && (skip = this.in.skip(count - skipped)) != 0L) {
            skipped = (int)((long)skipped + skip);
        }
        return skipped;
    }
}

