/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] buf;
    private int pos;
    private int end;
    private int mark = -1;
    private int markLimit = -1;
    private boolean lastWasCR;
    private boolean markedLastWasCR;

    public BufferedReader(Reader in) {
        this(in, 8192);
    }

    public BufferedReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.in = in;
        this.buf = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                this.in.close();
                this.buf = null;
            }
        }
    }

    private int fillBuf() throws IOException {
        if (this.mark == -1 || this.pos - this.mark >= this.markLimit) {
            int result = this.in.read(this.buf, 0, this.buf.length);
            if (result > 0) {
                this.mark = -1;
                this.pos = 0;
                this.end = result;
            }
            return result;
        }
        if (this.mark == 0 && this.markLimit > this.buf.length) {
            int newLength = this.buf.length * 2;
            if (newLength > this.markLimit) {
                newLength = this.markLimit;
            }
            char[] newbuf = new char[newLength];
            System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
            this.buf = newbuf;
        } else if (this.mark > 0) {
            System.arraycopy(this.buf, this.mark, this.buf, 0, this.buf.length - this.mark);
            this.pos -= this.mark;
            this.end -= this.mark;
            this.mark = 0;
        }
        int count = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (count != -1) {
            this.end += count;
        }
        return count;
    }

    private boolean isClosed() {
        return this.buf == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int markLimit) throws IOException {
        if (markLimit < 0) {
            throw new IllegalArgumentException("markLimit < 0:" + markLimit);
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.markLimit = markLimit;
            this.mark = this.pos;
            this.markedLastWasCR = this.lastWasCR;
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("BufferedReader is closed");
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            int ch = this.readChar();
            if (this.lastWasCR && ch == 10) {
                ch = this.readChar();
            }
            this.lastWasCR = false;
            return ch;
        }
    }

    private int readChar() throws IOException {
        if (this.pos < this.end || this.fillBuf() != -1) {
            return this.buf[this.pos++];
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int count;
            this.checkNotClosed();
            Arrays.checkOffsetAndCount(buffer.length, offset, length);
            if (length == 0) {
                return 0;
            }
            this.maybeSwallowLF();
            int outstanding = length;
            while (outstanding > 0) {
                int count2;
                int available = this.end - this.pos;
                if (available > 0) {
                    count2 = available >= outstanding ? outstanding : available;
                    System.arraycopy(this.buf, this.pos, buffer, offset, count2);
                    this.pos += count2;
                    offset += count2;
                    outstanding -= count2;
                }
                if (outstanding == 0 || outstanding < length && !this.in.ready()) break;
                if ((this.mark == -1 || this.pos - this.mark >= this.markLimit) && outstanding >= this.buf.length) {
                    count2 = this.in.read(buffer, offset, outstanding);
                    if (count2 <= 0) break;
                    outstanding -= count2;
                    this.mark = -1;
                    break;
                }
                if (this.fillBuf() != -1) continue;
                break;
            }
            if ((count = length - outstanding) > 0) {
                return count;
            }
            return -1;
        }
    }

    final void chompNewline() throws IOException {
        if ((this.pos != this.end || this.fillBuf() != -1) && this.buf[this.pos] == '\n') {
            ++this.pos;
        }
    }

    private void maybeSwallowLF() throws IOException {
        if (this.lastWasCR) {
            this.chompNewline();
            this.lastWasCR = false;
        }
    }

    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.maybeSwallowLF();
            for (int i = this.pos; i < this.end; ++i) {
                char ch = this.buf[i];
                if (ch != '\n' && ch != '\r') continue;
                String line = new String(this.buf, this.pos, i - this.pos);
                this.pos = i + 1;
                this.lastWasCR = ch == '\r';
                return line;
            }
            StringBuilder result = new StringBuilder(this.end - this.pos + 80);
            result.append(this.buf, this.pos, this.end - this.pos);
            while (true) {
                this.pos = this.end;
                if (this.fillBuf() == -1) {
                    return result.length() > 0 ? result.toString() : null;
                }
                for (int i = this.pos; i < this.end; ++i) {
                    char ch = this.buf[i];
                    if (ch != '\n' && ch != '\r') continue;
                    result.append(this.buf, this.pos, i - this.pos);
                    this.pos = i + 1;
                    this.lastWasCR = ch == '\r';
                    return result.toString();
                }
                result.append(this.buf, this.pos, this.end - this.pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            return this.end - this.pos > 0 || this.in.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.mark == -1) {
                throw new IOException("Invalid mark");
            }
            this.pos = this.mark;
            this.lastWasCR = this.markedLastWasCR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long charCount) throws IOException {
        if (charCount < 0L) {
            throw new IllegalArgumentException("charCount < 0: " + charCount);
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if ((long)(this.end - this.pos) >= charCount) {
                this.pos = (int)((long)this.pos + charCount);
                return charCount;
            }
            this.pos = this.end;
            for (long read = (long)(this.end - this.pos); read < charCount; read += (long)(this.end - this.pos)) {
                if (this.fillBuf() == -1) {
                    return read;
                }
                if ((long)(this.end - this.pos) >= charCount - read) {
                    this.pos = (int)((long)this.pos + (charCount - read));
                    return charCount;
                }
                this.pos = this.end;
            }
            return charCount;
        }
    }
}

