/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import dalvik.system.profiler.BinaryHprof;
import dalvik.system.profiler.HprofData;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BinaryHprofWriter {
    private int nextStringId = 1;
    private int nextClassId = 1;
    private int nextStackFrameId = 1;
    private final Map<String, Integer> stringToId = new HashMap<String, Integer>();
    private final Map<String, Integer> classNameToId = new HashMap<String, Integer>();
    private final Map<StackTraceElement, Integer> stackFrameToId = new HashMap<StackTraceElement, Integer>();
    private final HprofData data;
    private final DataOutputStream out;

    public static void write(HprofData data, OutputStream outputStream) throws IOException {
        new BinaryHprofWriter(data, outputStream).write();
    }

    private BinaryHprofWriter(HprofData data, OutputStream outputStream) {
        this.data = data;
        this.out = new DataOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws IOException {
        try {
            this.writeHeader(this.data.getStartMillis());
            this.writeControlSettings(this.data.getFlags(), this.data.getDepth());
            for (HprofData.ThreadEvent event : this.data.getThreadHistory()) {
                this.writeThreadEvent(event);
            }
            Set<HprofData.Sample> samples = this.data.getSamples();
            int total = 0;
            for (HprofData.Sample sample : samples) {
                total += sample.count;
                this.writeStackTrace(sample.stackTrace);
            }
            this.writeCpuSamples(total, samples);
        }
        finally {
            this.out.flush();
        }
    }

    private void writeHeader(long dumpTimeInMilliseconds) throws IOException {
        this.out.writeBytes(BinaryHprof.MAGIC + "1.0.2");
        this.out.writeByte(0);
        this.out.writeInt(4);
        this.out.writeLong(dumpTimeInMilliseconds);
    }

    private void writeControlSettings(int flags, int depth) throws IOException {
        if (depth > Short.MAX_VALUE) {
            throw new IllegalArgumentException("depth too large for binary hprof: " + depth + " > " + Short.MAX_VALUE);
        }
        this.writeRecordHeader(BinaryHprof.Tag.CONTROL_SETTINGS, 0, BinaryHprof.Tag.CONTROL_SETTINGS.maximumSize);
        this.out.writeInt(flags);
        this.out.writeShort((short)depth);
    }

    private void writeThreadEvent(HprofData.ThreadEvent e) throws IOException {
        switch (e.type) {
            case START: {
                this.writeStartThread(e);
                return;
            }
            case END: {
                this.writeStopThread(e);
                return;
            }
        }
        throw new IllegalStateException(e.type.toString());
    }

    private void writeStartThread(HprofData.ThreadEvent e) throws IOException {
        int threadNameId = this.writeString(e.threadName);
        int groupNameId = this.writeString(e.groupName);
        int parentGroupNameId = this.writeString(e.parentGroupName);
        this.writeRecordHeader(BinaryHprof.Tag.START_THREAD, 0, BinaryHprof.Tag.START_THREAD.maximumSize);
        this.out.writeInt(e.threadId);
        this.writeId(e.objectId);
        this.out.writeInt(0);
        this.writeId(threadNameId);
        this.writeId(groupNameId);
        this.writeId(parentGroupNameId);
    }

    private void writeStopThread(HprofData.ThreadEvent e) throws IOException {
        this.writeRecordHeader(BinaryHprof.Tag.END_THREAD, 0, BinaryHprof.Tag.END_THREAD.maximumSize);
        this.out.writeInt(e.threadId);
    }

    private void writeRecordHeader(BinaryHprof.Tag hprofTag, int timeDeltaInMicroseconds, int recordLength) throws IOException {
        String error = hprofTag.checkSize(recordLength);
        if (error != null) {
            throw new AssertionError((Object)error);
        }
        this.out.writeByte(hprofTag.tag);
        this.out.writeInt(timeDeltaInMicroseconds);
        this.out.writeInt(recordLength);
    }

    private void writeId(int id2) throws IOException {
        this.out.writeInt(id2);
    }

    private int writeString(String string2) throws IOException {
        if (string2 == null) {
            return 0;
        }
        Integer identifier = this.stringToId.get(string2);
        if (identifier != null) {
            return identifier;
        }
        int id2 = this.nextStringId++;
        this.stringToId.put(string2, id2);
        byte[] bytes = string2.getBytes("UTF-8");
        this.writeRecordHeader(BinaryHprof.Tag.STRING_IN_UTF8, 0, 4 + bytes.length);
        this.out.writeInt(id2);
        this.out.write(bytes, 0, bytes.length);
        return id2;
    }

    private void writeCpuSamples(int totalSamples, Set<HprofData.Sample> samples) throws IOException {
        int samplesCount = samples.size();
        if (samplesCount == 0) {
            return;
        }
        this.writeRecordHeader(BinaryHprof.Tag.CPU_SAMPLES, 0, 8 + samplesCount * 8);
        this.out.writeInt(totalSamples);
        this.out.writeInt(samplesCount);
        for (HprofData.Sample sample : samples) {
            this.out.writeInt(sample.count);
            this.out.writeInt(sample.stackTrace.stackTraceId);
        }
    }

    private void writeStackTrace(HprofData.StackTrace stackTrace) throws IOException {
        int frames = stackTrace.stackFrames.length;
        int[] stackFrameIds = new int[frames];
        for (int i = 0; i < frames; ++i) {
            stackFrameIds[i] = this.writeStackFrame(stackTrace.stackFrames[i]);
        }
        this.writeRecordHeader(BinaryHprof.Tag.STACK_TRACE, 0, 12 + frames * 4);
        this.out.writeInt(stackTrace.stackTraceId);
        this.out.writeInt(stackTrace.threadId);
        this.out.writeInt(frames);
        for (int stackFrameId : stackFrameIds) {
            this.writeId(stackFrameId);
        }
    }

    private int writeLoadClass(String className) throws IOException {
        Integer identifier = this.classNameToId.get(className);
        if (identifier != null) {
            return identifier;
        }
        int id2 = this.nextClassId++;
        this.classNameToId.put(className, id2);
        int classNameId = this.writeString(className);
        this.writeRecordHeader(BinaryHprof.Tag.LOAD_CLASS, 0, BinaryHprof.Tag.LOAD_CLASS.maximumSize);
        this.out.writeInt(id2);
        this.writeId(0);
        this.out.writeInt(0);
        this.writeId(classNameId);
        return id2;
    }

    private int writeStackFrame(StackTraceElement stackFrame) throws IOException {
        Integer identifier = this.stackFrameToId.get(stackFrame);
        if (identifier != null) {
            return identifier;
        }
        int id2 = this.nextStackFrameId++;
        this.stackFrameToId.put(stackFrame, id2);
        int classId = this.writeLoadClass(stackFrame.getClassName());
        int methodNameId = this.writeString(stackFrame.getMethodName());
        int sourceId = this.writeString(stackFrame.getFileName());
        this.writeRecordHeader(BinaryHprof.Tag.STACK_FRAME, 0, BinaryHprof.Tag.STACK_FRAME.maximumSize);
        this.writeId(id2);
        this.writeId(methodNameId);
        this.writeId(0);
        this.writeId(sourceId);
        this.out.writeInt(classId);
        this.out.writeInt(stackFrame.getLineNumber());
        return id2;
    }
}

