/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gles_jni;

import android.app.AppGlobals;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL10Ext;
import javax.microedition.khronos.opengles.GL11;
import javax.microedition.khronos.opengles.GL11Ext;
import javax.microedition.khronos.opengles.GL11ExtensionPack;

public class GLImpl
implements GL10,
GL10Ext,
GL11,
GL11Ext,
GL11ExtensionPack {
    Buffer _colorPointer = null;
    Buffer _normalPointer = null;
    Buffer _texCoordPointer = null;
    Buffer _vertexPointer = null;
    Buffer _pointSizePointerOES = null;
    Buffer _matrixIndexPointerOES = null;
    Buffer _weightPointerOES = null;
    private boolean haveCheckedExtensions;
    private boolean have_OES_blend_equation_separate;
    private boolean have_OES_blend_subtract;
    private boolean have_OES_framebuffer_object;
    private boolean have_OES_texture_cube_map;

    private static native void _nativeClassInit();

    public void glGetPointerv(int pname, Buffer[] params) {
        throw new UnsupportedOperationException("glGetPointerv");
    }

    private static boolean allowIndirectBuffers(String appName) {
        boolean result = false;
        int version = 0;
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(appName, 0, UserHandle.myUserId());
            if (applicationInfo != null) {
                version = applicationInfo.targetSdkVersion;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        Log.e("OpenGLES", String.format("Application %s (SDK target %d) called a GL11 Pointer method with an indirect Buffer.", appName, version));
        if (version <= 3) {
            result = true;
        }
        return result;
    }

    public native void glActiveTexture(int var1);

    public native void glAlphaFunc(int var1, float var2);

    public native void glAlphaFuncx(int var1, int var2);

    public native void glBindTexture(int var1, int var2);

    public native void glBlendFunc(int var1, int var2);

    public native void glClear(int var1);

    public native void glClearColor(float var1, float var2, float var3, float var4);

    public native void glClearColorx(int var1, int var2, int var3, int var4);

    public native void glClearDepthf(float var1);

    public native void glClearDepthx(int var1);

    public native void glClearStencil(int var1);

    public native void glClientActiveTexture(int var1);

    public native void glColor4f(float var1, float var2, float var3, float var4);

    public native void glColor4x(int var1, int var2, int var3, int var4);

    public native void glColorMask(boolean var1, boolean var2, boolean var3, boolean var4);

    private native void glColorPointerBounds(int var1, int var2, int var3, Buffer var4, int var5);

    public void glColorPointer(int size, int type, int stride, Buffer pointer) {
        this.glColorPointerBounds(size, type, stride, pointer, pointer.remaining());
        if (size == 4 && (type == 5126 || type == 5121 || type == 5132) && stride >= 0) {
            this._colorPointer = pointer;
        }
    }

    public native void glCompressedTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, Buffer var8);

    public native void glCompressedTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public native void glCopyTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public native void glCopyTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public native void glCullFace(int var1);

    public native void glDeleteTextures(int var1, int[] var2, int var3);

    public native void glDeleteTextures(int var1, IntBuffer var2);

    public native void glDepthFunc(int var1);

    public native void glDepthMask(boolean var1);

    public native void glDepthRangef(float var1, float var2);

    public native void glDepthRangex(int var1, int var2);

    public native void glDisable(int var1);

    public native void glDisableClientState(int var1);

    public native void glDrawArrays(int var1, int var2, int var3);

    public native void glDrawElements(int var1, int var2, int var3, Buffer var4);

    public native void glEnable(int var1);

    public native void glEnableClientState(int var1);

    public native void glFinish();

    public native void glFlush();

    public native void glFogf(int var1, float var2);

    public native void glFogfv(int var1, float[] var2, int var3);

    public native void glFogfv(int var1, FloatBuffer var2);

    public native void glFogx(int var1, int var2);

    public native void glFogxv(int var1, int[] var2, int var3);

    public native void glFogxv(int var1, IntBuffer var2);

    public native void glFrontFace(int var1);

    public native void glFrustumf(float var1, float var2, float var3, float var4, float var5, float var6);

    public native void glFrustumx(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void glGenTextures(int var1, int[] var2, int var3);

    public native void glGenTextures(int var1, IntBuffer var2);

    public native int glGetError();

    public native void glGetIntegerv(int var1, int[] var2, int var3);

    public native void glGetIntegerv(int var1, IntBuffer var2);

    public native String _glGetString(int var1);

    public String glGetString(int name) {
        String returnValue = this._glGetString(name);
        return returnValue;
    }

    public native void glHint(int var1, int var2);

    public native void glLightModelf(int var1, float var2);

    public native void glLightModelfv(int var1, float[] var2, int var3);

    public native void glLightModelfv(int var1, FloatBuffer var2);

    public native void glLightModelx(int var1, int var2);

    public native void glLightModelxv(int var1, int[] var2, int var3);

    public native void glLightModelxv(int var1, IntBuffer var2);

    public native void glLightf(int var1, int var2, float var3);

    public native void glLightfv(int var1, int var2, float[] var3, int var4);

    public native void glLightfv(int var1, int var2, FloatBuffer var3);

    public native void glLightx(int var1, int var2, int var3);

    public native void glLightxv(int var1, int var2, int[] var3, int var4);

    public native void glLightxv(int var1, int var2, IntBuffer var3);

    public native void glLineWidth(float var1);

    public native void glLineWidthx(int var1);

    public native void glLoadIdentity();

    public native void glLoadMatrixf(float[] var1, int var2);

    public native void glLoadMatrixf(FloatBuffer var1);

    public native void glLoadMatrixx(int[] var1, int var2);

    public native void glLoadMatrixx(IntBuffer var1);

    public native void glLogicOp(int var1);

    public native void glMaterialf(int var1, int var2, float var3);

    public native void glMaterialfv(int var1, int var2, float[] var3, int var4);

    public native void glMaterialfv(int var1, int var2, FloatBuffer var3);

    public native void glMaterialx(int var1, int var2, int var3);

    public native void glMaterialxv(int var1, int var2, int[] var3, int var4);

    public native void glMaterialxv(int var1, int var2, IntBuffer var3);

    public native void glMatrixMode(int var1);

    public native void glMultMatrixf(float[] var1, int var2);

    public native void glMultMatrixf(FloatBuffer var1);

    public native void glMultMatrixx(int[] var1, int var2);

    public native void glMultMatrixx(IntBuffer var1);

    public native void glMultiTexCoord4f(int var1, float var2, float var3, float var4, float var5);

    public native void glMultiTexCoord4x(int var1, int var2, int var3, int var4, int var5);

    public native void glNormal3f(float var1, float var2, float var3);

    public native void glNormal3x(int var1, int var2, int var3);

    private native void glNormalPointerBounds(int var1, int var2, Buffer var3, int var4);

    public void glNormalPointer(int type, int stride, Buffer pointer) {
        this.glNormalPointerBounds(type, stride, pointer, pointer.remaining());
        if ((type == 5126 || type == 5120 || type == 5122 || type == 5132) && stride >= 0) {
            this._normalPointer = pointer;
        }
    }

    public native void glOrthof(float var1, float var2, float var3, float var4, float var5, float var6);

    public native void glOrthox(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void glPixelStorei(int var1, int var2);

    public native void glPointSize(float var1);

    public native void glPointSizex(int var1);

    public native void glPolygonOffset(float var1, float var2);

    public native void glPolygonOffsetx(int var1, int var2);

    public native void glPopMatrix();

    public native void glPushMatrix();

    public native void glReadPixels(int var1, int var2, int var3, int var4, int var5, int var6, Buffer var7);

    public native void glRotatef(float var1, float var2, float var3, float var4);

    public native void glRotatex(int var1, int var2, int var3, int var4);

    public native void glSampleCoverage(float var1, boolean var2);

    public native void glSampleCoveragex(int var1, boolean var2);

    public native void glScalef(float var1, float var2, float var3);

    public native void glScalex(int var1, int var2, int var3);

    public native void glScissor(int var1, int var2, int var3, int var4);

    public native void glShadeModel(int var1);

    public native void glStencilFunc(int var1, int var2, int var3);

    public native void glStencilMask(int var1);

    public native void glStencilOp(int var1, int var2, int var3);

    private native void glTexCoordPointerBounds(int var1, int var2, int var3, Buffer var4, int var5);

    public void glTexCoordPointer(int size, int type, int stride, Buffer pointer) {
        this.glTexCoordPointerBounds(size, type, stride, pointer, pointer.remaining());
        if (!(size != 2 && size != 3 && size != 4 || type != 5126 && type != 5120 && type != 5122 && type != 5132 || stride < 0)) {
            this._texCoordPointer = pointer;
        }
    }

    public native void glTexEnvf(int var1, int var2, float var3);

    public native void glTexEnvfv(int var1, int var2, float[] var3, int var4);

    public native void glTexEnvfv(int var1, int var2, FloatBuffer var3);

    public native void glTexEnvx(int var1, int var2, int var3);

    public native void glTexEnvxv(int var1, int var2, int[] var3, int var4);

    public native void glTexEnvxv(int var1, int var2, IntBuffer var3);

    public native void glTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public native void glTexParameterf(int var1, int var2, float var3);

    public native void glTexParameterx(int var1, int var2, int var3);

    public native void glTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    public native void glTranslatef(float var1, float var2, float var3);

    public native void glTranslatex(int var1, int var2, int var3);

    private native void glVertexPointerBounds(int var1, int var2, int var3, Buffer var4, int var5);

    public void glVertexPointer(int size, int type, int stride, Buffer pointer) {
        this.glVertexPointerBounds(size, type, stride, pointer, pointer.remaining());
        if (!(size != 2 && size != 3 && size != 4 || type != 5126 && type != 5120 && type != 5122 && type != 5132 || stride < 0)) {
            this._vertexPointer = pointer;
        }
    }

    public native void glViewport(int var1, int var2, int var3, int var4);

    public native int glQueryMatrixxOES(int[] var1, int var2, int[] var3, int var4);

    public native int glQueryMatrixxOES(IntBuffer var1, IntBuffer var2);

    public native void glBindBuffer(int var1, int var2);

    public native void glBufferData(int var1, int var2, Buffer var3, int var4);

    public native void glBufferSubData(int var1, int var2, int var3, Buffer var4);

    public native void glClipPlanef(int var1, float[] var2, int var3);

    public native void glClipPlanef(int var1, FloatBuffer var2);

    public native void glClipPlanex(int var1, int[] var2, int var3);

    public native void glClipPlanex(int var1, IntBuffer var2);

    public native void glColor4ub(byte var1, byte var2, byte var3, byte var4);

    public native void glColorPointer(int var1, int var2, int var3, int var4);

    public native void glDeleteBuffers(int var1, int[] var2, int var3);

    public native void glDeleteBuffers(int var1, IntBuffer var2);

    public native void glDrawElements(int var1, int var2, int var3, int var4);

    public native void glGenBuffers(int var1, int[] var2, int var3);

    public native void glGenBuffers(int var1, IntBuffer var2);

    public native void glGetBooleanv(int var1, boolean[] var2, int var3);

    public native void glGetBooleanv(int var1, IntBuffer var2);

    public native void glGetBufferParameteriv(int var1, int var2, int[] var3, int var4);

    public native void glGetBufferParameteriv(int var1, int var2, IntBuffer var3);

    public native void glGetClipPlanef(int var1, float[] var2, int var3);

    public native void glGetClipPlanef(int var1, FloatBuffer var2);

    public native void glGetClipPlanex(int var1, int[] var2, int var3);

    public native void glGetClipPlanex(int var1, IntBuffer var2);

    public native void glGetFixedv(int var1, int[] var2, int var3);

    public native void glGetFixedv(int var1, IntBuffer var2);

    public native void glGetFloatv(int var1, float[] var2, int var3);

    public native void glGetFloatv(int var1, FloatBuffer var2);

    public native void glGetLightfv(int var1, int var2, float[] var3, int var4);

    public native void glGetLightfv(int var1, int var2, FloatBuffer var3);

    public native void glGetLightxv(int var1, int var2, int[] var3, int var4);

    public native void glGetLightxv(int var1, int var2, IntBuffer var3);

    public native void glGetMaterialfv(int var1, int var2, float[] var3, int var4);

    public native void glGetMaterialfv(int var1, int var2, FloatBuffer var3);

    public native void glGetMaterialxv(int var1, int var2, int[] var3, int var4);

    public native void glGetMaterialxv(int var1, int var2, IntBuffer var3);

    public native void glGetTexEnviv(int var1, int var2, int[] var3, int var4);

    public native void glGetTexEnviv(int var1, int var2, IntBuffer var3);

    public native void glGetTexEnvxv(int var1, int var2, int[] var3, int var4);

    public native void glGetTexEnvxv(int var1, int var2, IntBuffer var3);

    public native void glGetTexParameterfv(int var1, int var2, float[] var3, int var4);

    public native void glGetTexParameterfv(int var1, int var2, FloatBuffer var3);

    public native void glGetTexParameteriv(int var1, int var2, int[] var3, int var4);

    public native void glGetTexParameteriv(int var1, int var2, IntBuffer var3);

    public native void glGetTexParameterxv(int var1, int var2, int[] var3, int var4);

    public native void glGetTexParameterxv(int var1, int var2, IntBuffer var3);

    public native boolean glIsBuffer(int var1);

    public native boolean glIsEnabled(int var1);

    public native boolean glIsTexture(int var1);

    public native void glNormalPointer(int var1, int var2, int var3);

    public native void glPointParameterf(int var1, float var2);

    public native void glPointParameterfv(int var1, float[] var2, int var3);

    public native void glPointParameterfv(int var1, FloatBuffer var2);

    public native void glPointParameterx(int var1, int var2);

    public native void glPointParameterxv(int var1, int[] var2, int var3);

    public native void glPointParameterxv(int var1, IntBuffer var2);

    private native void glPointSizePointerOESBounds(int var1, int var2, Buffer var3, int var4);

    public void glPointSizePointerOES(int type, int stride, Buffer pointer) {
        this.glPointSizePointerOESBounds(type, stride, pointer, pointer.remaining());
        if ((type == 5126 || type == 5132) && stride >= 0) {
            this._pointSizePointerOES = pointer;
        }
    }

    public native void glTexCoordPointer(int var1, int var2, int var3, int var4);

    public native void glTexEnvi(int var1, int var2, int var3);

    public native void glTexEnviv(int var1, int var2, int[] var3, int var4);

    public native void glTexEnviv(int var1, int var2, IntBuffer var3);

    public native void glTexParameterfv(int var1, int var2, float[] var3, int var4);

    public native void glTexParameterfv(int var1, int var2, FloatBuffer var3);

    public native void glTexParameteri(int var1, int var2, int var3);

    public native void glTexParameteriv(int var1, int var2, int[] var3, int var4);

    public native void glTexParameteriv(int var1, int var2, IntBuffer var3);

    public native void glTexParameterxv(int var1, int var2, int[] var3, int var4);

    public native void glTexParameterxv(int var1, int var2, IntBuffer var3);

    public native void glVertexPointer(int var1, int var2, int var3, int var4);

    public native void glCurrentPaletteMatrixOES(int var1);

    public native void glDrawTexfOES(float var1, float var2, float var3, float var4, float var5);

    public native void glDrawTexfvOES(float[] var1, int var2);

    public native void glDrawTexfvOES(FloatBuffer var1);

    public native void glDrawTexiOES(int var1, int var2, int var3, int var4, int var5);

    public native void glDrawTexivOES(int[] var1, int var2);

    public native void glDrawTexivOES(IntBuffer var1);

    public native void glDrawTexsOES(short var1, short var2, short var3, short var4, short var5);

    public native void glDrawTexsvOES(short[] var1, int var2);

    public native void glDrawTexsvOES(ShortBuffer var1);

    public native void glDrawTexxOES(int var1, int var2, int var3, int var4, int var5);

    public native void glDrawTexxvOES(int[] var1, int var2);

    public native void glDrawTexxvOES(IntBuffer var1);

    public native void glLoadPaletteFromModelViewMatrixOES();

    private native void glMatrixIndexPointerOESBounds(int var1, int var2, int var3, Buffer var4, int var5);

    public void glMatrixIndexPointerOES(int size, int type, int stride, Buffer pointer) {
        this.glMatrixIndexPointerOESBounds(size, type, stride, pointer, pointer.remaining());
        if (!(size != 2 && size != 3 && size != 4 || type != 5126 && type != 5120 && type != 5122 && type != 5132 || stride < 0)) {
            this._matrixIndexPointerOES = pointer;
        }
    }

    public native void glMatrixIndexPointerOES(int var1, int var2, int var3, int var4);

    private native void glWeightPointerOESBounds(int var1, int var2, int var3, Buffer var4, int var5);

    public void glWeightPointerOES(int size, int type, int stride, Buffer pointer) {
        this.glWeightPointerOESBounds(size, type, stride, pointer, pointer.remaining());
    }

    public native void glWeightPointerOES(int var1, int var2, int var3, int var4);

    public native void glBindFramebufferOES(int var1, int var2);

    public native void glBindRenderbufferOES(int var1, int var2);

    public native void glBlendEquation(int var1);

    public native void glBlendEquationSeparate(int var1, int var2);

    public native void glBlendFuncSeparate(int var1, int var2, int var3, int var4);

    public native int glCheckFramebufferStatusOES(int var1);

    public native void glDeleteFramebuffersOES(int var1, int[] var2, int var3);

    public native void glDeleteFramebuffersOES(int var1, IntBuffer var2);

    public native void glDeleteRenderbuffersOES(int var1, int[] var2, int var3);

    public native void glDeleteRenderbuffersOES(int var1, IntBuffer var2);

    public native void glFramebufferRenderbufferOES(int var1, int var2, int var3, int var4);

    public native void glFramebufferTexture2DOES(int var1, int var2, int var3, int var4, int var5);

    public native void glGenerateMipmapOES(int var1);

    public native void glGenFramebuffersOES(int var1, int[] var2, int var3);

    public native void glGenFramebuffersOES(int var1, IntBuffer var2);

    public native void glGenRenderbuffersOES(int var1, int[] var2, int var3);

    public native void glGenRenderbuffersOES(int var1, IntBuffer var2);

    public native void glGetFramebufferAttachmentParameterivOES(int var1, int var2, int var3, int[] var4, int var5);

    public native void glGetFramebufferAttachmentParameterivOES(int var1, int var2, int var3, IntBuffer var4);

    public native void glGetRenderbufferParameterivOES(int var1, int var2, int[] var3, int var4);

    public native void glGetRenderbufferParameterivOES(int var1, int var2, IntBuffer var3);

    public native void glGetTexGenfv(int var1, int var2, float[] var3, int var4);

    public native void glGetTexGenfv(int var1, int var2, FloatBuffer var3);

    public native void glGetTexGeniv(int var1, int var2, int[] var3, int var4);

    public native void glGetTexGeniv(int var1, int var2, IntBuffer var3);

    public native void glGetTexGenxv(int var1, int var2, int[] var3, int var4);

    public native void glGetTexGenxv(int var1, int var2, IntBuffer var3);

    public native boolean glIsFramebufferOES(int var1);

    public native boolean glIsRenderbufferOES(int var1);

    public native void glRenderbufferStorageOES(int var1, int var2, int var3, int var4);

    public native void glTexGenf(int var1, int var2, float var3);

    public native void glTexGenfv(int var1, int var2, float[] var3, int var4);

    public native void glTexGenfv(int var1, int var2, FloatBuffer var3);

    public native void glTexGeni(int var1, int var2, int var3);

    public native void glTexGeniv(int var1, int var2, int[] var3, int var4);

    public native void glTexGeniv(int var1, int var2, IntBuffer var3);

    public native void glTexGenx(int var1, int var2, int var3);

    public native void glTexGenxv(int var1, int var2, int[] var3, int var4);

    public native void glTexGenxv(int var1, int var2, IntBuffer var3);

    static {
        GLImpl._nativeClassInit();
    }
}

