/*
 * Decompiled with CFR 0.152.
 */
package com.android.webview.chromium;

import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.http.SslCertificate;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.print.PrintDocumentAdapter;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.view.HardwareCanvas;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.webkit.DownloadListener;
import android.webkit.FindActionModeCallback;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewProvider;
import android.widget.TextView;
import com.android.org.chromium.android_webview.AwContents;
import com.android.org.chromium.android_webview.AwContentsClient;
import com.android.org.chromium.android_webview.AwLayoutSizer;
import com.android.org.chromium.android_webview.AwPrintDocumentAdapter;
import com.android.org.chromium.android_webview.AwSettings;
import com.android.org.chromium.base.ThreadUtils;
import com.android.org.chromium.content.browser.LoadUrlParams;
import com.android.webview.chromium.ContentSettingsAdapter;
import com.android.webview.chromium.DrawGLFunctor;
import com.android.webview.chromium.UnimplementedWebViewApi;
import com.android.webview.chromium.WebBackForwardListChromium;
import com.android.webview.chromium.WebViewChromiumFactoryProvider;
import com.android.webview.chromium.WebViewContentsClientAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebViewChromium
implements WebViewProvider,
WebViewProvider.ScrollDelegate,
WebViewProvider.ViewDelegate {
    private WebViewChromiumRunQueue mRunQueue;
    private static final String TAG = WebViewChromium.class.getSimpleName();
    WebView mWebView;
    WebView.PrivateAccess mWebViewPrivate;
    private WebViewContentsClientAdapter mContentsClientAdapter;
    private ContentSettingsAdapter mWebSettings;
    private AwContents mAwContents;
    private DrawGLFunctor mGLfunctor;
    private final WebView.HitTestResult mHitTestResult;
    private final int mAppTargetSdkVersion;
    private WebViewChromiumFactoryProvider mFactory;

    public WebViewChromium(WebViewChromiumFactoryProvider factory, WebView webView, WebView.PrivateAccess webViewPrivate) {
        this.mWebView = webView;
        this.mWebViewPrivate = webViewPrivate;
        this.mHitTestResult = new WebView.HitTestResult();
        this.mAppTargetSdkVersion = this.mWebView.getContext().getApplicationInfo().targetSdkVersion;
        this.mFactory = factory;
        this.mRunQueue = new WebViewChromiumRunQueue();
    }

    static void completeWindowCreation(WebView parent, WebView child) {
        AwContents parentContents = ((WebViewChromium)parent.getWebViewProvider()).mAwContents;
        AwContents childContents = child == null ? null : ((WebViewChromium)child.getWebViewProvider()).mAwContents;
        parentContents.supplyContentsForPopup(childContents);
    }

    private <T> T runBlockingFuture(FutureTask<T> task) {
        if (!this.mFactory.hasStarted()) {
            throw new RuntimeException("Must be started before we block!");
        }
        if (ThreadUtils.runningOnUiThread()) {
            throw new IllegalStateException("This method should only be called off the UI thread");
        }
        this.mRunQueue.addTask(task);
        try {
            return task.get(4L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Probable deadlock detected due to WebView API being called on incorrect thread while the UI thread is blocked.", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void runVoidTaskOnUiThreadBlocking(Runnable r) {
        FutureTask<Object> task = new FutureTask<Object>(r, null);
        this.runBlockingFuture(task);
    }

    private <T> T runOnUiThreadBlocking(Callable<T> c) {
        return this.runBlockingFuture(new FutureTask<T>(c));
    }

    @Override
    public void init(Map<String, Object> javaScriptInterfaces, final boolean privateBrowsing) {
        if (privateBrowsing) {
            this.mFactory.startYourEngines(true);
            String msg = "Private browsing is not supported in WebView.";
            if (this.mAppTargetSdkVersion >= 19) {
                throw new IllegalArgumentException("Private browsing is not supported in WebView.");
            }
            Log.w(TAG, "Private browsing is not supported in WebView.");
            TextView warningLabel = new TextView(this.mWebView.getContext());
            warningLabel.setText(this.mWebView.getContext().getString(17040940));
            this.mWebView.addView(warningLabel);
        }
        if (this.mAppTargetSdkVersion >= 18) {
            this.mFactory.startYourEngines(false);
            this.checkThread();
        } else if (!this.mFactory.hasStarted() && Looper.myLooper() == Looper.getMainLooper()) {
            this.mFactory.startYourEngines(true);
        }
        boolean isAccessFromFileURLsGrantedByDefault = this.mAppTargetSdkVersion < 16;
        boolean areLegacyQuirksEnabled = this.mAppTargetSdkVersion < 19;
        this.mContentsClientAdapter = new WebViewContentsClientAdapter(this.mWebView);
        this.mWebSettings = new ContentSettingsAdapter(new AwSettings(this.mWebView.getContext(), isAccessFromFileURLsGrantedByDefault, areLegacyQuirksEnabled));
        this.mRunQueue.addTask(new Runnable(){

            public void run() {
                WebViewChromium.this.initForReal();
                if (privateBrowsing) {
                    WebViewChromium.this.destroy();
                }
            }
        });
    }

    private void initForReal() {
        this.mAwContents = new AwContents(this.mFactory.getBrowserContext(), (ViewGroup)this.mWebView, (AwContents.InternalAccessDelegate)new InternalAccessAdapter(), (AwContentsClient)this.mContentsClientAdapter, new AwLayoutSizer(), this.mWebSettings.getAwSettings());
        if (this.mAppTargetSdkVersion >= 19) {
            AwContents.setShouldDownloadFavicons();
        }
    }

    void startYourEngine() {
        this.mRunQueue.drainQueue();
    }

    private RuntimeException createThreadException() {
        return new IllegalStateException("Calling View methods on another thread than the UI thread.");
    }

    private boolean checkNeedsPost() {
        boolean needsPost;
        boolean bl = needsPost = !this.mFactory.hasStarted() || !ThreadUtils.runningOnUiThread();
        if (!needsPost && this.mAwContents == null) {
            throw new IllegalStateException("AwContents must be created if we are not posting!");
        }
        return needsPost;
    }

    private void checkThread() {
        if (!ThreadUtils.runningOnUiThread()) {
            final RuntimeException threadViolation = this.createThreadException();
            ThreadUtils.postOnUiThread(new Runnable(){

                public void run() {
                    throw threadViolation;
                }
            });
            throw this.createThreadException();
        }
    }

    @Override
    public void setHorizontalScrollbarOverlay(final boolean overlay) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.setHorizontalScrollbarOverlay(overlay);
                }
            });
            return;
        }
        this.mAwContents.setHorizontalScrollbarOverlay(overlay);
    }

    @Override
    public void setVerticalScrollbarOverlay(final boolean overlay) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.setVerticalScrollbarOverlay(overlay);
                }
            });
            return;
        }
        this.mAwContents.setVerticalScrollbarOverlay(overlay);
    }

    @Override
    public boolean overlayHorizontalScrollbar() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.overlayHorizontalScrollbar();
                }
            });
            return ret;
        }
        return this.mAwContents.overlayHorizontalScrollbar();
    }

    @Override
    public boolean overlayVerticalScrollbar() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.overlayVerticalScrollbar();
                }
            });
            return ret;
        }
        return this.mAwContents.overlayVerticalScrollbar();
    }

    @Override
    public int getVisibleTitleHeight() {
        return 0;
    }

    @Override
    public SslCertificate getCertificate() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            SslCertificate ret = this.runOnUiThreadBlocking(new Callable<SslCertificate>(){

                @Override
                public SslCertificate call() {
                    return WebViewChromium.this.getCertificate();
                }
            });
            return ret;
        }
        return this.mAwContents.getCertificate();
    }

    @Override
    public void setCertificate(SslCertificate certificate) {
    }

    @Override
    public void savePassword(String host, String username, String password) {
    }

    @Override
    public void setHttpAuthUsernamePassword(final String host, final String realm, final String username, final String password) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.setHttpAuthUsernamePassword(host, realm, username, password);
                }
            });
            return;
        }
        this.mAwContents.setHttpAuthUsernamePassword(host, realm, username, password);
    }

    @Override
    public String[] getHttpAuthUsernamePassword(final String host, final String realm) {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            String[] ret = this.runOnUiThreadBlocking(new Callable<String[]>(){

                @Override
                public String[] call() {
                    return WebViewChromium.this.getHttpAuthUsernamePassword(host, realm);
                }
            });
            return ret;
        }
        return this.mAwContents.getHttpAuthUsernamePassword(host, realm);
    }

    @Override
    public void destroy() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.destroy();
                }
            });
            return;
        }
        this.mAwContents.destroy();
        if (this.mGLfunctor != null) {
            this.mGLfunctor.destroy();
            this.mGLfunctor = null;
        }
    }

    @Override
    public void setNetworkAvailable(final boolean networkUp) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.setNetworkAvailable(networkUp);
                }
            });
            return;
        }
        this.mAwContents.setNetworkAvailable(networkUp);
    }

    @Override
    public WebBackForwardList saveState(final Bundle outState) {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            WebBackForwardList ret = this.runOnUiThreadBlocking(new Callable<WebBackForwardList>(){

                @Override
                public WebBackForwardList call() {
                    return WebViewChromium.this.saveState(outState);
                }
            });
            return ret;
        }
        if (outState == null) {
            return null;
        }
        if (!this.mAwContents.saveState(outState)) {
            return null;
        }
        return this.copyBackForwardList();
    }

    @Override
    public boolean savePicture(Bundle b, File dest) {
        return false;
    }

    @Override
    public boolean restorePicture(Bundle b, File src) {
        return false;
    }

    @Override
    public WebBackForwardList restoreState(final Bundle inState) {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            WebBackForwardList ret = this.runOnUiThreadBlocking(new Callable<WebBackForwardList>(){

                @Override
                public WebBackForwardList call() {
                    return WebViewChromium.this.restoreState(inState);
                }
            });
            return ret;
        }
        if (inState == null) {
            return null;
        }
        if (!this.mAwContents.restoreState(inState)) {
            return null;
        }
        return this.copyBackForwardList();
    }

    @Override
    public void loadUrl(final String url, Map<String, String> additionalHttpHeaders) {
        String JAVASCRIPT_SCHEME = "javascript:";
        if (this.mAppTargetSdkVersion < 19 && url != null && url.startsWith("javascript:")) {
            this.mFactory.startYourEngines(true);
            if (this.checkNeedsPost()) {
                this.mRunQueue.addTask(new Runnable(){

                    public void run() {
                        WebViewChromium.this.mAwContents.evaluateJavaScriptEvenIfNotYetNavigated(url.substring("javascript:".length()));
                    }
                });
            } else {
                this.mAwContents.evaluateJavaScriptEvenIfNotYetNavigated(url.substring("javascript:".length()));
            }
            return;
        }
        LoadUrlParams params = new LoadUrlParams(url);
        if (additionalHttpHeaders != null) {
            params.setExtraHeaders(additionalHttpHeaders);
        }
        this.loadUrlOnUiThread(params);
    }

    @Override
    public void loadUrl(String url) {
        if (url == null) {
            return;
        }
        this.loadUrl(url, null);
    }

    @Override
    public void postUrl(String url, byte[] postData) {
        LoadUrlParams params = LoadUrlParams.createLoadHttpPostParams(url, postData);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        params.setExtraHeaders(headers);
        this.loadUrlOnUiThread(params);
    }

    private static String fixupMimeType(String mimeType) {
        return TextUtils.isEmpty(mimeType) ? "text/html" : mimeType;
    }

    private static String fixupData(String data) {
        return TextUtils.isEmpty(data) ? "" : data;
    }

    private static String fixupBase(String url) {
        return TextUtils.isEmpty(url) ? "about:blank" : url;
    }

    private static String fixupHistory(String url) {
        return TextUtils.isEmpty(url) ? "about:blank" : url;
    }

    private static boolean isBase64Encoded(String encoding) {
        return "base64".equals(encoding);
    }

    @Override
    public void loadData(String data, String mimeType, String encoding) {
        this.loadUrlOnUiThread(LoadUrlParams.createLoadDataParams(WebViewChromium.fixupData(data), WebViewChromium.fixupMimeType(mimeType), WebViewChromium.isBase64Encoded(encoding)));
    }

    @Override
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        LoadUrlParams loadUrlParams;
        data = WebViewChromium.fixupData(data);
        mimeType = WebViewChromium.fixupMimeType(mimeType);
        baseUrl = WebViewChromium.fixupBase(baseUrl);
        historyUrl = WebViewChromium.fixupHistory(historyUrl);
        if (baseUrl.startsWith("data:")) {
            boolean isBase64;
            loadUrlParams = LoadUrlParams.createLoadDataParamsWithBaseUrl(data, mimeType, isBase64, baseUrl, historyUrl, (isBase64 = WebViewChromium.isBase64Encoded(encoding)) ? null : encoding);
        } else {
            try {
                loadUrlParams = LoadUrlParams.createLoadDataParamsWithBaseUrl(Base64.encodeToString(data.getBytes("utf-8"), 0), mimeType, true, baseUrl, historyUrl, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                Log.wtf(TAG, "Unable to load data string " + data, e);
                return;
            }
        }
        this.loadUrlOnUiThread(loadUrlParams);
        final String finalBaseUrl = loadUrlParams.getBaseUrl();
        ThreadUtils.postOnUiThread(new Runnable(){

            public void run() {
                WebViewChromium.this.mContentsClientAdapter.onPageStarted(finalBaseUrl);
            }
        });
    }

    private void loadUrlOnUiThread(final LoadUrlParams loadUrlParams) {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            assert (this.mAppTargetSdkVersion < 18);
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.mAwContents.loadUrl(loadUrlParams);
                }
            });
            return;
        }
        this.mAwContents.loadUrl(loadUrlParams);
    }

    @Override
    public void evaluateJavaScript(String script, ValueCallback<String> resultCallback) {
        this.checkThread();
        this.mAwContents.evaluateJavaScript(script, resultCallback);
    }

    @Override
    public void saveWebArchive(String filename) {
        this.saveWebArchive(filename, false, null);
    }

    @Override
    public void saveWebArchive(final String basename, final boolean autoname, final ValueCallback<String> callback) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.saveWebArchive(basename, autoname, callback);
                }
            });
            return;
        }
        this.mAwContents.saveWebArchive(basename, autoname, callback);
    }

    @Override
    public void stopLoading() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.stopLoading();
                }
            });
            return;
        }
        this.mAwContents.stopLoading();
    }

    @Override
    public void reload() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.reload();
                }
            });
            return;
        }
        this.mAwContents.reload();
    }

    @Override
    public boolean canGoBack() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            Boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.canGoBack();
                }
            });
            return ret;
        }
        return this.mAwContents.canGoBack();
    }

    @Override
    public void goBack() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.goBack();
                }
            });
            return;
        }
        this.mAwContents.goBack();
    }

    @Override
    public boolean canGoForward() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            Boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.canGoForward();
                }
            });
            return ret;
        }
        return this.mAwContents.canGoForward();
    }

    @Override
    public void goForward() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.goForward();
                }
            });
            return;
        }
        this.mAwContents.goForward();
    }

    @Override
    public boolean canGoBackOrForward(final int steps) {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            Boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.canGoBackOrForward(steps);
                }
            });
            return ret;
        }
        return this.mAwContents.canGoBackOrForward(steps);
    }

    @Override
    public void goBackOrForward(final int steps) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.goBackOrForward(steps);
                }
            });
            return;
        }
        this.mAwContents.goBackOrForward(steps);
    }

    @Override
    public boolean isPrivateBrowsingEnabled() {
        return false;
    }

    @Override
    public boolean pageUp(final boolean top) {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            Boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.pageUp(top);
                }
            });
            return ret;
        }
        return this.mAwContents.pageUp(top);
    }

    @Override
    public boolean pageDown(final boolean bottom) {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            Boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.pageDown(bottom);
                }
            });
            return ret;
        }
        return this.mAwContents.pageDown(bottom);
    }

    @Override
    public void clearView() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.clearView();
                }
            });
            return;
        }
        this.mAwContents.clearView();
    }

    @Override
    public Picture capturePicture() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            Picture ret = this.runOnUiThreadBlocking(new Callable<Picture>(){

                @Override
                public Picture call() {
                    return WebViewChromium.this.capturePicture();
                }
            });
            return ret;
        }
        return this.mAwContents.capturePicture();
    }

    @Override
    public PrintDocumentAdapter createPrintDocumentAdapter() {
        this.checkThread();
        return new AwPrintDocumentAdapter(this.mAwContents.getPdfExporter());
    }

    @Override
    public float getScale() {
        this.mFactory.startYourEngines(true);
        return this.mAwContents.getScale();
    }

    @Override
    public void setInitialScale(int scaleInPercent) {
        this.mWebSettings.getAwSettings().setInitialPageScale(scaleInPercent);
    }

    @Override
    public void invokeZoomPicker() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.invokeZoomPicker();
                }
            });
            return;
        }
        this.mAwContents.invokeZoomPicker();
    }

    @Override
    public WebView.HitTestResult getHitTestResult() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            WebView.HitTestResult ret = this.runOnUiThreadBlocking(new Callable<WebView.HitTestResult>(){

                @Override
                public WebView.HitTestResult call() {
                    return WebViewChromium.this.getHitTestResult();
                }
            });
            return ret;
        }
        AwContents.HitTestData data = this.mAwContents.getLastHitTestResult();
        this.mHitTestResult.setType(data.hitTestResultType);
        this.mHitTestResult.setExtra(data.hitTestResultExtraData);
        return this.mHitTestResult;
    }

    @Override
    public void requestFocusNodeHref(final Message hrefMsg) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.requestFocusNodeHref(hrefMsg);
                }
            });
            return;
        }
        this.mAwContents.requestFocusNodeHref(hrefMsg);
    }

    @Override
    public void requestImageRef(final Message msg) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.requestImageRef(msg);
                }
            });
            return;
        }
        this.mAwContents.requestImageRef(msg);
    }

    @Override
    public String getUrl() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            String ret = this.runOnUiThreadBlocking(new Callable<String>(){

                @Override
                public String call() {
                    return WebViewChromium.this.getUrl();
                }
            });
            return ret;
        }
        String url = this.mAwContents.getUrl();
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        return url;
    }

    @Override
    public String getOriginalUrl() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            String ret = this.runOnUiThreadBlocking(new Callable<String>(){

                @Override
                public String call() {
                    return WebViewChromium.this.getOriginalUrl();
                }
            });
            return ret;
        }
        String url = this.mAwContents.getOriginalUrl();
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        return url;
    }

    @Override
    public String getTitle() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            String ret = this.runOnUiThreadBlocking(new Callable<String>(){

                @Override
                public String call() {
                    return WebViewChromium.this.getTitle();
                }
            });
            return ret;
        }
        return this.mAwContents.getTitle();
    }

    @Override
    public Bitmap getFavicon() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            Bitmap ret = this.runOnUiThreadBlocking(new Callable<Bitmap>(){

                @Override
                public Bitmap call() {
                    return WebViewChromium.this.getFavicon();
                }
            });
            return ret;
        }
        return this.mAwContents.getFavicon();
    }

    @Override
    public String getTouchIconUrl() {
        return null;
    }

    @Override
    public int getProgress() {
        if (this.mAwContents == null) {
            return 100;
        }
        return this.mAwContents.getMostRecentProgress();
    }

    @Override
    public int getContentHeight() {
        if (this.mAwContents == null) {
            return 0;
        }
        return this.mAwContents.getContentHeightCss();
    }

    @Override
    public int getContentWidth() {
        if (this.mAwContents == null) {
            return 0;
        }
        return this.mAwContents.getContentWidthCss();
    }

    @Override
    public void pauseTimers() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.pauseTimers();
                }
            });
            return;
        }
        this.mAwContents.pauseTimers();
    }

    @Override
    public void resumeTimers() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.resumeTimers();
                }
            });
            return;
        }
        this.mAwContents.resumeTimers();
    }

    @Override
    public void onPause() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onPause();
                }
            });
            return;
        }
        this.mAwContents.onPause();
    }

    @Override
    public void onResume() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onResume();
                }
            });
            return;
        }
        this.mAwContents.onResume();
    }

    @Override
    public boolean isPaused() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            Boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.isPaused();
                }
            });
            return ret;
        }
        return this.mAwContents.isPaused();
    }

    @Override
    public void freeMemory() {
    }

    @Override
    public void clearCache(final boolean includeDiskFiles) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.clearCache(includeDiskFiles);
                }
            });
            return;
        }
        this.mAwContents.clearCache(includeDiskFiles);
    }

    @Override
    public void clearFormData() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.clearFormData();
                }
            });
            return;
        }
        this.mAwContents.hideAutofillPopup();
    }

    @Override
    public void clearHistory() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.clearHistory();
                }
            });
            return;
        }
        this.mAwContents.clearHistory();
    }

    @Override
    public void clearSslPreferences() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.clearSslPreferences();
                }
            });
            return;
        }
        this.mAwContents.clearSslPreferences();
    }

    @Override
    public WebBackForwardList copyBackForwardList() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            WebBackForwardList ret = this.runOnUiThreadBlocking(new Callable<WebBackForwardList>(){

                @Override
                public WebBackForwardList call() {
                    return WebViewChromium.this.copyBackForwardList();
                }
            });
            return ret;
        }
        return new WebBackForwardListChromium(this.mAwContents.getNavigationHistory());
    }

    @Override
    public void setFindListener(WebView.FindListener listener) {
        this.mContentsClientAdapter.setFindListener(listener);
    }

    @Override
    public void findNext(final boolean forwards) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.findNext(forwards);
                }
            });
            return;
        }
        this.mAwContents.findNext(forwards);
    }

    @Override
    public int findAll(String searchString) {
        this.findAllAsync(searchString);
        return 0;
    }

    @Override
    public void findAllAsync(final String searchString) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.findAllAsync(searchString);
                }
            });
            return;
        }
        this.mAwContents.findAllAsync(searchString);
    }

    @Override
    public boolean showFindDialog(String text, boolean showIme) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            return false;
        }
        if (this.mWebView.getParent() == null) {
            return false;
        }
        FindActionModeCallback findAction = new FindActionModeCallback(this.mWebView.getContext());
        if (findAction == null) {
            return false;
        }
        this.mWebView.startActionMode(findAction);
        findAction.setWebView(this.mWebView);
        if (showIme) {
            findAction.showSoftInput();
        }
        if (text != null) {
            findAction.setText(text);
            findAction.findAll();
        }
        return true;
    }

    @Override
    public void notifyFindDialogDismissed() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.notifyFindDialogDismissed();
                }
            });
            return;
        }
        this.clearMatches();
    }

    @Override
    public void clearMatches() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.clearMatches();
                }
            });
            return;
        }
        this.mAwContents.clearMatches();
    }

    @Override
    public void documentHasImages(final Message response) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.documentHasImages(response);
                }
            });
            return;
        }
        this.mAwContents.documentHasImages(response);
    }

    @Override
    public void setWebViewClient(WebViewClient client) {
        this.mContentsClientAdapter.setWebViewClient(client);
    }

    @Override
    public void setDownloadListener(DownloadListener listener) {
        this.mContentsClientAdapter.setDownloadListener(listener);
    }

    @Override
    public void setWebChromeClient(WebChromeClient client) {
        this.mContentsClientAdapter.setWebChromeClient(client);
    }

    @Override
    public void setPictureListener(final WebView.PictureListener listener) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.setPictureListener(listener);
                }
            });
            return;
        }
        this.mContentsClientAdapter.setPictureListener(listener);
        this.mAwContents.enableOnNewPicture(listener != null, this.mAppTargetSdkVersion >= 18);
    }

    @Override
    public void addJavascriptInterface(final Object obj, final String interfaceName) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.addJavascriptInterface(obj, interfaceName);
                }
            });
            return;
        }
        Class<JavascriptInterface> requiredAnnotation = null;
        if (this.mAppTargetSdkVersion >= 17) {
            requiredAnnotation = JavascriptInterface.class;
        }
        this.mAwContents.addPossiblyUnsafeJavascriptInterface(obj, interfaceName, requiredAnnotation);
    }

    @Override
    public void removeJavascriptInterface(final String interfaceName) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.removeJavascriptInterface(interfaceName);
                }
            });
            return;
        }
        this.mAwContents.removeJavascriptInterface(interfaceName);
    }

    @Override
    public WebSettings getSettings() {
        return this.mWebSettings;
    }

    @Override
    public void setMapTrackballToArrowKeys(boolean setMap) {
    }

    @Override
    public void flingScroll(final int vx, final int vy) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.flingScroll(vx, vy);
                }
            });
            return;
        }
        this.mAwContents.flingScroll(vx, vy);
    }

    @Override
    public View getZoomControls() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            return null;
        }
        Log.w(TAG, "WebView doesn't support getZoomControls");
        return this.mAwContents.getSettings().supportZoom() ? new View(this.mWebView.getContext()) : null;
    }

    @Override
    public boolean canZoomIn() {
        if (this.checkNeedsPost()) {
            return false;
        }
        return this.mAwContents.canZoomIn();
    }

    @Override
    public boolean canZoomOut() {
        if (this.checkNeedsPost()) {
            return false;
        }
        return this.mAwContents.canZoomOut();
    }

    @Override
    public boolean zoomIn() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.zoomIn();
                }
            });
            return ret;
        }
        return this.mAwContents.zoomIn();
    }

    @Override
    public boolean zoomOut() {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.zoomOut();
                }
            });
            return ret;
        }
        return this.mAwContents.zoomOut();
    }

    @Override
    public void dumpViewHierarchyWithProperties(BufferedWriter out, int level) {
    }

    @Override
    public View findHierarchyView(String className, int hashCode) {
        return null;
    }

    @Override
    public WebViewProvider.ViewDelegate getViewDelegate() {
        return this;
    }

    @Override
    public WebViewProvider.ScrollDelegate getScrollDelegate() {
        return this;
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.shouldDelayChildPressedState();
                }
            });
            return ret;
        }
        return true;
    }

    @Override
    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            AccessibilityNodeProvider ret = this.runOnUiThreadBlocking(new Callable<AccessibilityNodeProvider>(){

                @Override
                public AccessibilityNodeProvider call() {
                    return WebViewChromium.this.getAccessibilityNodeProvider();
                }
            });
            return ret;
        }
        return this.mAwContents.getAccessibilityNodeProvider();
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(final AccessibilityNodeInfo info) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            this.runVoidTaskOnUiThreadBlocking(new Runnable(){

                public void run() {
                    WebViewChromium.this.onInitializeAccessibilityNodeInfo(info);
                }
            });
            return;
        }
        this.mAwContents.onInitializeAccessibilityNodeInfo(info);
    }

    @Override
    public void onInitializeAccessibilityEvent(final AccessibilityEvent event) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            this.runVoidTaskOnUiThreadBlocking(new Runnable(){

                public void run() {
                    WebViewChromium.this.onInitializeAccessibilityEvent(event);
                }
            });
            return;
        }
        this.mAwContents.onInitializeAccessibilityEvent(event);
    }

    @Override
    public boolean performAccessibilityAction(final int action, final Bundle arguments) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.performAccessibilityAction(action, arguments);
                }
            });
            return ret;
        }
        if (this.mAwContents.supportsAccessibilityAction(action)) {
            return this.mAwContents.performAccessibilityAction(action, arguments);
        }
        return this.mWebViewPrivate.super_performAccessibilityAction(action, arguments);
    }

    @Override
    public void setOverScrollMode(final int mode) {
        if (this.mAwContents == null) {
            return;
        }
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.setOverScrollMode(mode);
                }
            });
            return;
        }
        this.mAwContents.setOverScrollMode(mode);
    }

    @Override
    public void setScrollBarStyle(final int style2) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.setScrollBarStyle(style2);
                }
            });
            return;
        }
        this.mAwContents.setScrollBarStyle(style2);
    }

    @Override
    public void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        this.mWebViewPrivate.super_onDrawVerticalScrollBar(canvas, scrollBar, l, t, r, b);
    }

    @Override
    public void onOverScrolled(final int scrollX, final int scrollY, final boolean clampedX, final boolean clampedY) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
                }
            });
            return;
        }
        this.mAwContents.onContainerViewOverScrolled(scrollX, scrollY, clampedX, clampedY);
    }

    @Override
    public void onWindowVisibilityChanged(final int visibility) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onWindowVisibilityChanged(visibility);
                }
            });
            return;
        }
        this.mAwContents.onWindowVisibilityChanged(visibility);
    }

    @Override
    public void onDraw(final Canvas canvas) {
        this.mFactory.startYourEngines(true);
        if (this.checkNeedsPost()) {
            this.runVoidTaskOnUiThreadBlocking(new Runnable(){

                public void run() {
                    WebViewChromium.this.onDraw(canvas);
                }
            });
            return;
        }
        this.mAwContents.onDraw(canvas);
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        this.mFactory.startYourEngines(false);
        this.checkThread();
        this.mWebViewPrivate.super_setLayoutParams(layoutParams);
    }

    @Override
    public boolean performLongClick() {
        return this.mWebView.getParent() != null ? this.mWebViewPrivate.super_performLongClick() : false;
    }

    @Override
    public void onConfigurationChanged(final Configuration newConfig) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onConfigurationChanged(newConfig);
                }
            });
            return;
        }
        this.mAwContents.onConfigurationChanged(newConfig);
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            return null;
        }
        return this.mAwContents.onCreateInputConnection(outAttrs);
    }

    @Override
    public boolean onKeyMultiple(final int keyCode, final int repeatCount, final KeyEvent event) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.onKeyMultiple(keyCode, repeatCount, event);
                }
            });
            return ret;
        }
        UnimplementedWebViewApi.invoke();
        return false;
    }

    @Override
    public boolean onKeyDown(final int keyCode, final KeyEvent event) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.onKeyDown(keyCode, event);
                }
            });
            return ret;
        }
        UnimplementedWebViewApi.invoke();
        return false;
    }

    @Override
    public boolean onKeyUp(final int keyCode, final KeyEvent event) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.onKeyUp(keyCode, event);
                }
            });
            return ret;
        }
        return this.mAwContents.onKeyUp(keyCode, event);
    }

    @Override
    public void onAttachedToWindow() {
        this.mFactory.startYourEngines(false);
        this.checkThread();
        this.mAwContents.onAttachedToWindow();
    }

    @Override
    public void onDetachedFromWindow() {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onDetachedFromWindow();
                }
            });
            return;
        }
        Runnable detachAwContents = new Runnable(){

            public void run() {
                WebViewChromium.this.mAwContents.onDetachedFromWindow();
            }
        };
        if (this.mGLfunctor == null || !this.mWebView.executeHardwareAction(detachAwContents)) {
            detachAwContents.run();
        }
        if (this.mGLfunctor != null) {
            this.mGLfunctor.detach();
        }
    }

    @Override
    public void onVisibilityChanged(final View changedView, final int visibility) {
        if (this.mAwContents == null) {
            return;
        }
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onVisibilityChanged(changedView, visibility);
                }
            });
            return;
        }
        this.mAwContents.onVisibilityChanged(changedView, visibility);
    }

    @Override
    public void onWindowFocusChanged(final boolean hasWindowFocus) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onWindowFocusChanged(hasWindowFocus);
                }
            });
            return;
        }
        this.mAwContents.onWindowFocusChanged(hasWindowFocus);
    }

    @Override
    public void onFocusChanged(final boolean focused, final int direction, final Rect previouslyFocusedRect) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onFocusChanged(focused, direction, previouslyFocusedRect);
                }
            });
            return;
        }
        this.mAwContents.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    @Override
    public boolean setFrame(int left, int top, int right, int bottom) {
        return this.mWebViewPrivate.super_setFrame(left, top, right, bottom);
    }

    @Override
    public void onSizeChanged(final int w, final int h, final int ow, final int oh) {
        if (this.checkNeedsPost()) {
            this.mRunQueue.addTask(new Runnable(){

                public void run() {
                    WebViewChromium.this.onSizeChanged(w, h, ow, oh);
                }
            });
            return;
        }
        this.mAwContents.onSizeChanged(w, h, ow, oh);
    }

    @Override
    public void onScrollChanged(int l, int t, int oldl, int oldt) {
    }

    @Override
    public boolean dispatchKeyEvent(final KeyEvent event) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.dispatchKeyEvent(event);
                }
            });
            return ret;
        }
        return this.mAwContents.dispatchKeyEvent(event);
    }

    @Override
    public boolean onTouchEvent(final MotionEvent ev) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.onTouchEvent(ev);
                }
            });
            return ret;
        }
        return this.mAwContents.onTouchEvent(ev);
    }

    @Override
    public boolean onHoverEvent(final MotionEvent event) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.onHoverEvent(event);
                }
            });
            return ret;
        }
        return this.mAwContents.onHoverEvent(event);
    }

    @Override
    public boolean onGenericMotionEvent(final MotionEvent event) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.onGenericMotionEvent(event);
                }
            });
            return ret;
        }
        return this.mAwContents.onGenericMotionEvent(event);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent ev) {
        return false;
    }

    @Override
    public boolean requestFocus(final int direction, final Rect previouslyFocusedRect) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.requestFocus(direction, previouslyFocusedRect);
                }
            });
            return ret;
        }
        this.mAwContents.requestFocus();
        return this.mWebViewPrivate.super_requestFocus(direction, previouslyFocusedRect);
    }

    @Override
    public void onMeasure(final int widthMeasureSpec, final int heightMeasureSpec) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            this.runVoidTaskOnUiThreadBlocking(new Runnable(){

                public void run() {
                    WebViewChromium.this.onMeasure(widthMeasureSpec, heightMeasureSpec);
                }
            });
            return;
        }
        this.mAwContents.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public boolean requestChildRectangleOnScreen(final View child, final Rect rect, final boolean immediate) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            boolean ret = this.runOnUiThreadBlocking(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return WebViewChromium.this.requestChildRectangleOnScreen(child, rect, immediate);
                }
            });
            return ret;
        }
        return this.mAwContents.requestChildRectangleOnScreen(child, rect, immediate);
    }

    @Override
    public void setBackgroundColor(final int color2) {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            ThreadUtils.postOnUiThread(new Runnable(){

                public void run() {
                    WebViewChromium.this.setBackgroundColor(color2);
                }
            });
            return;
        }
        this.mAwContents.setBackgroundColor(color2);
    }

    @Override
    public void setLayerType(int layerType, Paint paint) {
    }

    @Override
    public void preDispatchDraw(Canvas canvas) {
    }

    @Override
    public int computeHorizontalScrollRange() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            int ret = this.runOnUiThreadBlocking(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return WebViewChromium.this.computeHorizontalScrollRange();
                }
            });
            return ret;
        }
        return this.mAwContents.computeHorizontalScrollRange();
    }

    @Override
    public int computeHorizontalScrollOffset() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            int ret = this.runOnUiThreadBlocking(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return WebViewChromium.this.computeHorizontalScrollOffset();
                }
            });
            return ret;
        }
        return this.mAwContents.computeHorizontalScrollOffset();
    }

    @Override
    public int computeVerticalScrollRange() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            int ret = this.runOnUiThreadBlocking(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return WebViewChromium.this.computeVerticalScrollRange();
                }
            });
            return ret;
        }
        return this.mAwContents.computeVerticalScrollRange();
    }

    @Override
    public int computeVerticalScrollOffset() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            int ret = this.runOnUiThreadBlocking(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return WebViewChromium.this.computeVerticalScrollOffset();
                }
            });
            return ret;
        }
        return this.mAwContents.computeVerticalScrollOffset();
    }

    @Override
    public int computeVerticalScrollExtent() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            int ret = this.runOnUiThreadBlocking(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return WebViewChromium.this.computeVerticalScrollExtent();
                }
            });
            return ret;
        }
        return this.mAwContents.computeVerticalScrollExtent();
    }

    @Override
    public void computeScroll() {
        this.mFactory.startYourEngines(false);
        if (this.checkNeedsPost()) {
            this.runVoidTaskOnUiThreadBlocking(new Runnable(){

                public void run() {
                    WebViewChromium.this.computeScroll();
                }
            });
            return;
        }
        this.mAwContents.computeScroll();
    }

    private class InternalAccessAdapter
    implements AwContents.InternalAccessDelegate {
        private InternalAccessAdapter() {
        }

        public boolean drawChild(Canvas arg0, View arg1, long arg2) {
            UnimplementedWebViewApi.invoke();
            return false;
        }

        public boolean super_onKeyUp(int arg0, KeyEvent arg1) {
            return false;
        }

        public boolean super_dispatchKeyEventPreIme(KeyEvent arg0) {
            UnimplementedWebViewApi.invoke();
            return false;
        }

        public boolean super_dispatchKeyEvent(KeyEvent event) {
            return WebViewChromium.this.mWebViewPrivate.super_dispatchKeyEvent(event);
        }

        public boolean super_onGenericMotionEvent(MotionEvent arg0) {
            return WebViewChromium.this.mWebViewPrivate.super_onGenericMotionEvent(arg0);
        }

        public void super_onConfigurationChanged(Configuration arg0) {
        }

        public int super_getScrollBarStyle() {
            return WebViewChromium.this.mWebViewPrivate.super_getScrollBarStyle();
        }

        public boolean awakenScrollBars() {
            WebViewChromium.this.mWebViewPrivate.awakenScrollBars(0);
            return true;
        }

        public boolean super_awakenScrollBars(int arg0, boolean arg1) {
            UnimplementedWebViewApi.invoke();
            return false;
        }

        public void onScrollChanged(int l, int t, int oldl, int oldt) {
            WebViewChromium.this.mWebViewPrivate.setScrollXRaw(l);
            WebViewChromium.this.mWebViewPrivate.setScrollYRaw(t);
            WebViewChromium.this.mWebViewPrivate.onScrollChanged(l, t, oldl, oldt);
        }

        public void overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
            WebViewChromium.this.mWebViewPrivate.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, maxOverScrollX, maxOverScrollY, isTouchEvent);
        }

        public void super_scrollTo(int scrollX, int scrollY) {
            WebViewChromium.this.mWebViewPrivate.super_scrollTo(scrollX, scrollY);
        }

        public void setMeasuredDimension(int measuredWidth, int measuredHeight) {
            WebViewChromium.this.mWebViewPrivate.setMeasuredDimension(measuredWidth, measuredHeight);
        }

        public boolean requestDrawGL(Canvas canvas) {
            if (WebViewChromium.this.mGLfunctor == null) {
                WebViewChromium.this.mGLfunctor = new DrawGLFunctor(WebViewChromium.this.mAwContents.getAwDrawGLViewContext());
            }
            return WebViewChromium.this.mGLfunctor.requestDrawGL((HardwareCanvas)canvas, WebViewChromium.this.mWebView.getViewRootImpl());
        }
    }

    private class WebViewChromiumRunQueue {
        private Queue<Runnable> mQueue = new ConcurrentLinkedQueue<Runnable>();

        public void addTask(Runnable task) {
            this.mQueue.add(task);
            if (WebViewChromium.this.mFactory.hasStarted()) {
                ThreadUtils.runOnUiThread(new Runnable(){

                    public void run() {
                        WebViewChromiumRunQueue.this.drainQueue();
                    }
                });
            }
        }

        public void drainQueue() {
            if (this.mQueue == null || this.mQueue.isEmpty()) {
                return;
            }
            Runnable task = this.mQueue.poll();
            while (task != null) {
                task.run();
                task = this.mQueue.poll();
            }
        }
    }
}

