/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.os.SystemClock;
import android.util.Slog;
import android.view.DisplayInfo;
import android.view.SurfaceControl;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;

public class DimLayer {
    private static final String TAG = "DimLayer";
    private static final boolean DEBUG = false;
    final DisplayContent mDisplayContent;
    SurfaceControl mDimSurface;
    float mAlpha = 0.0f;
    int mLayer = -1;
    Rect mBounds = new Rect();
    Rect mLastBounds = new Rect();
    private boolean mShowing = false;
    float mStartAlpha = 0.0f;
    float mTargetAlpha = 0.0f;
    long mStartTime;
    long mDuration;
    final TaskStack mStack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DimLayer(WindowManagerService service, TaskStack stack) {
        this.mStack = stack;
        this.mDisplayContent = stack.getDisplayContent();
        int displayId = this.mDisplayContent.getDisplayId();
        SurfaceControl.openTransaction();
        try {
            try {
                this.mDimSurface = new SurfaceControl(service.mFxSession, TAG, 16, 16, -1, 131076);
                this.mDimSurface.setLayerStack(displayId);
            }
            catch (Exception e) {
                Slog.e("WindowManager", "Exception creating Dim surface", e);
                Object var6_5 = null;
                SurfaceControl.closeTransaction();
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SurfaceControl.closeTransaction();
            throw throwable;
        }
        SurfaceControl.closeTransaction();
    }

    boolean isDimming() {
        return this.mTargetAlpha != 0.0f;
    }

    boolean isAnimating() {
        return this.mTargetAlpha != this.mAlpha;
    }

    float getTargetAlpha() {
        return this.mTargetAlpha;
    }

    void setLayer(int layer) {
        if (this.mLayer != layer) {
            this.mLayer = layer;
            this.mDimSurface.setLayer(layer);
        }
    }

    int getLayer() {
        return this.mLayer;
    }

    private void setAlpha(float alpha) {
        if (this.mAlpha != alpha) {
            try {
                this.mDimSurface.setAlpha(alpha);
                if (alpha == 0.0f && this.mShowing) {
                    this.mDimSurface.hide();
                    this.mShowing = false;
                } else if (alpha > 0.0f && !this.mShowing) {
                    this.mDimSurface.show();
                    this.mShowing = true;
                }
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Failure setting alpha immediately", e);
            }
            this.mAlpha = alpha;
        }
    }

    void setBounds(Rect bounds) {
        this.mBounds.set(bounds);
    }

    private boolean durationEndsEarlier(long duration) {
        return SystemClock.uptimeMillis() + duration < this.mStartTime + this.mDuration;
    }

    void show() {
        if (this.isAnimating()) {
            this.show(this.mLayer, this.mTargetAlpha, 0L);
        }
    }

    void show(int layer, float alpha, long duration) {
        float yPos;
        float xPos;
        int dh;
        int dw;
        if (this.mDimSurface == null) {
            Slog.e(TAG, "show: no Surface");
            this.mAlpha = 0.0f;
            this.mTargetAlpha = 0.0f;
            return;
        }
        if (this.mStack.hasSibling()) {
            dw = this.mBounds.width();
            dh = this.mBounds.height();
            xPos = this.mBounds.left;
            yPos = this.mBounds.right;
        } else {
            DisplayInfo info = this.mDisplayContent.getDisplayInfo();
            dw = (int)((double)info.logicalWidth * 1.5);
            dh = (int)((double)info.logicalHeight * 1.5);
            xPos = -1 * dw / 6;
            yPos = -1 * dh / 6;
        }
        if (!this.mLastBounds.equals(this.mBounds) || this.mLayer != layer) {
            try {
                this.mDimSurface.setPosition(xPos, yPos);
                this.mDimSurface.setSize(dw, dh);
                this.mDimSurface.setLayer(layer);
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Failure setting size or layer", e);
            }
            this.mLastBounds.set(this.mBounds);
            this.mLayer = layer;
        }
        long curTime = SystemClock.uptimeMillis();
        boolean animating = this.isAnimating();
        if (animating && (this.mTargetAlpha != alpha || this.durationEndsEarlier(duration)) || !animating && this.mAlpha != alpha) {
            if (duration <= 0L) {
                this.setAlpha(alpha);
            } else {
                this.mStartAlpha = this.mAlpha;
                this.mStartTime = curTime;
                this.mDuration = duration;
            }
        }
        this.mTargetAlpha = alpha;
    }

    void hide() {
        if (this.mShowing) {
            this.hide(0L);
        }
    }

    void hide(long duration) {
        if (this.mShowing && (this.mTargetAlpha != 0.0f || this.durationEndsEarlier(duration))) {
            this.show(this.mLayer, 0.0f, duration);
        }
    }

    boolean stepAnimation() {
        if (this.mDimSurface == null) {
            Slog.e(TAG, "stepAnimation: null Surface");
            this.mAlpha = 0.0f;
            this.mTargetAlpha = 0.0f;
            return false;
        }
        if (this.isAnimating()) {
            long curTime = SystemClock.uptimeMillis();
            float alphaDelta = this.mTargetAlpha - this.mStartAlpha;
            float alpha = this.mStartAlpha + alphaDelta * (float)(curTime - this.mStartTime) / (float)this.mDuration;
            if (alphaDelta > 0.0f && alpha > this.mTargetAlpha || alphaDelta < 0.0f && alpha < this.mTargetAlpha) {
                alpha = this.mTargetAlpha;
            }
            this.setAlpha(alpha);
        }
        return this.isAnimating();
    }

    void destroySurface() {
        if (this.mDimSurface != null) {
            this.mDimSurface.destroy();
            this.mDimSurface = null;
        }
    }

    public void printTo(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mDimSurface=");
        pw.print(this.mDimSurface);
        pw.print(" mLayer=");
        pw.print(this.mLayer);
        pw.print(" mAlpha=");
        pw.println(this.mAlpha);
        pw.print(prefix);
        pw.print("mLastBounds=");
        pw.print(this.mLastBounds.toShortString());
        pw.print(" mBounds=");
        pw.println(this.mBounds.toShortString());
        pw.print(prefix);
        pw.print("Last animation: ");
        pw.print(" mDuration=");
        pw.print(this.mDuration);
        pw.print(" mStartTime=");
        pw.print(this.mStartTime);
        pw.print(" curTime=");
        pw.println(SystemClock.uptimeMillis());
        pw.print(prefix);
        pw.print(" mStartAlpha=");
        pw.print(this.mStartAlpha);
        pw.print(" mTargetAlpha=");
        pw.println(this.mTargetAlpha);
    }
}

