/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.updates;

import android.content.Context;
import android.content.Intent;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Base64;
import android.util.Slog;
import com.android.server.updates.ConfigUpdateInstallReceiver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.Libcore;

public class SELinuxPolicyInstallReceiver
extends ConfigUpdateInstallReceiver {
    private static final String TAG = "SELinuxPolicyInstallReceiver";
    private static final String sepolicyPath = "sepolicy";
    private static final String fileContextsPath = "file_contexts";
    private static final String propertyContextsPath = "property_contexts";
    private static final String seappContextsPath = "seapp_contexts";

    public SELinuxPolicyInstallReceiver() {
        super("/data/security/bundle", "sepolicy_bundle", "metadata/", "version");
    }

    private void backupContexts(File contexts) {
        new File(contexts, seappContextsPath).renameTo(new File(contexts, "seapp_contexts_backup"));
        new File(contexts, propertyContextsPath).renameTo(new File(contexts, "property_contexts_backup"));
        new File(contexts, fileContextsPath).renameTo(new File(contexts, "file_contexts_backup"));
        new File(contexts, sepolicyPath).renameTo(new File(contexts, "sepolicy_backup"));
    }

    private void copyUpdate(File contexts) {
        new File(this.updateDir, seappContextsPath).renameTo(new File(contexts, seappContextsPath));
        new File(this.updateDir, propertyContextsPath).renameTo(new File(contexts, propertyContextsPath));
        new File(this.updateDir, fileContextsPath).renameTo(new File(contexts, fileContextsPath));
        new File(this.updateDir, sepolicyPath).renameTo(new File(contexts, sepolicyPath));
    }

    private int readInt(BufferedInputStream reader) throws IOException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value = value << 8 | reader.read();
        }
        return value;
    }

    private int[] readChunkLengths(BufferedInputStream bundle) throws IOException {
        int[] chunks = new int[]{this.readInt(bundle), this.readInt(bundle), this.readInt(bundle), this.readInt(bundle)};
        return chunks;
    }

    private void installFile(File destination, BufferedInputStream stream, int length) throws IOException {
        byte[] chunk = new byte[length];
        stream.read(chunk, 0, length);
        this.writeUpdate(this.updateDir, destination, Base64.decode(chunk, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackBundle() throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.updateContent));
        try {
            int[] chunkLengths = this.readChunkLengths(stream);
            this.installFile(new File(this.updateDir, seappContextsPath), stream, chunkLengths[0]);
            this.installFile(new File(this.updateDir, propertyContextsPath), stream, chunkLengths[1]);
            this.installFile(new File(this.updateDir, fileContextsPath), stream, chunkLengths[2]);
            this.installFile(new File(this.updateDir, sepolicyPath), stream, chunkLengths[3]);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IoUtils.closeQuietly(stream);
            throw throwable;
        }
        IoUtils.closeQuietly(stream);
    }

    private void applyUpdate() throws IOException, ErrnoException {
        Slog.i(TAG, "Applying SELinux policy");
        File contexts = new File(this.updateDir.getParentFile(), "contexts");
        File current = new File(this.updateDir.getParentFile(), "current");
        File update = new File(this.updateDir.getParentFile(), "update");
        File tmp = new File(this.updateDir.getParentFile(), "tmp");
        if (current.exists()) {
            Libcore.os.symlink(this.updateDir.getPath(), update.getPath());
            Libcore.os.rename(update.getPath(), current.getPath());
        } else {
            Libcore.os.symlink(this.updateDir.getPath(), current.getPath());
        }
        contexts.mkdirs();
        this.backupContexts(contexts);
        this.copyUpdate(contexts);
        Libcore.os.symlink(contexts.getPath(), tmp.getPath());
        Libcore.os.rename(tmp.getPath(), current.getPath());
        SystemProperties.set("selinux.reload_policy", "1");
    }

    private void setEnforcingMode(Context context) {
        String mode = Settings.Global.getString(context.getContentResolver(), "selinux_status");
        if ("1".equals(mode)) {
            Slog.i(TAG, "Setting enforcing mode");
            SystemProperties.set("persist.selinux.enforcing", mode);
        } else if ("0".equals(mode)) {
            Slog.i(TAG, "Tried to set permissive mode, ignoring");
        } else {
            Slog.e(TAG, "Got invalid enforcing mode: " + mode);
        }
    }

    protected void postInstall(Context context, Intent intent) {
        try {
            this.unpackBundle();
            this.applyUpdate();
            this.setEnforcingMode(context);
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "SELinux policy update malformed: ", e);
        }
        catch (IOException e) {
            Slog.e(TAG, "Could not update selinux policy: ", e);
        }
        catch (ErrnoException e) {
            Slog.e(TAG, "Could not update selinux policy: ", e);
        }
    }
}

