/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.os.AsyncTask;
import android.os.Handler;
import android.util.FloatProperty;
import android.util.IntProperty;
import android.util.Slog;
import android.view.Choreographer;
import com.android.server.LightsService;
import com.android.server.power.DisplayBlanker;
import com.android.server.power.ElectronBeam;
import java.io.PrintWriter;

final class DisplayPowerState {
    private static final String TAG = "DisplayPowerState";
    private static boolean DEBUG = false;
    private final Handler mHandler;
    private final Choreographer mChoreographer;
    private final ElectronBeam mElectronBeam;
    private final DisplayBlanker mDisplayBlanker;
    private final LightsService.Light mBacklight;
    private final PhotonicModulator mPhotonicModulator;
    private boolean mScreenOn;
    private int mScreenBrightness;
    private boolean mScreenReady;
    private boolean mScreenUpdatePending;
    private boolean mElectronBeamPrepared;
    private float mElectronBeamLevel;
    private boolean mElectronBeamReady;
    private boolean mElectronBeamDrawPending;
    private Runnable mCleanListener;
    public static final FloatProperty<DisplayPowerState> ELECTRON_BEAM_LEVEL = new FloatProperty<DisplayPowerState>("electronBeamLevel"){

        @Override
        public void setValue(DisplayPowerState object, float value) {
            object.setElectronBeamLevel(value);
        }

        @Override
        public Float get(DisplayPowerState object) {
            return Float.valueOf(object.getElectronBeamLevel());
        }
    };
    public static final IntProperty<DisplayPowerState> SCREEN_BRIGHTNESS = new IntProperty<DisplayPowerState>("screenBrightness"){

        @Override
        public void setValue(DisplayPowerState object, int value) {
            object.setScreenBrightness(value);
        }

        @Override
        public Integer get(DisplayPowerState object) {
            return object.getScreenBrightness();
        }
    };
    private final Runnable mScreenUpdateRunnable = new Runnable(){

        public void run() {
            int brightness;
            DisplayPowerState.this.mScreenUpdatePending = false;
            int n = brightness = DisplayPowerState.this.mScreenOn && DisplayPowerState.this.mElectronBeamLevel > 0.0f ? DisplayPowerState.this.mScreenBrightness : 0;
            if (DisplayPowerState.this.mPhotonicModulator.setState(DisplayPowerState.this.mScreenOn, brightness)) {
                DisplayPowerState.this.mScreenReady = true;
                DisplayPowerState.this.invokeCleanListenerIfNeeded();
            }
        }
    };
    private final Runnable mElectronBeamDrawRunnable = new Runnable(){

        public void run() {
            DisplayPowerState.this.mElectronBeamDrawPending = false;
            if (DisplayPowerState.this.mElectronBeamPrepared) {
                DisplayPowerState.this.mElectronBeam.draw(DisplayPowerState.this.mElectronBeamLevel);
            }
            DisplayPowerState.this.mElectronBeamReady = true;
            DisplayPowerState.this.invokeCleanListenerIfNeeded();
        }
    };

    public DisplayPowerState(ElectronBeam electronBean, DisplayBlanker displayBlanker, LightsService.Light backlight) {
        this.mHandler = new Handler(true);
        this.mChoreographer = Choreographer.getInstance();
        this.mElectronBeam = electronBean;
        this.mDisplayBlanker = displayBlanker;
        this.mBacklight = backlight;
        this.mPhotonicModulator = new PhotonicModulator();
        this.mScreenOn = true;
        this.mScreenBrightness = 255;
        this.scheduleScreenUpdate();
        this.mElectronBeamPrepared = false;
        this.mElectronBeamLevel = 1.0f;
        this.mElectronBeamReady = true;
    }

    public void setScreenOn(boolean on) {
        if (this.mScreenOn != on) {
            if (DEBUG) {
                Slog.d(TAG, "setScreenOn: on=" + on);
            }
            this.mScreenOn = on;
            this.mScreenReady = false;
            this.scheduleScreenUpdate();
        }
    }

    public boolean isScreenOn() {
        return this.mScreenOn;
    }

    public void setScreenBrightness(int brightness) {
        if (this.mScreenBrightness != brightness) {
            if (DEBUG) {
                Slog.d(TAG, "setScreenBrightness: brightness=" + brightness);
            }
            this.mScreenBrightness = brightness;
            if (this.mScreenOn) {
                this.mScreenReady = false;
                this.scheduleScreenUpdate();
            }
        }
    }

    public int getScreenBrightness() {
        return this.mScreenBrightness;
    }

    public boolean prepareElectronBeam(int mode) {
        if (!this.mElectronBeam.prepare(mode)) {
            this.mElectronBeamPrepared = false;
            this.mElectronBeamReady = true;
            return false;
        }
        this.mElectronBeamPrepared = true;
        this.mElectronBeamReady = false;
        this.scheduleElectronBeamDraw();
        return true;
    }

    public void dismissElectronBeam() {
        this.mElectronBeam.dismiss();
        this.mElectronBeamPrepared = false;
        this.mElectronBeamReady = true;
    }

    public void setElectronBeamLevel(float level) {
        if (this.mElectronBeamLevel != level) {
            if (DEBUG) {
                Slog.d(TAG, "setElectronBeamLevel: level=" + level);
            }
            this.mElectronBeamLevel = level;
            if (this.mScreenOn) {
                this.mScreenReady = false;
                this.scheduleScreenUpdate();
            }
            if (this.mElectronBeamPrepared) {
                this.mElectronBeamReady = false;
                this.scheduleElectronBeamDraw();
            }
        }
    }

    public float getElectronBeamLevel() {
        return this.mElectronBeamLevel;
    }

    public boolean waitUntilClean(Runnable listener) {
        if (!this.mScreenReady || !this.mElectronBeamReady) {
            this.mCleanListener = listener;
            return false;
        }
        this.mCleanListener = null;
        return true;
    }

    public void dump(PrintWriter pw) {
        pw.println();
        pw.println("Display Power State:");
        pw.println("  mScreenOn=" + this.mScreenOn);
        pw.println("  mScreenBrightness=" + this.mScreenBrightness);
        pw.println("  mScreenReady=" + this.mScreenReady);
        pw.println("  mScreenUpdatePending=" + this.mScreenUpdatePending);
        pw.println("  mElectronBeamPrepared=" + this.mElectronBeamPrepared);
        pw.println("  mElectronBeamLevel=" + this.mElectronBeamLevel);
        pw.println("  mElectronBeamReady=" + this.mElectronBeamReady);
        pw.println("  mElectronBeamDrawPending=" + this.mElectronBeamDrawPending);
        this.mPhotonicModulator.dump(pw);
        this.mElectronBeam.dump(pw);
    }

    private void scheduleScreenUpdate() {
        if (!this.mScreenUpdatePending) {
            this.mScreenUpdatePending = true;
            this.postScreenUpdateThreadSafe();
        }
    }

    private void postScreenUpdateThreadSafe() {
        this.mHandler.removeCallbacks(this.mScreenUpdateRunnable);
        this.mHandler.post(this.mScreenUpdateRunnable);
    }

    private void scheduleElectronBeamDraw() {
        if (!this.mElectronBeamDrawPending) {
            this.mElectronBeamDrawPending = true;
            this.mChoreographer.postCallback(2, this.mElectronBeamDrawRunnable, null);
        }
    }

    private void invokeCleanListenerIfNeeded() {
        Runnable listener = this.mCleanListener;
        if (listener != null && this.mScreenReady && this.mElectronBeamReady) {
            this.mCleanListener = null;
            listener.run();
        }
    }

    private final class PhotonicModulator {
        private static final boolean INITIAL_SCREEN_ON = false;
        private static final int INITIAL_BACKLIGHT = -1;
        private final Object mLock = new Object();
        private boolean mPendingOn = false;
        private int mPendingBacklight = -1;
        private boolean mActualOn = false;
        private int mActualBacklight = -1;
        private boolean mChangeInProgress;
        private final Runnable mTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    boolean backlightChanged;
                    int backlight;
                    boolean onChanged;
                    boolean on;
                    Object object = PhotonicModulator.this.mLock;
                    synchronized (object) {
                        on = PhotonicModulator.this.mPendingOn;
                        onChanged = on != PhotonicModulator.this.mActualOn;
                        backlight = PhotonicModulator.this.mPendingBacklight;
                        boolean bl = backlightChanged = backlight != PhotonicModulator.this.mActualBacklight;
                        if (!onChanged && !backlightChanged) {
                            PhotonicModulator.this.mChangeInProgress = false;
                            break;
                        }
                        PhotonicModulator.this.mActualOn = on;
                        PhotonicModulator.this.mActualBacklight = backlight;
                    }
                    if (DEBUG) {
                        Slog.d(DisplayPowerState.TAG, "Updating screen state: on=" + on + ", backlight=" + backlight);
                    }
                    if (onChanged && on) {
                        DisplayPowerState.this.mDisplayBlanker.unblankAllDisplays();
                    }
                    if (backlightChanged) {
                        DisplayPowerState.this.mBacklight.setBrightness(backlight);
                    }
                    if (!onChanged || on) continue;
                    DisplayPowerState.this.mDisplayBlanker.blankAllDisplays();
                }
                DisplayPowerState.this.postScreenUpdateThreadSafe();
            }
        };

        private PhotonicModulator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setState(boolean on, int backlight) {
            Object object = this.mLock;
            synchronized (object) {
                if (on != this.mPendingOn || backlight != this.mPendingBacklight) {
                    if (DEBUG) {
                        Slog.d(DisplayPowerState.TAG, "Requesting new screen state: on=" + on + ", backlight=" + backlight);
                    }
                    this.mPendingOn = on;
                    this.mPendingBacklight = backlight;
                    if (!this.mChangeInProgress) {
                        this.mChangeInProgress = true;
                        AsyncTask.THREAD_POOL_EXECUTOR.execute(this.mTask);
                    }
                }
                return this.mChangeInProgress;
            }
        }

        public void dump(PrintWriter pw) {
            pw.println();
            pw.println("Photonic Modulator State:");
            pw.println("  mPendingOn=" + this.mPendingOn);
            pw.println("  mPendingBacklight=" + this.mPendingBacklight);
            pw.println("  mActualOn=" + this.mActualOn);
            pw.println("  mActualBacklight=" + this.mActualBacklight);
            pw.println("  mChangeInProgress=" + this.mChangeInProgress);
        }
    }
}

