/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.content.pm.Signature;
import android.os.Environment;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class SELinuxMMAC {
    private static final String TAG = "SELinuxMMAC";
    private static final boolean DEBUG_POLICY = false;
    private static final boolean DEBUG_POLICY_INSTALL = false;
    private static final HashMap<Signature, String> sSigSeinfo = new HashMap();
    private static final HashMap<String, String> sPackageSeinfo = new HashMap();
    private static final File[] INSTALL_POLICY_FILE = new File[]{new File(Environment.getDataDirectory(), "security/mac_permissions.xml"), new File(Environment.getRootDirectory(), "etc/security/mac_permissions.xml"), null};

    private static void flushInstallPolicy() {
        sSigSeinfo.clear();
        sPackageSeinfo.clear();
    }

    public static boolean readInstallPolicy() {
        return SELinuxMMAC.readInstallPolicy(INSTALL_POLICY_FILE);
    }

    public static boolean readInstallPolicy(File policyFile) {
        return SELinuxMMAC.readInstallPolicy(new File[]{policyFile, null});
    }

    private static boolean readInstallPolicy(File[] policyFiles) {
        FileReader policyFile = null;
        int i = 0;
        while (policyFile == null && policyFiles != null && policyFiles[i] != null) {
            try {
                policyFile = new FileReader(policyFiles[i]);
                break;
            }
            catch (FileNotFoundException e) {
                Slog.d(TAG, "Couldn't find install policy " + policyFiles[i].getPath());
                ++i;
            }
        }
        if (policyFile == null) {
            Slog.d(TAG, "No policy file found. All seinfo values will be null.");
            return false;
        }
        Slog.d(TAG, "Using install policy file " + policyFiles[i].getPath());
        SELinuxMMAC.flushInstallPolicy();
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(policyFile);
            XmlUtils.beginDocument(parser, "policy");
            while (true) {
                XmlUtils.nextElement(parser);
                if (parser.getEventType() == 1) break;
                String tagName = parser.getName();
                if ("signer".equals(tagName)) {
                    Signature signature;
                    String cert = parser.getAttributeValue(null, "signature");
                    if (cert == null) {
                        Slog.w(TAG, "<signer> without signature at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    try {
                        signature = new Signature(cert);
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w(TAG, "<signer> with bad signature at " + parser.getPositionDescription(), e);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    String seinfo = SELinuxMMAC.readSeinfoTag(parser);
                    if (seinfo == null) continue;
                    sSigSeinfo.put(signature, seinfo);
                    continue;
                }
                if ("default".equals(tagName)) {
                    String seinfo = SELinuxMMAC.readSeinfoTag(parser);
                    if (seinfo == null) continue;
                    sSigSeinfo.put(null, seinfo);
                    continue;
                }
                if ("package".equals(tagName)) {
                    String pkgName = parser.getAttributeValue(null, "name");
                    if (pkgName == null) {
                        Slog.w(TAG, "<package> without name at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    String seinfo = SELinuxMMAC.readSeinfoTag(parser);
                    if (seinfo == null) continue;
                    sPackageSeinfo.put(pkgName, seinfo);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Got execption parsing ", e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Got execption parsing ", e);
        }
        try {
            policyFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private static String readSeinfoTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        String seinfo = null;
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfoValue = parser.getAttributeValue(null, "value");
                if (SELinuxMMAC.validateValue(seinfoValue)) {
                    seinfo = seinfoValue;
                } else {
                    Slog.w(TAG, "<seinfo> without valid value at " + parser.getPositionDescription());
                }
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return seinfo;
    }

    private static boolean validateValue(String name) {
        if (name == null) {
            return false;
        }
        int N = name.length();
        if (N == 0) {
            return false;
        }
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static void assignSeinfoValue(PackageParser.Package pkg) {
        String seinfo;
        if ((pkg.applicationInfo.flags & 1) != 0 || (pkg.applicationInfo.flags & 0x80) != 0) {
            for (Signature s : pkg.mSignatures) {
                if (s == null || !sSigSeinfo.containsKey(s)) continue;
                String seinfo2 = pkg.applicationInfo.seinfo = sSigSeinfo.get(s);
                return;
            }
            if (sPackageSeinfo.containsKey(pkg.packageName)) {
                seinfo = pkg.applicationInfo.seinfo = sPackageSeinfo.get(pkg.packageName);
                return;
            }
        }
        seinfo = pkg.applicationInfo.seinfo = sSigSeinfo.get(null);
    }
}

