/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.net.Proxy;
import android.net.http.AndroidHttpClient;
import android.util.Log;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.params.ConnRouteParams;

public class GpsXtraDownloader {
    private static final String TAG = "GpsXtraDownloader";
    static final boolean DEBUG = false;
    private Context mContext;
    private String[] mXtraServers;
    private int mNextServerIndex;

    GpsXtraDownloader(Context context, Properties properties) {
        this.mContext = context;
        int count = 0;
        String server1 = properties.getProperty("XTRA_SERVER_1");
        String server2 = properties.getProperty("XTRA_SERVER_2");
        String server3 = properties.getProperty("XTRA_SERVER_3");
        if (server1 != null) {
            ++count;
        }
        if (server2 != null) {
            ++count;
        }
        if (server3 != null) {
            ++count;
        }
        if (count == 0) {
            Log.e(TAG, "No XTRA servers were specified in the GPS configuration");
            return;
        }
        this.mXtraServers = new String[count];
        count = 0;
        if (server1 != null) {
            this.mXtraServers[count++] = server1;
        }
        if (server2 != null) {
            this.mXtraServers[count++] = server2;
        }
        if (server3 != null) {
            this.mXtraServers[count++] = server3;
        }
        Random random = new Random();
        this.mNextServerIndex = random.nextInt(count);
    }

    byte[] downloadXtraData() {
        String proxyHost = Proxy.getHost(this.mContext);
        int proxyPort = Proxy.getPort(this.mContext);
        boolean useProxy = proxyHost != null && proxyPort != -1;
        byte[] result = null;
        int startIndex = this.mNextServerIndex;
        if (this.mXtraServers == null) {
            return null;
        }
        while (result == null) {
            result = GpsXtraDownloader.doDownload(this.mXtraServers[this.mNextServerIndex], useProxy, proxyHost, proxyPort);
            ++this.mNextServerIndex;
            if (this.mNextServerIndex == this.mXtraServers.length) {
                this.mNextServerIndex = 0;
            }
            if (this.mNextServerIndex != startIndex) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected static byte[] doDownload(String url, boolean isProxySet, String proxyHost, int proxyPort) {
        block20: {
            client = null;
            client = AndroidHttpClient.newInstance("Android");
            req = new HttpGet(url);
            if (isProxySet) {
                proxy = new HttpHost(proxyHost, proxyPort);
                ConnRouteParams.setDefaultProxy(req.getParams(), proxy);
            }
            req.addHeader("Accept", "*/*, application/vnd.wap.mms-message, application/vnd.wap.sic");
            req.addHeader("x-wap-profile", "http://www.openmobilealliance.org/tech/profiles/UAPROF/ccppschema-20021212#");
            response = client.execute(req);
            status = response.getStatusLine();
            if (status.getStatusCode() == 200) break block20;
            var8_9 = null;
            var17_11 = null;
            if (client != null) {
                client.close();
            }
            return var8_9;
        }
        try {
            block21: {
                entity = response.getEntity();
                body = null;
                if (entity == null) break block21;
                try {
                    if (entity.getContentLength() > 0L) {
                        body = new byte[(int)entity.getContentLength()];
                        dis = new DataInputStream(entity.getContent());
                        try {
                            dis.readFully(body);
                            var12_17 = null;
                        }
                        catch (Throwable var11_21) {
                            var12_18 = null;
                            try {
                                dis.close();
                            }
                            catch (IOException e) {
                                Log.e("GpsXtraDownloader", "Unexpected IOException.", e);
                            }
                            throw var11_21;
                        }
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            Log.e("GpsXtraDownloader", "Unexpected IOException.", e);
                        }
                    }
                    var15_22 = null;
                    ** if (entity == null) goto lbl-1000
                }
                catch (Throwable var14_24) {
                    var15_23 = null;
                    if (entity != null) {
                        entity.consumeContent();
                    }
                    throw var14_24;
                }
lbl-1000:
                // 1 sources

                {
                    entity.consumeContent();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            var10_16 = body;
            var17_12 = null;
            if (client != null) {
                client.close();
            }
            return var10_16;
        }
        catch (Exception e) {
            try {
                var17_13 = null;
                if (client != null) {
                    client.close();
                }
            }
            catch (Throwable var16_25) {
                var17_14 = null;
                if (client != null) {
                    client.close();
                }
                throw var16_25;
            }
        }
        return null;
    }
}

