/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ComponentName;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.SparseArray;
import com.android.internal.os.TransferPipe;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ContentProviderRecord;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderMap {
    private static final String TAG = "ProviderMap";
    private static final boolean DBG = false;
    private final ActivityManagerService mAm;
    private final HashMap<String, ContentProviderRecord> mSingletonByName = new HashMap();
    private final HashMap<ComponentName, ContentProviderRecord> mSingletonByClass = new HashMap();
    private final SparseArray<HashMap<String, ContentProviderRecord>> mProvidersByNamePerUser = new SparseArray();
    private final SparseArray<HashMap<ComponentName, ContentProviderRecord>> mProvidersByClassPerUser = new SparseArray();

    ProviderMap(ActivityManagerService am) {
        this.mAm = am;
    }

    ContentProviderRecord getProviderByName(String name) {
        return this.getProviderByName(name, -1);
    }

    ContentProviderRecord getProviderByName(String name, int userId) {
        ContentProviderRecord record = this.mSingletonByName.get(name);
        if (record != null) {
            return record;
        }
        return this.getProvidersByName(userId).get(name);
    }

    ContentProviderRecord getProviderByClass(ComponentName name) {
        return this.getProviderByClass(name, -1);
    }

    ContentProviderRecord getProviderByClass(ComponentName name, int userId) {
        ContentProviderRecord record = this.mSingletonByClass.get(name);
        if (record != null) {
            return record;
        }
        return this.getProvidersByClass(userId).get(name);
    }

    void putProviderByName(String name, ContentProviderRecord record) {
        if (record.singleton) {
            this.mSingletonByName.put(name, record);
        } else {
            int userId = UserHandle.getUserId(record.appInfo.uid);
            this.getProvidersByName(userId).put(name, record);
        }
    }

    void putProviderByClass(ComponentName name, ContentProviderRecord record) {
        if (record.singleton) {
            this.mSingletonByClass.put(name, record);
        } else {
            int userId = UserHandle.getUserId(record.appInfo.uid);
            this.getProvidersByClass(userId).put(name, record);
        }
    }

    void removeProviderByName(String name, int userId) {
        if (this.mSingletonByName.containsKey(name)) {
            this.mSingletonByName.remove(name);
        } else {
            if (userId < 0) {
                throw new IllegalArgumentException("Bad user " + userId);
            }
            HashMap<String, ContentProviderRecord> map = this.getProvidersByName(userId);
            map.remove(name);
            if (map.size() == 0) {
                this.mProvidersByNamePerUser.remove(userId);
            }
        }
    }

    void removeProviderByClass(ComponentName name, int userId) {
        if (this.mSingletonByClass.containsKey(name)) {
            this.mSingletonByClass.remove(name);
        } else {
            if (userId < 0) {
                throw new IllegalArgumentException("Bad user " + userId);
            }
            HashMap<ComponentName, ContentProviderRecord> map = this.getProvidersByClass(userId);
            map.remove(name);
            if (map.size() == 0) {
                this.mProvidersByClassPerUser.remove(userId);
            }
        }
    }

    private HashMap<String, ContentProviderRecord> getProvidersByName(int userId) {
        if (userId < 0) {
            throw new IllegalArgumentException("Bad user " + userId);
        }
        HashMap<String, ContentProviderRecord> map = this.mProvidersByNamePerUser.get(userId);
        if (map == null) {
            HashMap<String, ContentProviderRecord> newMap = new HashMap<String, ContentProviderRecord>();
            this.mProvidersByNamePerUser.put(userId, newMap);
            return newMap;
        }
        return map;
    }

    HashMap<ComponentName, ContentProviderRecord> getProvidersByClass(int userId) {
        if (userId < 0) {
            throw new IllegalArgumentException("Bad user " + userId);
        }
        HashMap<ComponentName, ContentProviderRecord> map = this.mProvidersByClassPerUser.get(userId);
        if (map == null) {
            HashMap<ComponentName, ContentProviderRecord> newMap = new HashMap<ComponentName, ContentProviderRecord>();
            this.mProvidersByClassPerUser.put(userId, newMap);
            return newMap;
        }
        return map;
    }

    private boolean collectForceStopProvidersLocked(String name, int appId, boolean doit, boolean evenPersistent, int userId, HashMap<ComponentName, ContentProviderRecord> providers, ArrayList<ContentProviderRecord> result) {
        boolean didSomething = false;
        for (ContentProviderRecord provider : providers.values()) {
            if (name != null && !provider.info.packageName.equals(name) || provider.proc != null && !evenPersistent && provider.proc.persistent) continue;
            if (!doit) {
                return true;
            }
            didSomething = true;
            result.add(provider);
        }
        return didSomething;
    }

    boolean collectForceStopProviders(String name, int appId, boolean doit, boolean evenPersistent, int userId, ArrayList<ContentProviderRecord> result) {
        boolean didSomething = this.collectForceStopProvidersLocked(name, appId, doit, evenPersistent, userId, this.mSingletonByClass, result);
        if (!doit && didSomething) {
            return true;
        }
        if (userId == -1) {
            for (int i = 0; i < this.mProvidersByClassPerUser.size(); ++i) {
                if (!this.collectForceStopProvidersLocked(name, appId, doit, evenPersistent, userId, this.mProvidersByClassPerUser.valueAt(i), result)) continue;
                if (!doit) {
                    return true;
                }
                didSomething = true;
            }
        } else {
            HashMap<ComponentName, ContentProviderRecord> items = this.getProvidersByClass(userId);
            if (items != null) {
                didSomething |= this.collectForceStopProvidersLocked(name, appId, doit, evenPersistent, userId, items, result);
            }
        }
        return didSomething;
    }

    private boolean dumpProvidersByClassLocked(PrintWriter pw, boolean dumpAll, String dumpPackage, String header, boolean needSep, HashMap<ComponentName, ContentProviderRecord> map) {
        Iterator<Map.Entry<ComponentName, ContentProviderRecord>> it = map.entrySet().iterator();
        boolean written = false;
        while (it.hasNext()) {
            Map.Entry<ComponentName, ContentProviderRecord> e = it.next();
            ContentProviderRecord r = e.getValue();
            if (dumpPackage != null && !dumpPackage.equals(r.appInfo.packageName)) continue;
            if (needSep) {
                pw.println("");
                needSep = false;
            }
            if (header != null) {
                pw.println(header);
                header = null;
            }
            written = true;
            pw.print("  * ");
            pw.println(r);
            r.dump(pw, "    ", dumpAll);
        }
        return written;
    }

    private boolean dumpProvidersByNameLocked(PrintWriter pw, String dumpPackage, String header, boolean needSep, HashMap<String, ContentProviderRecord> map) {
        Iterator<Map.Entry<String, ContentProviderRecord>> it = map.entrySet().iterator();
        boolean written = false;
        while (it.hasNext()) {
            Map.Entry<String, ContentProviderRecord> e = it.next();
            ContentProviderRecord r = e.getValue();
            if (dumpPackage != null && !dumpPackage.equals(r.appInfo.packageName)) continue;
            if (needSep) {
                pw.println("");
                needSep = false;
            }
            if (header != null) {
                pw.println(header);
                header = null;
            }
            written = true;
            pw.print("  ");
            pw.print(e.getKey());
            pw.print(": ");
            pw.println(r.toShortString());
        }
        return written;
    }

    boolean dumpProvidersLocked(PrintWriter pw, boolean dumpAll, String dumpPackage) {
        int i;
        boolean needSep = false;
        if (this.mSingletonByClass.size() > 0) {
            needSep |= this.dumpProvidersByClassLocked(pw, dumpAll, dumpPackage, "  Published single-user content providers (by class):", needSep, this.mSingletonByClass);
        }
        for (i = 0; i < this.mProvidersByClassPerUser.size(); ++i) {
            HashMap<ComponentName, ContentProviderRecord> map = this.mProvidersByClassPerUser.valueAt(i);
            needSep |= this.dumpProvidersByClassLocked(pw, dumpAll, dumpPackage, "  Published user " + this.mProvidersByClassPerUser.keyAt(i) + " content providers (by class):", needSep, map);
        }
        if (dumpAll) {
            needSep |= this.dumpProvidersByNameLocked(pw, dumpPackage, "  Single-user authority to provider mappings:", needSep, this.mSingletonByName);
            for (i = 0; i < this.mProvidersByNamePerUser.size(); ++i) {
                needSep |= this.dumpProvidersByNameLocked(pw, dumpPackage, "  User " + this.mProvidersByNamePerUser.keyAt(i) + " authority to provider mappings:", needSep, this.mProvidersByNamePerUser.valueAt(i));
            }
        }
        return needSep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dumpProvider(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        int i;
        ArrayList<ContentProviderRecord> allProviders = new ArrayList<ContentProviderRecord>();
        ArrayList<ContentProviderRecord> providers = new ArrayList<ContentProviderRecord>();
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            allProviders.addAll(this.mSingletonByClass.values());
            for (i = 0; i < this.mProvidersByClassPerUser.size(); ++i) {
                allProviders.addAll(this.mProvidersByClassPerUser.valueAt(i).values());
            }
            if ("all".equals(name)) {
                providers.addAll(allProviders);
            } else {
                ComponentName componentName = name != null ? ComponentName.unflattenFromString(name) : null;
                int objectId = 0;
                if (componentName == null) {
                    try {
                        objectId = Integer.parseInt(name, 16);
                        name = null;
                        componentName = null;
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                for (int i2 = 0; i2 < allProviders.size(); ++i2) {
                    ContentProviderRecord r1 = (ContentProviderRecord)allProviders.get(i2);
                    if (componentName != null) {
                        if (!r1.name.equals(componentName)) continue;
                        providers.add(r1);
                        continue;
                    }
                    if (name != null) {
                        if (!r1.name.flattenToString().contains(name)) continue;
                        providers.add(r1);
                        continue;
                    }
                    if (System.identityHashCode(r1) != objectId) continue;
                    providers.add(r1);
                }
            }
        }
        if (providers.size() <= 0) {
            return false;
        }
        boolean needSep = false;
        for (i = 0; i < providers.size(); ++i) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            this.dumpProvider("", fd, pw, (ContentProviderRecord)providers.get(i), args, dumpAll);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpProvider(String prefix, FileDescriptor fd, PrintWriter pw, ContentProviderRecord r, String[] args, boolean dumpAll) {
        String innerPrefix = prefix + "  ";
        ActivityManagerService activityManagerService = this.mAm;
        synchronized (activityManagerService) {
            pw.print(prefix);
            pw.print("PROVIDER ");
            pw.print(r);
            pw.print(" pid=");
            if (r.proc != null) {
                pw.println(r.proc.pid);
            } else {
                pw.println("(not running)");
            }
            if (dumpAll) {
                r.dump(pw, innerPrefix, true);
            }
        }
        if (r.proc != null && r.proc.thread != null) {
            pw.println("    Client:");
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.proc.thread.dumpProvider(tp.getWriteFd().getFileDescriptor(), r.provider.asBinder(), args);
                    tp.setBufferPrefix("      ");
                    tp.go(fd, 2000L);
                    Object var11_12 = null;
                    tp.kill();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    tp.kill();
                    throw throwable;
                }
            }
            catch (IOException ex) {
                pw.println("      Failure while dumping the provider: " + ex);
            }
            catch (RemoteException ex) {
                pw.println("      Got a RemoteException while dumping the service");
            }
        }
    }
}

