/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.view.WindowManager;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.AppErrorResult;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.ProcessRecord;

final class AppErrorDialog
extends BaseErrorDialog {
    private final ActivityManagerService mService;
    private final AppErrorResult mResult;
    private final ProcessRecord mProc;
    static final int FORCE_QUIT = 0;
    static final int FORCE_QUIT_AND_REPORT = 1;
    static final long DISMISS_TIMEOUT = 300000L;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            ActivityManagerService activityManagerService = AppErrorDialog.this.mService;
            synchronized (activityManagerService) {
                if (AppErrorDialog.this.mProc != null && ((AppErrorDialog)AppErrorDialog.this).mProc.crashDialog == AppErrorDialog.this) {
                    ((AppErrorDialog)AppErrorDialog.this).mProc.crashDialog = null;
                }
            }
            AppErrorDialog.this.mResult.set(msg.what);
            AppErrorDialog.this.dismiss();
        }
    };

    public AppErrorDialog(Context context, ActivityManagerService service, AppErrorResult result, ProcessRecord app) {
        super(context);
        CharSequence name;
        Resources res = context.getResources();
        this.mService = service;
        this.mProc = app;
        this.mResult = result;
        if (app.pkgList.size() == 1 && (name = context.getPackageManager().getApplicationLabel(app.info)) != null) {
            this.setMessage(res.getString(17040378, name.toString(), app.info.processName));
        } else {
            name = app.processName;
            this.setMessage(res.getString(17040379, name.toString()));
        }
        this.setCancelable(false);
        this.setButton(-1, res.getText(0x1040401), this.mHandler.obtainMessage(0));
        if (app.errorReportReceiver != null) {
            this.setButton(-2, res.getText(17040386), this.mHandler.obtainMessage(1));
        }
        this.setTitle(res.getText(17040377));
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.setTitle("Application Error: " + app.info.processName);
        attrs.privateFlags |= 0x110;
        this.getWindow().setAttributes(attrs);
        if (app.persistent) {
            this.getWindow().setType(2010);
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0), 300000L);
    }
}

