/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.IUiModeManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.Handler;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.dreams.Sandman;
import android.util.Slog;
import com.android.internal.app.DisableCarModeActivity;
import com.android.server.TwilightService;
import java.io.FileDescriptor;
import java.io.PrintWriter;

final class UiModeManagerService
extends IUiModeManager.Stub {
    private static final String TAG = UiModeManager.class.getSimpleName();
    private static final boolean LOG = false;
    private static final boolean ENABLE_LAUNCH_CAR_DOCK_APP = true;
    private static final boolean ENABLE_LAUNCH_DESK_DOCK_APP = true;
    private final Context mContext;
    private final TwilightService mTwilightService;
    private final Handler mHandler = new Handler();
    final Object mLock = new Object();
    private int mDockState = 0;
    private int mLastBroadcastState = 0;
    private int mNightMode = 1;
    private boolean mCarModeEnabled = false;
    private boolean mCharging = false;
    private final int mDefaultUiModeType;
    private final boolean mCarModeKeepsScreenOn;
    private final boolean mDeskModeKeepsScreenOn;
    private final boolean mTelevision;
    private boolean mComputedNightMode;
    private int mCurUiMode = 0;
    private int mSetUiMode = 0;
    private boolean mHoldingConfiguration = false;
    private Configuration mConfiguration = new Configuration();
    private boolean mSystemReady;
    private NotificationManager mNotificationManager;
    private StatusBarManager mStatusBarManager;
    private final PowerManager mPowerManager;
    private final PowerManager.WakeLock mWakeLock;
    private final BroadcastReceiver mResultReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (this.getResultCode() != -1) {
                return;
            }
            int enableFlags = intent.getIntExtra("enableFlags", 0);
            int disableFlags = intent.getIntExtra("disableFlags", 0);
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                UiModeManagerService.this.updateAfterBroadcastLocked(intent.getAction(), enableFlags, disableFlags);
            }
        }
    };
    private final BroadcastReceiver mDockModeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
            UiModeManagerService.this.updateDockState(state);
        }
    };
    private final BroadcastReceiver mBatteryReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UiModeManagerService.this.mCharging = intent.getIntExtra("plugged", 0) != 0;
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                if (UiModeManagerService.this.mSystemReady) {
                    UiModeManagerService.this.updateLocked(0, 0);
                }
            }
        }
    };
    private final TwilightService.TwilightListener mTwilightListener = new TwilightService.TwilightListener(){

        public void onTwilightStateChanged() {
            UiModeManagerService.this.updateTwilight();
        }
    };

    static Intent buildHomeIntent(String category) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory(category);
        intent.setFlags(0x10200000);
        return intent;
    }

    public UiModeManagerService(Context context, TwilightService twilight) {
        this.mContext = context;
        this.mTwilightService = twilight;
        ServiceManager.addService("uimode", this);
        this.mContext.registerReceiver(this.mDockModeReceiver, new IntentFilter("android.intent.action.DOCK_EVENT"));
        this.mContext.registerReceiver(this.mBatteryReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = this.mPowerManager.newWakeLock(26, TAG);
        this.mConfiguration.setToDefaults();
        this.mDefaultUiModeType = context.getResources().getInteger(17694743);
        this.mCarModeKeepsScreenOn = context.getResources().getInteger(17694745) == 1;
        this.mDeskModeKeepsScreenOn = context.getResources().getInteger(17694744) == 1;
        this.mTelevision = context.getPackageManager().hasSystemFeature("android.hardware.type.television");
        this.mNightMode = Settings.Secure.getInt(this.mContext.getContentResolver(), "ui_night_mode", 0);
        this.mTwilightService.registerListener(this.mTwilightListener, this.mHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCarMode(int flags) {
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.setCarModeLocked(false);
                if (this.mSystemReady) {
                    this.updateLocked(0, flags);
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCarMode(int flags) {
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.setCarModeLocked(true);
                if (this.mSystemReady) {
                    this.updateLocked(flags, 0);
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCurrentModeType() {
        int n;
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                n = this.mCurUiMode & 0xF;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNightMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isDoingNightModeLocked() && this.mNightMode != mode) {
                    Settings.Secure.putInt(this.mContext.getContentResolver(), "ui_night_mode", mode);
                    this.mNightMode = mode;
                    this.updateLocked(0, 0);
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNightMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNightMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemReady = true;
            this.mCarModeEnabled = this.mDockState == 2;
            this.updateComputedNightModeLocked();
            this.updateLocked(0, 0);
        }
    }

    private boolean isDoingNightModeLocked() {
        return this.mCarModeEnabled || this.mDockState != 0;
    }

    private void setCarModeLocked(boolean enabled) {
        if (this.mCarModeEnabled != enabled) {
            this.mCarModeEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDockState(int newState) {
        Object object = this.mLock;
        synchronized (object) {
            if (newState != this.mDockState) {
                this.mDockState = newState;
                this.setCarModeLocked(this.mDockState == 2);
                if (this.mSystemReady) {
                    this.updateLocked(1, 0);
                }
            }
        }
    }

    private static boolean isDeskDockState(int state) {
        switch (state) {
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void updateConfigurationLocked() {
        int uiMode;
        int n = uiMode = this.mTelevision ? 4 : this.mDefaultUiModeType;
        if (this.mCarModeEnabled) {
            uiMode = 3;
        } else if (UiModeManagerService.isDeskDockState(this.mDockState)) {
            uiMode = 2;
        }
        if (this.mCarModeEnabled) {
            if (this.mNightMode == 0) {
                this.updateComputedNightModeLocked();
                uiMode |= this.mComputedNightMode ? 32 : 16;
            } else {
                uiMode |= this.mNightMode << 4;
            }
        } else {
            uiMode = uiMode & 0xFFFFFFCF | 0x10;
        }
        this.mCurUiMode = uiMode;
        if (!this.mHoldingConfiguration) {
            this.mConfiguration.uiMode = uiMode;
        }
    }

    private void sendConfigurationLocked() {
        if (this.mSetUiMode != this.mConfiguration.uiMode) {
            this.mSetUiMode = this.mConfiguration.uiMode;
            try {
                ActivityManagerNative.getDefault().updateConfiguration(this.mConfiguration);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failure communicating with activity manager", e);
            }
        }
    }

    private void updateLocked(int enableFlags, int disableFlags) {
        boolean keepScreenOn;
        String action = null;
        String oldAction = null;
        if (this.mLastBroadcastState == 2) {
            this.adjustStatusBarCarModeLocked();
            oldAction = UiModeManager.ACTION_EXIT_CAR_MODE;
        } else if (UiModeManagerService.isDeskDockState(this.mLastBroadcastState)) {
            oldAction = UiModeManager.ACTION_EXIT_DESK_MODE;
        }
        if (this.mCarModeEnabled) {
            if (this.mLastBroadcastState != 2) {
                this.adjustStatusBarCarModeLocked();
                if (oldAction != null) {
                    this.mContext.sendBroadcastAsUser(new Intent(oldAction), UserHandle.ALL);
                }
                this.mLastBroadcastState = 2;
                action = UiModeManager.ACTION_ENTER_CAR_MODE;
            }
        } else if (UiModeManagerService.isDeskDockState(this.mDockState)) {
            if (!UiModeManagerService.isDeskDockState(this.mLastBroadcastState)) {
                if (oldAction != null) {
                    this.mContext.sendBroadcastAsUser(new Intent(oldAction), UserHandle.ALL);
                }
                this.mLastBroadcastState = this.mDockState;
                action = UiModeManager.ACTION_ENTER_DESK_MODE;
            }
        } else {
            this.mLastBroadcastState = 0;
            action = oldAction;
        }
        if (action != null) {
            Intent intent = new Intent(action);
            intent.putExtra("enableFlags", enableFlags);
            intent.putExtra("disableFlags", disableFlags);
            this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.CURRENT, null, this.mResultReceiver, null, -1, null, null);
            this.mHoldingConfiguration = true;
            this.updateConfigurationLocked();
        } else {
            String category = null;
            if (this.mCarModeEnabled) {
                if ((enableFlags & 1) != 0) {
                    category = "android.intent.category.CAR_DOCK";
                }
            } else if (UiModeManagerService.isDeskDockState(this.mDockState)) {
                if ((enableFlags & 1) != 0) {
                    category = "android.intent.category.DESK_DOCK";
                }
            } else if ((disableFlags & 1) != 0) {
                category = "android.intent.category.HOME";
            }
            this.sendConfigurationAndStartDreamOrDockAppLocked(category);
        }
        boolean bl = keepScreenOn = this.mCharging && (this.mCarModeEnabled && this.mCarModeKeepsScreenOn || this.mCurUiMode == 2 && this.mDeskModeKeepsScreenOn);
        if (keepScreenOn != this.mWakeLock.isHeld()) {
            if (keepScreenOn) {
                this.mWakeLock.acquire();
            } else {
                this.mWakeLock.release();
            }
        }
    }

    private void updateAfterBroadcastLocked(String action, int enableFlags, int disableFlags) {
        String category = null;
        if (UiModeManager.ACTION_ENTER_CAR_MODE.equals(action)) {
            if ((enableFlags & 1) != 0) {
                category = "android.intent.category.CAR_DOCK";
            }
        } else if (UiModeManager.ACTION_ENTER_DESK_MODE.equals(action)) {
            if ((enableFlags & 1) != 0) {
                category = "android.intent.category.DESK_DOCK";
            }
        } else if ((disableFlags & 1) != 0) {
            category = "android.intent.category.HOME";
        }
        this.sendConfigurationAndStartDreamOrDockAppLocked(category);
    }

    private void sendConfigurationAndStartDreamOrDockAppLocked(String category) {
        Intent homeIntent;
        this.mHoldingConfiguration = false;
        this.updateConfigurationLocked();
        boolean dockAppStarted = false;
        if (category != null && Sandman.shouldStartDockApp(this.mContext, homeIntent = UiModeManagerService.buildHomeIntent(category))) {
            try {
                int result = ActivityManagerNative.getDefault().startActivityWithConfig(null, null, homeIntent, null, null, null, 0, 0, this.mConfiguration, null, -2);
                if (result >= 0) {
                    dockAppStarted = true;
                } else if (result != -1) {
                    Slog.e(TAG, "Could not start dock app: " + homeIntent + ", startActivityWithConfig result " + result);
                }
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "Could not start dock app: " + homeIntent, ex);
            }
        }
        this.sendConfigurationLocked();
        if (category != null && !dockAppStarted) {
            Sandman.startDreamWhenDockedIfAppropriate(this.mContext);
        }
    }

    private void adjustStatusBarCarModeLocked() {
        if (this.mStatusBarManager == null) {
            this.mStatusBarManager = (StatusBarManager)this.mContext.getSystemService("statusbar");
        }
        if (this.mStatusBarManager != null) {
            this.mStatusBarManager.disable(this.mCarModeEnabled ? 524288 : 0);
        }
        if (this.mNotificationManager == null) {
            this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        }
        if (this.mNotificationManager != null) {
            if (this.mCarModeEnabled) {
                Intent carModeOffIntent = new Intent(this.mContext, DisableCarModeActivity.class);
                Notification n = new Notification();
                n.icon = 17302913;
                n.defaults = 4;
                n.flags = 2;
                n.when = 0L;
                n.setLatestEventInfo(this.mContext, this.mContext.getString(17040574), this.mContext.getString(17040575), PendingIntent.getActivityAsUser(this.mContext, 0, carModeOffIntent, 0, null, UserHandle.CURRENT));
                this.mNotificationManager.notifyAsUser(null, 17040574, n, UserHandle.ALL);
            } else {
                this.mNotificationManager.cancelAsUser(null, 17040574, UserHandle.ALL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTwilight() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDoingNightModeLocked() && this.mNightMode == 0) {
                this.updateComputedNightModeLocked();
                this.updateLocked(0, 0);
            }
        }
    }

    private void updateComputedNightModeLocked() {
        TwilightService.TwilightState state = this.mTwilightService.getCurrentState();
        if (state != null) {
            this.mComputedNightMode = state.isNight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump uimode service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current UI Mode Service state:");
            pw.print("  mDockState=");
            pw.print(this.mDockState);
            pw.print(" mLastBroadcastState=");
            pw.println(this.mLastBroadcastState);
            pw.print("  mNightMode=");
            pw.print(this.mNightMode);
            pw.print(" mCarModeEnabled=");
            pw.print(this.mCarModeEnabled);
            pw.print(" mComputedNightMode=");
            pw.println(this.mComputedNightMode);
            pw.print("  mCurUiMode=0x");
            pw.print(Integer.toHexString(this.mCurUiMode));
            pw.print(" mSetUiMode=0x");
            pw.println(Integer.toHexString(this.mSetUiMode));
            pw.print("  mHoldingConfiguration=");
            pw.print(this.mHoldingConfiguration);
            pw.print(" mSystemReady=");
            pw.println(this.mSystemReady);
            pw.print("  mTwilightService.getCurrentState()=");
            pw.println(this.mTwilightService.getCurrentState());
        }
    }
}

