/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.IUserSwitchObserver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.content.PackageMonitor;
import com.android.internal.textservice.ISpellCheckerService;
import com.android.internal.textservice.ISpellCheckerSession;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import com.android.internal.textservice.ITextServicesManager;
import com.android.internal.textservice.ITextServicesSessionListener;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextServicesManagerService
extends ITextServicesManager.Stub {
    private static final String TAG = TextServicesManagerService.class.getSimpleName();
    private static final boolean DBG = false;
    private final Context mContext;
    private boolean mSystemReady = false;
    private final TextServicesMonitor mMonitor;
    private final HashMap<String, SpellCheckerInfo> mSpellCheckerMap = new HashMap();
    private final ArrayList<SpellCheckerInfo> mSpellCheckerList = new ArrayList();
    private final HashMap<String, SpellCheckerBindGroup> mSpellCheckerBindGroups = new HashMap();
    private final TextServicesSettings mSettings;

    public void systemRunning() {
        if (!this.mSystemReady) {
            this.mSystemReady = true;
        }
    }

    public TextServicesManagerService(Context context) {
        this.mContext = context;
        int userId = 0;
        try {
            ActivityManagerNative.getDefault().registerUserSwitchObserver(new IUserSwitchObserver.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onUserSwitching(int newUserId, IRemoteCallback reply) {
                    HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
                    synchronized (hashMap) {
                        TextServicesManagerService.this.switchUserLocked(newUserId);
                    }
                    if (reply != null) {
                        try {
                            reply.sendResult(null);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }

                public void onUserSwitchComplete(int newUserId) throws RemoteException {
                }
            });
            userId = ActivityManagerNative.getDefault().getCurrentUser().id;
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Couldn't get current user ID; guessing it's 0", e);
        }
        this.mMonitor = new TextServicesMonitor();
        this.mMonitor.register(context, null, true);
        this.mSettings = new TextServicesSettings(context.getContentResolver(), userId);
        this.switchUserLocked(userId);
    }

    private void switchUserLocked(int userId) {
        this.mSettings.setCurrentUserId(userId);
        this.unbindServiceLocked();
        TextServicesManagerService.buildSpellCheckerMapLocked(this.mContext, this.mSpellCheckerList, this.mSpellCheckerMap, this.mSettings);
        SpellCheckerInfo sci = this.getCurrentSpellChecker(null);
        if (sci == null && (sci = this.findAvailSpellCheckerLocked(null, null)) != null) {
            this.setCurrentSpellCheckerLocked(sci.getId());
        }
    }

    private static void buildSpellCheckerMapLocked(Context context, ArrayList<SpellCheckerInfo> list, HashMap<String, SpellCheckerInfo> map, TextServicesSettings settings) {
        list.clear();
        map.clear();
        PackageManager pm = context.getPackageManager();
        List<ResolveInfo> services = pm.queryIntentServicesAsUser(new Intent("android.service.textservice.SpellCheckerService"), 128, settings.getCurrentUserId());
        int N = services.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = services.get(i);
            ServiceInfo si = ri.serviceInfo;
            ComponentName compName = new ComponentName(si.packageName, si.name);
            if (!"android.permission.BIND_TEXT_SERVICE".equals(si.permission)) {
                Slog.w(TAG, "Skipping text service " + compName + ": it does not require the permission " + "android.permission.BIND_TEXT_SERVICE");
                continue;
            }
            try {
                SpellCheckerInfo sci = new SpellCheckerInfo(context, ri);
                if (sci.getSubtypeCount() <= 0) {
                    Slog.w(TAG, "Skipping text service " + compName + ": it does not contain subtypes.");
                    continue;
                }
                list.add(sci);
                map.put(sci.getId(), sci);
                continue;
            }
            catch (XmlPullParserException e) {
                Slog.w(TAG, "Unable to load the spell checker " + compName, e);
                continue;
            }
            catch (IOException e) {
                Slog.w(TAG, "Unable to load the spell checker " + compName, e);
            }
        }
    }

    private boolean calledFromValidUser() {
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getUserId(uid);
        if (uid == 1000 || userId == this.mSettings.getCurrentUserId()) {
            return true;
        }
        Slog.w(TAG, "--- IPC called from background users. Ignore. \n" + TextServicesManagerService.getStackTrace());
        return false;
    }

    private boolean bindCurrentSpellCheckerService(Intent service, ServiceConnection conn, int flags) {
        if (service == null || conn == null) {
            Slog.e(TAG, "--- bind failed: service = " + service + ", conn = " + conn);
            return false;
        }
        return this.mContext.bindServiceAsUser(service, conn, flags, new UserHandle(this.mSettings.getCurrentUserId()));
    }

    private void unbindServiceLocked() {
        for (SpellCheckerBindGroup scbg : this.mSpellCheckerBindGroups.values()) {
            scbg.removeAll();
        }
        this.mSpellCheckerBindGroups.clear();
    }

    private SpellCheckerInfo findAvailSpellCheckerLocked(String locale, String prefPackage) {
        int spellCheckersCount = this.mSpellCheckerList.size();
        if (spellCheckersCount == 0) {
            Slog.w(TAG, "no available spell checker services found");
            return null;
        }
        if (prefPackage != null) {
            for (int i = 0; i < spellCheckersCount; ++i) {
                SpellCheckerInfo sci = this.mSpellCheckerList.get(i);
                if (!prefPackage.equals(sci.getPackageName())) continue;
                return sci;
            }
        }
        if (spellCheckersCount > 1) {
            Slog.w(TAG, "more than one spell checker service found, picking first");
        }
        return this.mSpellCheckerList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpellCheckerInfo getCurrentSpellChecker(String locale) {
        if (!this.calledFromValidUser()) {
            return null;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            String curSpellCheckerId = this.mSettings.getSelectedSpellChecker();
            if (TextUtils.isEmpty(curSpellCheckerId)) {
                return null;
            }
            return this.mSpellCheckerMap.get(curSpellCheckerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpellCheckerSubtype getCurrentSpellCheckerSubtype(String locale, boolean allowImplicitlySelectedSubtype) {
        if (!this.calledFromValidUser()) {
            return null;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            String subtypeHashCodeStr = this.mSettings.getSelectedSpellCheckerSubtype();
            SpellCheckerInfo sci = this.getCurrentSpellChecker(null);
            if (sci == null || sci.getSubtypeCount() == 0) {
                return null;
            }
            int hashCode = !TextUtils.isEmpty(subtypeHashCodeStr) ? Integer.valueOf(subtypeHashCodeStr) : 0;
            if (hashCode == 0 && !allowImplicitlySelectedSubtype) {
                return null;
            }
            String candidateLocale = null;
            if (hashCode == 0) {
                String localeString;
                InputMethodSubtype currentInputMethodSubtype;
                InputMethodManager imm = (InputMethodManager)this.mContext.getSystemService("input_method");
                if (imm != null && (currentInputMethodSubtype = imm.getCurrentInputMethodSubtype()) != null && !TextUtils.isEmpty(localeString = currentInputMethodSubtype.getLocale())) {
                    candidateLocale = localeString;
                }
                if (candidateLocale == null) {
                    candidateLocale = this.mContext.getResources().getConfiguration().locale.toString();
                }
            }
            SpellCheckerSubtype candidate = null;
            for (int i = 0; i < sci.getSubtypeCount(); ++i) {
                SpellCheckerSubtype scs = sci.getSubtypeAt(i);
                if (hashCode == 0) {
                    String scsLocale = scs.getLocale();
                    if (candidateLocale.equals(scsLocale)) {
                        return scs;
                    }
                    if (candidate != null || candidateLocale.length() < 2 || scsLocale.length() < 2 || !candidateLocale.startsWith(scsLocale)) continue;
                    candidate = scs;
                    continue;
                }
                if (scs.hashCode() != hashCode) continue;
                return scs;
            }
            return candidate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSpellCheckerService(String sciId, String locale, ITextServicesSessionListener tsListener, ISpellCheckerSessionListener scListener, Bundle bundle) {
        if (!this.calledFromValidUser()) {
            return;
        }
        if (!this.mSystemReady) {
            return;
        }
        if (TextUtils.isEmpty(sciId) || tsListener == null || scListener == null) {
            Slog.e(TAG, "getSpellCheckerService: Invalid input.");
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            SpellCheckerBindGroup bindGroup;
            if (!this.mSpellCheckerMap.containsKey(sciId)) {
                return;
            }
            SpellCheckerInfo sci = this.mSpellCheckerMap.get(sciId);
            int uid = Binder.getCallingUid();
            if (this.mSpellCheckerBindGroups.containsKey(sciId) && (bindGroup = this.mSpellCheckerBindGroups.get(sciId)) != null) {
                InternalDeathRecipient recipient = this.mSpellCheckerBindGroups.get(sciId).addListener(tsListener, locale, scListener, uid, bundle);
                if (recipient == null) {
                    return;
                }
                if (bindGroup.mSpellChecker == null & bindGroup.mConnected) {
                    Slog.e(TAG, "The state of the spell checker bind group is illegal.");
                    bindGroup.removeAll();
                } else if (bindGroup.mSpellChecker != null) {
                    try {
                        ISpellCheckerSession session = bindGroup.mSpellChecker.getISpellCheckerSession(recipient.mScLocale, recipient.mScListener, bundle);
                        if (session != null) {
                            tsListener.onServiceConnected(session);
                            return;
                        }
                        bindGroup.removeAll();
                    }
                    catch (RemoteException e) {
                        Slog.e(TAG, "Exception in getting spell checker session: " + e);
                        bindGroup.removeAll();
                    }
                }
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.startSpellCheckerServiceInnerLocked(sci, locale, tsListener, scListener, uid, bundle);
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSpellCheckerEnabled() {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            return this.isSpellCheckerEnabledLocked();
        }
    }

    private void startSpellCheckerServiceInnerLocked(SpellCheckerInfo info, String locale, ITextServicesSessionListener tsListener, ISpellCheckerSessionListener scListener, int uid, Bundle bundle) {
        String sciId = info.getId();
        InternalServiceConnection connection = new InternalServiceConnection(sciId, locale, bundle);
        Intent serviceIntent = new Intent("android.service.textservice.SpellCheckerService");
        serviceIntent.setComponent(info.getComponent());
        if (!this.bindCurrentSpellCheckerService(serviceIntent, connection, 1)) {
            Slog.e(TAG, "Failed to get a spell checker service.");
            return;
        }
        SpellCheckerBindGroup group = new SpellCheckerBindGroup(connection, tsListener, locale, scListener, uid, bundle);
        this.mSpellCheckerBindGroups.put(sciId, group);
    }

    @Override
    public SpellCheckerInfo[] getEnabledSpellCheckers() {
        if (!this.calledFromValidUser()) {
            return null;
        }
        return this.mSpellCheckerList.toArray(new SpellCheckerInfo[this.mSpellCheckerList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSpellCheckerService(ISpellCheckerSessionListener listener) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            ArrayList<SpellCheckerBindGroup> removeList = new ArrayList<SpellCheckerBindGroup>();
            for (SpellCheckerBindGroup group : this.mSpellCheckerBindGroups.values()) {
                if (group == null) continue;
                removeList.add(group);
            }
            int removeSize = removeList.size();
            for (int i = 0; i < removeSize; ++i) {
                ((SpellCheckerBindGroup)removeList.get(i)).removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentSpellChecker(String locale, String sciId) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
            this.setCurrentSpellCheckerLocked(sciId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentSpellCheckerSubtype(String locale, int hashCode) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
            this.setCurrentSpellCheckerSubtypeLocked(hashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpellCheckerEnabled(boolean enabled) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
            this.setSpellCheckerEnabledLocked(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentSpellCheckerLocked(String sciId) {
        if (TextUtils.isEmpty(sciId) || !this.mSpellCheckerMap.containsKey(sciId)) {
            return;
        }
        SpellCheckerInfo currentSci = this.getCurrentSpellChecker(null);
        if (currentSci != null && currentSci.getId().equals(sciId)) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mSettings.putSelectedSpellChecker(sciId);
            this.setCurrentSpellCheckerSubtypeLocked(0);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentSpellCheckerSubtypeLocked(int hashCode) {
        SpellCheckerInfo sci = this.getCurrentSpellChecker(null);
        int tempHashCode = 0;
        for (int i = 0; sci != null && i < sci.getSubtypeCount(); ++i) {
            if (sci.getSubtypeAt(i).hashCode() != hashCode) continue;
            tempHashCode = hashCode;
            break;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mSettings.putSelectedSpellCheckerSubtype(tempHashCode);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSpellCheckerEnabledLocked(boolean enabled) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mSettings.setSpellCheckerEnabled(enabled);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSpellCheckerEnabledLocked() {
        boolean bl;
        long ident = Binder.clearCallingIdentity();
        try {
            boolean retval;
            bl = retval = this.mSettings.isSpellCheckerEnabled();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump TextServicesManagerService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            int i;
            pw.println("Current Text Services Manager state:");
            pw.println("  Spell Checker Map:");
            for (Map.Entry<String, SpellCheckerInfo> entry : this.mSpellCheckerMap.entrySet()) {
                pw.print("    ");
                pw.print(entry.getKey());
                pw.println(":");
                SpellCheckerInfo info = entry.getValue();
                pw.print("      ");
                pw.print("id=");
                pw.println(info.getId());
                pw.print("      ");
                pw.print("comp=");
                pw.println(info.getComponent().toShortString());
                int NS = info.getSubtypeCount();
                for (i = 0; i < NS; ++i) {
                    SpellCheckerSubtype st = info.getSubtypeAt(i);
                    pw.print("      ");
                    pw.print("Subtype #");
                    pw.print(i);
                    pw.println(":");
                    pw.print("        ");
                    pw.print("locale=");
                    pw.println(st.getLocale());
                    pw.print("        ");
                    pw.print("extraValue=");
                    pw.println(st.getExtraValue());
                }
            }
            pw.println("");
            pw.println("  Spell Checker Bind Groups:");
            for (Map.Entry<String, Object> entry : this.mSpellCheckerBindGroups.entrySet()) {
                SpellCheckerBindGroup grp = (SpellCheckerBindGroup)entry.getValue();
                pw.print("    ");
                pw.print(entry.getKey());
                pw.print(" ");
                pw.print(grp);
                pw.println(":");
                pw.print("      ");
                pw.print("mInternalConnection=");
                pw.println(grp.mInternalConnection);
                pw.print("      ");
                pw.print("mSpellChecker=");
                pw.println(grp.mSpellChecker);
                pw.print("      ");
                pw.print("mBound=");
                pw.print(grp.mBound);
                pw.print(" mConnected=");
                pw.println(grp.mConnected);
                int NL = grp.mListeners.size();
                for (i = 0; i < NL; ++i) {
                    InternalDeathRecipient listener = (InternalDeathRecipient)grp.mListeners.get(i);
                    pw.print("      ");
                    pw.print("Listener #");
                    pw.print(i);
                    pw.println(":");
                    pw.print("        ");
                    pw.print("mTsListener=");
                    pw.println(listener.mTsListener);
                    pw.print("        ");
                    pw.print("mScListener=");
                    pw.println(listener.mScListener);
                    pw.print("        ");
                    pw.print("mGroup=");
                    pw.println(listener.mGroup);
                    pw.print("        ");
                    pw.print("mScLocale=");
                    pw.print(listener.mScLocale);
                    pw.print(" mUid=");
                    pw.println(listener.mUid);
                }
            }
        }
    }

    private static String getStackTrace() {
        StringBuilder sb = new StringBuilder();
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            StackTraceElement[] frames = e.getStackTrace();
            for (int j = 1; j < frames.length; ++j) {
                sb.append(frames[j].toString() + "\n");
            }
            return sb.toString();
        }
    }

    private static class TextServicesSettings {
        private final ContentResolver mResolver;
        private int mCurrentUserId;

        public TextServicesSettings(ContentResolver resolver, int userId) {
            this.mResolver = resolver;
            this.mCurrentUserId = userId;
        }

        public void setCurrentUserId(int userId) {
            this.mCurrentUserId = userId;
        }

        public int getCurrentUserId() {
            return this.mCurrentUserId;
        }

        public void putSelectedSpellChecker(String sciId) {
            Settings.Secure.putStringForUser(this.mResolver, "selected_spell_checker", sciId, this.mCurrentUserId);
        }

        public void putSelectedSpellCheckerSubtype(int hashCode) {
            Settings.Secure.putStringForUser(this.mResolver, "selected_spell_checker_subtype", String.valueOf(hashCode), this.mCurrentUserId);
        }

        public void setSpellCheckerEnabled(boolean enabled) {
            Settings.Secure.putIntForUser(this.mResolver, "spell_checker_enabled", enabled ? 1 : 0, this.mCurrentUserId);
        }

        public String getSelectedSpellChecker() {
            return Settings.Secure.getStringForUser(this.mResolver, "selected_spell_checker", this.mCurrentUserId);
        }

        public String getSelectedSpellCheckerSubtype() {
            return Settings.Secure.getStringForUser(this.mResolver, "selected_spell_checker_subtype", this.mCurrentUserId);
        }

        public boolean isSpellCheckerEnabled() {
            return Settings.Secure.getIntForUser(this.mResolver, "spell_checker_enabled", 1, this.mCurrentUserId) == 1;
        }
    }

    private class InternalDeathRecipient
    implements IBinder.DeathRecipient {
        public final ITextServicesSessionListener mTsListener;
        public final ISpellCheckerSessionListener mScListener;
        public final String mScLocale;
        private final SpellCheckerBindGroup mGroup;
        public final int mUid;
        public final Bundle mBundle;

        public InternalDeathRecipient(SpellCheckerBindGroup group, ITextServicesSessionListener tsListener, String scLocale, ISpellCheckerSessionListener scListener, int uid, Bundle bundle) {
            this.mTsListener = tsListener;
            this.mScListener = scListener;
            this.mScLocale = scLocale;
            this.mGroup = group;
            this.mUid = uid;
            this.mBundle = bundle;
        }

        public boolean hasSpellCheckerListener(ISpellCheckerSessionListener listener) {
            return listener.asBinder().equals(this.mScListener.asBinder());
        }

        public void binderDied() {
            this.mGroup.removeListener(this.mScListener);
        }
    }

    private class InternalServiceConnection
    implements ServiceConnection {
        private final String mSciId;
        private final String mLocale;
        private final Bundle mBundle;

        public InternalServiceConnection(String id2, String locale, Bundle bundle) {
            this.mSciId = id2;
            this.mLocale = locale;
            this.mBundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                this.onServiceConnectedInnerLocked(name, service);
            }
        }

        private void onServiceConnectedInnerLocked(ComponentName name, IBinder service) {
            ISpellCheckerService spellChecker = ISpellCheckerService.Stub.asInterface(service);
            SpellCheckerBindGroup group = (SpellCheckerBindGroup)TextServicesManagerService.this.mSpellCheckerBindGroups.get(this.mSciId);
            if (group != null && this == group.mInternalConnection) {
                group.onServiceConnected(spellChecker);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                SpellCheckerBindGroup group = (SpellCheckerBindGroup)TextServicesManagerService.this.mSpellCheckerBindGroups.get(this.mSciId);
                if (group != null && this == group.mInternalConnection) {
                    TextServicesManagerService.this.mSpellCheckerBindGroups.remove(this.mSciId);
                }
            }
        }
    }

    private class SpellCheckerBindGroup {
        private final String TAG = SpellCheckerBindGroup.class.getSimpleName();
        private final InternalServiceConnection mInternalConnection;
        private final CopyOnWriteArrayList<InternalDeathRecipient> mListeners = new CopyOnWriteArrayList();
        public boolean mBound;
        public ISpellCheckerService mSpellChecker;
        public boolean mConnected;

        public SpellCheckerBindGroup(InternalServiceConnection connection, ITextServicesSessionListener listener, String locale, ISpellCheckerSessionListener scListener, int uid, Bundle bundle) {
            this.mInternalConnection = connection;
            this.mBound = true;
            this.mConnected = false;
            this.addListener(listener, locale, scListener, uid, bundle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ISpellCheckerService spellChecker) {
            for (InternalDeathRecipient listener : this.mListeners) {
                try {
                    ISpellCheckerSession session = spellChecker.getISpellCheckerSession(listener.mScLocale, listener.mScListener, listener.mBundle);
                    HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
                    synchronized (hashMap) {
                        if (this.mListeners.contains(listener)) {
                            listener.mTsListener.onServiceConnected(session);
                        }
                    }
                }
                catch (RemoteException e) {
                    Slog.e(this.TAG, "Exception in getting the spell checker session.Reconnect to the spellchecker. ", e);
                    this.removeAll();
                    return;
                }
            }
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                this.mSpellChecker = spellChecker;
                this.mConnected = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InternalDeathRecipient addListener(ITextServicesSessionListener tsListener, String locale, ISpellCheckerSessionListener scListener, int uid, Bundle bundle) {
            InternalDeathRecipient recipient = null;
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                try {
                    int size = this.mListeners.size();
                    for (int i = 0; i < size; ++i) {
                        if (!this.mListeners.get(i).hasSpellCheckerListener(scListener)) continue;
                        return null;
                    }
                    recipient = new InternalDeathRecipient(this, tsListener, locale, scListener, uid, bundle);
                    scListener.asBinder().linkToDeath(recipient, 0);
                    this.mListeners.add(recipient);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                this.cleanLocked();
            }
            return recipient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(ISpellCheckerSessionListener listener) {
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                int size = this.mListeners.size();
                ArrayList<InternalDeathRecipient> removeList = new ArrayList<InternalDeathRecipient>();
                for (int i = 0; i < size; ++i) {
                    InternalDeathRecipient tempRecipient = this.mListeners.get(i);
                    if (!tempRecipient.hasSpellCheckerListener(listener)) continue;
                    removeList.add(tempRecipient);
                }
                int removeSize = removeList.size();
                for (int i = 0; i < removeSize; ++i) {
                    InternalDeathRecipient idr = (InternalDeathRecipient)removeList.get(i);
                    idr.mScListener.asBinder().unlinkToDeath(idr, 0);
                    this.mListeners.remove(idr);
                }
                this.cleanLocked();
            }
        }

        private void cleanLocked() {
            if (this.mBound && this.mListeners.isEmpty()) {
                this.mBound = false;
                String sciId = this.mInternalConnection.mSciId;
                SpellCheckerBindGroup cur = (SpellCheckerBindGroup)TextServicesManagerService.this.mSpellCheckerBindGroups.get(sciId);
                if (cur == this) {
                    TextServicesManagerService.this.mSpellCheckerBindGroups.remove(sciId);
                }
                TextServicesManagerService.this.mContext.unbindService(this.mInternalConnection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            Slog.e(this.TAG, "Remove the spell checker bind unexpectedly.");
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                int size = this.mListeners.size();
                for (int i = 0; i < size; ++i) {
                    InternalDeathRecipient idr = this.mListeners.get(i);
                    idr.mScListener.asBinder().unlinkToDeath(idr, 0);
                }
                this.mListeners.clear();
                this.cleanLocked();
            }
        }
    }

    private class TextServicesMonitor
    extends PackageMonitor {
        private TextServicesMonitor() {
        }

        private boolean isChangingPackagesOfCurrentUser() {
            int userId = this.getChangingUserId();
            boolean retval = userId == TextServicesManagerService.this.mSettings.getCurrentUserId();
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSomePackagesChanged() {
            if (!this.isChangingPackagesOfCurrentUser()) {
                return;
            }
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                TextServicesManagerService.buildSpellCheckerMapLocked(TextServicesManagerService.this.mContext, TextServicesManagerService.this.mSpellCheckerList, TextServicesManagerService.this.mSpellCheckerMap, TextServicesManagerService.this.mSettings);
                SpellCheckerInfo sci = TextServicesManagerService.this.getCurrentSpellChecker(null);
                if (sci == null) {
                    return;
                }
                String packageName = sci.getPackageName();
                int change = this.isPackageDisappearing(packageName);
                if ((change == 3 || change == 2 || this.isPackageModified(packageName)) && (sci = TextServicesManagerService.this.findAvailSpellCheckerLocked(null, packageName)) != null) {
                    TextServicesManagerService.this.setCurrentSpellCheckerLocked(sci.getId());
                }
            }
        }
    }
}

