/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Slog;
import android.util.SparseArray;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.AppWidgetServiceImpl;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppWidgetService
extends IAppWidgetService.Stub {
    private static final String TAG = "AppWidgetService";
    Context mContext;
    Locale mLocale;
    PackageManager mPackageManager;
    boolean mSafeMode;
    private final Handler mSaveStateHandler;
    private final SparseArray<AppWidgetServiceImpl> mAppWidgetServices;
    BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.BOOT_COMPLETED".equals(action)) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                if (userId >= 0) {
                    AppWidgetService.this.getImplForUser(userId).sendInitialBroadcasts();
                } else {
                    Slog.w(AppWidgetService.TAG, "Incorrect user handle supplied in " + intent);
                }
            } else if ("android.intent.action.CONFIGURATION_CHANGED".equals(action)) {
                for (int i = 0; i < AppWidgetService.this.mAppWidgetServices.size(); ++i) {
                    AppWidgetServiceImpl service = (AppWidgetServiceImpl)AppWidgetService.this.mAppWidgetServices.valueAt(i);
                    service.onConfigurationChanged();
                }
            } else {
                int sendingUser = this.getSendingUserId();
                if (sendingUser == -1) {
                    for (int i = 0; i < AppWidgetService.this.mAppWidgetServices.size(); ++i) {
                        AppWidgetServiceImpl service = (AppWidgetServiceImpl)AppWidgetService.this.mAppWidgetServices.valueAt(i);
                        service.onBroadcastReceived(intent);
                    }
                } else {
                    AppWidgetServiceImpl service = (AppWidgetServiceImpl)AppWidgetService.this.mAppWidgetServices.get(sendingUser);
                    if (service != null) {
                        service.onBroadcastReceived(intent);
                    }
                }
            }
        }
    };

    AppWidgetService(Context context) {
        this.mContext = context;
        this.mSaveStateHandler = BackgroundThread.getHandler();
        this.mAppWidgetServices = new SparseArray(5);
        AppWidgetServiceImpl primary = new AppWidgetServiceImpl(context, 0, this.mSaveStateHandler);
        this.mAppWidgetServices.append(0, primary);
    }

    public void systemRunning(boolean safeMode) {
        this.mSafeMode = safeMode;
        this.mAppWidgetServices.get(0).systemReady(safeMode);
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, new IntentFilter("android.intent.action.BOOT_COMPLETED"), null, null);
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"), null, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, filter, null, null);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, sdFilter, null, null);
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_REMOVED");
        userFilter.addAction("android.intent.action.USER_STOPPING");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if ("android.intent.action.USER_REMOVED".equals(intent.getAction())) {
                    AppWidgetService.this.onUserRemoved(intent.getIntExtra("android.intent.extra.user_handle", -10000));
                } else if ("android.intent.action.USER_STOPPING".equals(intent.getAction())) {
                    AppWidgetService.this.onUserStopping(intent.getIntExtra("android.intent.extra.user_handle", -10000));
                }
            }
        }, userFilter);
    }

    @Override
    public int allocateAppWidgetId(String packageName, int hostId, int userId) throws RemoteException {
        return this.getImplForUser(userId).allocateAppWidgetId(packageName, hostId);
    }

    @Override
    public int[] getAppWidgetIdsForHost(int hostId, int userId) throws RemoteException {
        return this.getImplForUser(userId).getAppWidgetIdsForHost(hostId);
    }

    @Override
    public void deleteAppWidgetId(int appWidgetId, int userId) throws RemoteException {
        this.getImplForUser(userId).deleteAppWidgetId(appWidgetId);
    }

    @Override
    public void deleteHost(int hostId, int userId) throws RemoteException {
        this.getImplForUser(userId).deleteHost(hostId);
    }

    @Override
    public void deleteAllHosts(int userId) throws RemoteException {
        this.getImplForUser(userId).deleteAllHosts();
    }

    @Override
    public void bindAppWidgetId(int appWidgetId, ComponentName provider, Bundle options, int userId) throws RemoteException {
        this.getImplForUser(userId).bindAppWidgetId(appWidgetId, provider, options);
    }

    @Override
    public boolean bindAppWidgetIdIfAllowed(String packageName, int appWidgetId, ComponentName provider, Bundle options, int userId) throws RemoteException {
        return this.getImplForUser(userId).bindAppWidgetIdIfAllowed(packageName, appWidgetId, provider, options);
    }

    @Override
    public boolean hasBindAppWidgetPermission(String packageName, int userId) throws RemoteException {
        return this.getImplForUser(userId).hasBindAppWidgetPermission(packageName);
    }

    @Override
    public void setBindAppWidgetPermission(String packageName, boolean permission2, int userId) throws RemoteException {
        this.getImplForUser(userId).setBindAppWidgetPermission(packageName, permission2);
    }

    @Override
    public void bindRemoteViewsService(int appWidgetId, Intent intent, IBinder connection, int userId) throws RemoteException {
        this.getImplForUser(userId).bindRemoteViewsService(appWidgetId, intent, connection);
    }

    @Override
    public int[] startListening(IAppWidgetHost host, String packageName, int hostId, List<RemoteViews> updatedViews, int userId) throws RemoteException {
        return this.getImplForUser(userId).startListening(host, packageName, hostId, updatedViews);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userId) {
        if (userId < 1) {
            return;
        }
        SparseArray<AppWidgetServiceImpl> sparseArray = this.mAppWidgetServices;
        synchronized (sparseArray) {
            AppWidgetServiceImpl impl = this.mAppWidgetServices.get(userId);
            this.mAppWidgetServices.remove(userId);
            if (impl == null) {
                AppWidgetServiceImpl.getSettingsFile(userId).delete();
            } else {
                impl.onUserRemoved();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserStopping(int userId) {
        if (userId < 1) {
            return;
        }
        SparseArray<AppWidgetServiceImpl> sparseArray = this.mAppWidgetServices;
        synchronized (sparseArray) {
            AppWidgetServiceImpl impl = this.mAppWidgetServices.get(userId);
            if (impl != null) {
                this.mAppWidgetServices.remove(userId);
                impl.onUserStopping();
            }
        }
    }

    private void checkPermission(int userId) {
        int realUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, this.getClass().getSimpleName(), this.getClass().getPackage().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppWidgetServiceImpl getImplForUser(int userId) {
        AppWidgetServiceImpl service;
        this.checkPermission(userId);
        boolean sendInitial = false;
        SparseArray<AppWidgetServiceImpl> sparseArray = this.mAppWidgetServices;
        synchronized (sparseArray) {
            service = this.mAppWidgetServices.get(userId);
            if (service == null) {
                Slog.i(TAG, "Unable to find AppWidgetServiceImpl for user " + userId + ", adding");
                service = new AppWidgetServiceImpl(this.mContext, userId, this.mSaveStateHandler);
                service.systemReady(this.mSafeMode);
                this.mAppWidgetServices.append(userId, service);
                sendInitial = true;
            }
        }
        if (sendInitial) {
            service.sendInitialBroadcasts();
        }
        return service;
    }

    @Override
    public int[] getAppWidgetIds(ComponentName provider, int userId) throws RemoteException {
        return this.getImplForUser(userId).getAppWidgetIds(provider);
    }

    @Override
    public AppWidgetProviderInfo getAppWidgetInfo(int appWidgetId, int userId) throws RemoteException {
        return this.getImplForUser(userId).getAppWidgetInfo(appWidgetId);
    }

    @Override
    public RemoteViews getAppWidgetViews(int appWidgetId, int userId) throws RemoteException {
        return this.getImplForUser(userId).getAppWidgetViews(appWidgetId);
    }

    @Override
    public void updateAppWidgetOptions(int appWidgetId, Bundle options, int userId) {
        this.getImplForUser(userId).updateAppWidgetOptions(appWidgetId, options);
    }

    @Override
    public Bundle getAppWidgetOptions(int appWidgetId, int userId) {
        return this.getImplForUser(userId).getAppWidgetOptions(appWidgetId);
    }

    @Override
    public List<AppWidgetProviderInfo> getInstalledProviders(int categoryFilter, int userId) throws RemoteException {
        return this.getImplForUser(userId).getInstalledProviders(categoryFilter);
    }

    @Override
    public void notifyAppWidgetViewDataChanged(int[] appWidgetIds, int viewId, int userId) throws RemoteException {
        this.getImplForUser(userId).notifyAppWidgetViewDataChanged(appWidgetIds, viewId);
    }

    @Override
    public void partiallyUpdateAppWidgetIds(int[] appWidgetIds, RemoteViews views, int userId) throws RemoteException {
        this.getImplForUser(userId).partiallyUpdateAppWidgetIds(appWidgetIds, views);
    }

    @Override
    public void stopListening(int hostId, int userId) throws RemoteException {
        this.getImplForUser(userId).stopListening(hostId);
    }

    @Override
    public void unbindRemoteViewsService(int appWidgetId, Intent intent, int userId) throws RemoteException {
        this.getImplForUser(userId).unbindRemoteViewsService(appWidgetId, intent);
    }

    @Override
    public void updateAppWidgetIds(int[] appWidgetIds, RemoteViews views, int userId) throws RemoteException {
        this.getImplForUser(userId).updateAppWidgetIds(appWidgetIds, views);
    }

    @Override
    public void updateAppWidgetProvider(ComponentName provider, RemoteViews views, int userId) throws RemoteException {
        this.getImplForUser(userId).updateAppWidgetProvider(provider, views);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        SparseArray<AppWidgetServiceImpl> sparseArray = this.mAppWidgetServices;
        synchronized (sparseArray) {
            IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
            for (int i = 0; i < this.mAppWidgetServices.size(); ++i) {
                pw.println("User: " + this.mAppWidgetServices.keyAt(i));
                ipw.increaseIndent();
                AppWidgetServiceImpl service = this.mAppWidgetServices.valueAt(i);
                service.dump(fd, ipw, args);
                ipw.decreaseIndent();
            }
        }
    }
}

