/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.net;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class X509Util {
    private static final String TAG = "X509Util";
    private static CertificateFactory sCertificateFactory;
    private static final String OID_TLS_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    private static final String OID_ANY_EKU = "2.5.29.37.0";
    private static final String OID_SERVER_GATED_NETSCAPE = "2.16.840.1.113730.4.1";
    private static final String OID_SERVER_GATED_MICROSOFT = "1.3.6.1.4.1.311.10.3.3";
    private static X509TrustManager sDefaultTrustManager;
    private static X509TrustManager sTestTrustManager;
    private static KeyStore sTestKeyStore;
    private static final Object sLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInitialized() throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Object object = sLock;
        synchronized (object) {
            if (sCertificateFactory == null) {
                sCertificateFactory = CertificateFactory.getInstance("X.509");
            }
            if (sDefaultTrustManager == null) {
                sDefaultTrustManager = X509Util.createTrustManager(null);
            }
            if (sTestKeyStore == null) {
                sTestKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try {
                    sTestKeyStore.load(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (sTestTrustManager == null) {
                sTestTrustManager = X509Util.createTrustManager(sTestKeyStore);
            }
        }
    }

    private static X509TrustManager createTrustManager(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(keyStore);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }

    private static void reloadTestTrustManager() throws KeyStoreException, NoSuchAlgorithmException {
        sTestTrustManager = X509Util.createTrustManager(sTestKeyStore);
    }

    public static X509Certificate createCertificateFromBytes(byte[] derBytes) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.ensureInitialized();
        return (X509Certificate)sCertificateFactory.generateCertificate(new ByteArrayInputStream(derBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTestRootCertificate(byte[] rootCertBytes) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.ensureInitialized();
        X509Certificate rootCert = X509Util.createCertificateFromBytes(rootCertBytes);
        Object object = sLock;
        synchronized (object) {
            sTestKeyStore.setCertificateEntry("root_cert_" + Integer.toString(sTestKeyStore.size()), rootCert);
            X509Util.reloadTestTrustManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTestRootCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        X509Util.ensureInitialized();
        Object object = sLock;
        synchronized (object) {
            try {
                sTestKeyStore.load(null);
                X509Util.reloadTestTrustManager();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static boolean verifyKeyUsage(X509Certificate certificate) throws CertificateException {
        List<String> ekuOids;
        try {
            ekuOids = certificate.getExtendedKeyUsage();
        }
        catch (NullPointerException e) {
            return false;
        }
        if (ekuOids == null) {
            return true;
        }
        for (String ekuOid : ekuOids) {
            if (!ekuOid.equals(OID_TLS_SERVER_AUTH) && !ekuOid.equals(OID_ANY_EKU) && !ekuOid.equals(OID_SERVER_GATED_NETSCAPE) && !ekuOid.equals(OID_SERVER_GATED_MICROSOFT)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int verifyServerCertificates(byte[][] certChain, String authType) throws KeyStoreException, NoSuchAlgorithmException {
        if (certChain == null || certChain.length == 0 || certChain[0] == null) {
            throw new IllegalArgumentException("Expected non-null and non-empty certificate chain passed as |certChain|. |certChain|=" + certChain);
        }
        try {
            X509Util.ensureInitialized();
        }
        catch (CertificateException e) {
            return -1;
        }
        X509Certificate[] serverCertificates = new X509Certificate[certChain.length];
        try {
            for (int i = 0; i < certChain.length; ++i) {
                serverCertificates[i] = X509Util.createCertificateFromBytes(certChain[i]);
            }
        }
        catch (CertificateException e) {
            return -5;
        }
        try {
            serverCertificates[0].checkValidity();
            if (!X509Util.verifyKeyUsage(serverCertificates[0])) {
                return -6;
            }
        }
        catch (CertificateExpiredException e) {
            return -3;
        }
        catch (CertificateNotYetValidException e) {
            return -4;
        }
        catch (CertificateException e) {
            return -1;
        }
        Object object = sLock;
        synchronized (object) {
            try {
                sDefaultTrustManager.checkServerTrusted(serverCertificates, authType);
                return 0;
            }
            catch (CertificateException eDefaultManager) {
                try {
                    sTestTrustManager.checkServerTrusted(serverCertificates, authType);
                    return 0;
                }
                catch (CertificateException eTestManager) {
                    Log.i(TAG, "Failed to validate the certificate chain, error: " + eDefaultManager.getMessage());
                    return -2;
                }
            }
        }
    }

    static {
        sLock = new Object();
    }
}

