/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.base.NativeClassQualifiedName;

@JNINamespace(value="net")
public class ProxyChangeListener {
    private static final String TAG = "ProxyChangeListener";
    private static boolean sEnabled = true;
    private int mNativePtr;
    private Context mContext;
    private ProxyReceiver mProxyReceiver;
    private Delegate mDelegate;

    private ProxyChangeListener(Context context) {
        this.mContext = context;
    }

    public static void setEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    public void setDelegateForTesting(Delegate delegate) {
        this.mDelegate = delegate;
    }

    @CalledByNative
    public static ProxyChangeListener create(Context context) {
        return new ProxyChangeListener(context);
    }

    @CalledByNative
    public static String getProperty(String property) {
        return System.getProperty(property);
    }

    @CalledByNative
    public void start(int nativePtr) {
        assert (this.mNativePtr == 0);
        this.mNativePtr = nativePtr;
        this.registerReceiver();
    }

    @CalledByNative
    public void stop() {
        this.mNativePtr = 0;
        this.unregisterReceiver();
    }

    private void proxySettingsChanged() {
        if (!sEnabled) {
            return;
        }
        if (this.mDelegate != null) {
            this.mDelegate.proxySettingsChanged();
        }
        if (this.mNativePtr == 0) {
            return;
        }
        this.nativeProxySettingsChanged(this.mNativePtr);
    }

    private void registerReceiver() {
        if (this.mProxyReceiver != null) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PROXY_CHANGE");
        this.mProxyReceiver = new ProxyReceiver();
        this.mContext.getApplicationContext().registerReceiver(this.mProxyReceiver, filter);
    }

    private void unregisterReceiver() {
        if (this.mProxyReceiver == null) {
            return;
        }
        this.mContext.unregisterReceiver(this.mProxyReceiver);
        this.mProxyReceiver = null;
    }

    @NativeClassQualifiedName(value="ProxyConfigServiceAndroid::JNIDelegate")
    private native void nativeProxySettingsChanged(int var1);

    private class ProxyReceiver
    extends BroadcastReceiver {
        private ProxyReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.PROXY_CHANGE")) {
                ProxyChangeListener.this.proxySettingsChanged();
            }
        }
    }

    public static interface Delegate {
        public void proxySettingsChanged();
    }
}

