/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.accessibility;

import android.content.Context;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.org.chromium.content.browser.ContentViewCore;
import com.android.org.chromium.content.browser.JavascriptInterface;
import com.android.org.chromium.content.browser.accessibility.AccessibilityInjector;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

class JellyBeanAccessibilityInjector
extends AccessibilityInjector {
    private CallbackHandler mCallback;
    private JSONObject mAccessibilityJSONObject;
    private static final String ALIAS_TRAVERSAL_JS_INTERFACE = "accessibilityTraversal";
    private static final String ACCESSIBILITY_ANDROIDVOX_TEMPLATE = "cvox.AndroidVox.performAction('%1s')";

    protected JellyBeanAccessibilityInjector(ContentViewCore view) {
        super(view);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        info.setMovementGranularities(31);
        info.addAction(256);
        info.addAction(512);
        info.addAction(1024);
        info.addAction(2048);
        info.addAction(16);
        info.setClickable(true);
    }

    public boolean supportsAccessibilityAction(int action) {
        return action == 256 || action == 512 || action == 1024 || action == 2048 || action == 16;
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (!(this.accessibilityIsAvailable() && this.mContentViewCore.isAlive() && this.mInjectedScriptEnabled && this.mScriptInjected)) {
            return false;
        }
        boolean actionSuccessful = this.sendActionToAndroidVox(action, arguments);
        if (actionSuccessful) {
            this.mContentViewCore.showImeIfNeeded();
        }
        return actionSuccessful;
    }

    protected void addAccessibilityApis() {
        super.addAccessibilityApis();
        Context context = this.mContentViewCore.getContext();
        if (context != null && this.mCallback == null) {
            this.mCallback = new CallbackHandler(ALIAS_TRAVERSAL_JS_INTERFACE);
            this.mContentViewCore.addJavascriptInterface(this.mCallback, ALIAS_TRAVERSAL_JS_INTERFACE);
        }
    }

    protected void removeAccessibilityApis() {
        super.removeAccessibilityApis();
        if (this.mCallback != null) {
            this.mContentViewCore.removeJavascriptInterface(ALIAS_TRAVERSAL_JS_INTERFACE);
            this.mCallback = null;
        }
    }

    private boolean sendActionToAndroidVox(int action, Bundle arguments) {
        if (this.mCallback == null) {
            return false;
        }
        if (this.mAccessibilityJSONObject == null) {
            this.mAccessibilityJSONObject = new JSONObject();
        } else {
            Iterator keys = this.mAccessibilityJSONObject.keys();
            while (keys.hasNext()) {
                keys.next();
                keys.remove();
            }
        }
        try {
            this.mAccessibilityJSONObject.accumulate("action", action);
            if (arguments != null) {
                if (action == 256 || action == 512) {
                    int granularity = arguments.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                    this.mAccessibilityJSONObject.accumulate("granularity", granularity);
                } else if (action == 1024 || action == 2048) {
                    String element = arguments.getString("ACTION_ARGUMENT_HTML_ELEMENT_STRING");
                    this.mAccessibilityJSONObject.accumulate("element", element);
                }
            }
        }
        catch (JSONException ex) {
            return false;
        }
        String jsonString = this.mAccessibilityJSONObject.toString();
        String jsCode = String.format(ACCESSIBILITY_ANDROIDVOX_TEMPLATE, jsonString);
        return this.mCallback.performAction(this.mContentViewCore, jsCode);
    }

    private static class CallbackHandler {
        private static final String JAVASCRIPT_ACTION_TEMPLATE = "(function() {  retVal = false;  try {    retVal = %s;  } catch (e) {    retVal = false;  }  %s.onResult(%d, retVal);})()";
        private static final long RESULT_TIMEOUT = 5000L;
        private final AtomicInteger mResultIdCounter = new AtomicInteger();
        private final Object mResultLock = new Object();
        private final String mInterfaceName;
        private boolean mResult = false;
        private long mResultId = -1L;

        private CallbackHandler(String interfaceName) {
            this.mInterfaceName = interfaceName;
        }

        private boolean performAction(ContentViewCore contentView, String code) {
            int resultId = this.mResultIdCounter.getAndIncrement();
            String js = String.format(JAVASCRIPT_ACTION_TEMPLATE, code, this.mInterfaceName, resultId);
            contentView.evaluateJavaScript(js, null);
            return this.getResultAndClear(resultId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean getResultAndClear(int resultId) {
            Object object = this.mResultLock;
            synchronized (object) {
                boolean success = this.waitForResultTimedLocked(resultId);
                boolean result = success ? this.mResult : false;
                this.clearResultLocked();
                return result;
            }
        }

        private void clearResultLocked() {
            this.mResultId = -1L;
            this.mResult = false;
        }

        private boolean waitForResultTimedLocked(int resultId) {
            long waitTimeMillis = 5000L;
            long startTimeMillis = SystemClock.uptimeMillis();
            while (true) {
                try {
                    while (true) {
                        if (this.mResultId == (long)resultId) {
                            return true;
                        }
                        if (this.mResultId > (long)resultId) {
                            return false;
                        }
                        long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                        waitTimeMillis = 5000L - elapsedTimeMillis;
                        if (waitTimeMillis <= 0L) {
                            return false;
                        }
                        this.mResultLock.wait(waitTimeMillis);
                    }
                }
                catch (InterruptedException ie) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JavascriptInterface
        public void onResult(String id2, String result) {
            long resultId;
            try {
                resultId = Long.parseLong(id2);
            }
            catch (NumberFormatException e) {
                return;
            }
            Object object = this.mResultLock;
            synchronized (object) {
                if (resultId > this.mResultId) {
                    this.mResult = Boolean.parseBoolean(result);
                    this.mResultId = resultId;
                }
                this.mResultLock.notifyAll();
            }
        }
    }
}

