/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser;

import android.util.Log;
import android.view.MotionEvent;
import com.android.org.chromium.base.CalledByNative;

class TouchPoint {
    public static final int CONVERSION_ERROR = -1;
    static int TOUCH_EVENT_TYPE_START;
    static int TOUCH_EVENT_TYPE_MOVE;
    static int TOUCH_EVENT_TYPE_END;
    static int TOUCH_EVENT_TYPE_CANCEL;
    private static int TOUCH_POINT_STATE_UNDEFINED;
    private static int TOUCH_POINT_STATE_RELEASED;
    private static int TOUCH_POINT_STATE_PRESSED;
    private static int TOUCH_POINT_STATE_MOVED;
    private static int TOUCH_POINT_STATE_STATIONARY;
    private static int TOUCH_POINT_STATE_CANCELLED;
    private final int mState;
    private final int mId;
    private final float mX;
    private final float mY;
    private final float mSize;
    private final float mPressure;

    TouchPoint(int state, int id2, float x, float y, float size, float pressure) {
        this.mState = state;
        this.mId = id2;
        this.mX = x;
        this.mY = y;
        this.mSize = size;
        this.mPressure = pressure;
    }

    @CalledByNative
    public int getState() {
        return this.mState;
    }

    @CalledByNative
    public int getId() {
        return this.mId;
    }

    @CalledByNative
    public int getX() {
        return (int)this.mX;
    }

    @CalledByNative
    public int getY() {
        return (int)this.mY;
    }

    @CalledByNative
    public double getSize() {
        return this.mSize;
    }

    @CalledByNative
    public double getPressure() {
        return this.mPressure;
    }

    public static int createTouchPoints(MotionEvent event, TouchPoint[] pts) {
        int defaultState;
        int type;
        switch (event.getActionMasked()) {
            case 0: {
                type = TOUCH_EVENT_TYPE_START;
                defaultState = TOUCH_POINT_STATE_PRESSED;
                break;
            }
            case 2: {
                type = TOUCH_EVENT_TYPE_MOVE;
                defaultState = TOUCH_POINT_STATE_MOVED;
                break;
            }
            case 1: {
                type = TOUCH_EVENT_TYPE_END;
                defaultState = TOUCH_POINT_STATE_RELEASED;
                break;
            }
            case 3: {
                type = TOUCH_EVENT_TYPE_CANCEL;
                defaultState = TOUCH_POINT_STATE_CANCELLED;
                break;
            }
            case 5: 
            case 6: {
                type = TOUCH_EVENT_TYPE_MOVE;
                defaultState = TOUCH_POINT_STATE_STATIONARY;
                break;
            }
            default: {
                Log.e("Chromium", "Unknown motion event action: " + event.getActionMasked());
                return -1;
            }
        }
        for (int i = 0; i < pts.length; ++i) {
            int state = defaultState;
            if (defaultState == TOUCH_POINT_STATE_STATIONARY && event.getActionIndex() == i) {
                state = event.getActionMasked() == 5 ? TOUCH_POINT_STATE_PRESSED : TOUCH_POINT_STATE_RELEASED;
            }
            pts[i] = new TouchPoint(state, event.getPointerId(i), event.getX(i), event.getY(i), event.getSize(i), event.getPressure(i));
        }
        return type;
    }

    @CalledByNative
    private static void initializeConstants(int touchTypeStart, int touchTypeMove, int touchTypeEnd, int touchTypeCancel, int touchPointUndefined, int touchPointReleased, int touchPointPressed, int touchPointMoved, int touchPointStationary, int touchPointCancelled) {
        TOUCH_EVENT_TYPE_START = touchTypeStart;
        TOUCH_EVENT_TYPE_MOVE = touchTypeMove;
        TOUCH_EVENT_TYPE_END = touchTypeEnd;
        TOUCH_EVENT_TYPE_CANCEL = touchTypeCancel;
        TOUCH_POINT_STATE_UNDEFINED = touchPointUndefined;
        TOUCH_POINT_STATE_RELEASED = touchPointReleased;
        TOUCH_POINT_STATE_PRESSED = touchPointPressed;
        TOUCH_POINT_STATE_MOVED = touchPointMoved;
        TOUCH_POINT_STATE_STATIONARY = touchPointStationary;
        TOUCH_POINT_STATE_CANCELLED = touchPointCancelled;
    }

    static void initializeConstantsForTesting() {
        if (TOUCH_EVENT_TYPE_START == TOUCH_EVENT_TYPE_MOVE) {
            TouchPoint.initializeConstants(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        }
    }
}

