/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.android.org.chromium.base.CalledByNative;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadUtils {
    private static boolean sWillOverride = false;
    private static Handler sUiThreadHandler = null;

    public static synchronized void setWillOverrideUiThread() {
        sWillOverride = true;
    }

    public static synchronized void setUiThread(Looper looper) {
        if (sUiThreadHandler != null && sUiThreadHandler.getLooper() != looper) {
            throw new RuntimeException("UI thread looper is already set to " + sUiThreadHandler.getLooper() + " (Main thread looper is " + Looper.getMainLooper() + "), cannot set to new looper " + looper);
        }
        sUiThreadHandler = new Handler(looper);
    }

    private static synchronized Handler getUiThreadHandler() {
        if (sUiThreadHandler == null) {
            if (sWillOverride) {
                throw new RuntimeException("Did not yet override the UI thread");
            }
            sUiThreadHandler = new Handler(Looper.getMainLooper());
        }
        return sUiThreadHandler;
    }

    public static void runOnUiThreadBlocking(Runnable r) {
        if (ThreadUtils.runningOnUiThread()) {
            r.run();
        } else {
            FutureTask<Object> task = new FutureTask<Object>(r, null);
            ThreadUtils.postOnUiThread(task);
            try {
                task.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while waiting for runnable", e);
            }
        }
    }

    public static <T> T runOnUiThreadBlockingNoException(Callable<T> c) {
        try {
            return ThreadUtils.runOnUiThreadBlocking(c);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error occured waiting for callable", e);
        }
    }

    public static <T> T runOnUiThreadBlocking(Callable<T> c) throws ExecutionException {
        FutureTask<T> task = new FutureTask<T>(c);
        ThreadUtils.runOnUiThread(task);
        try {
            return task.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for callable", e);
        }
    }

    public static <T> FutureTask<T> runOnUiThread(FutureTask<T> task) {
        if (ThreadUtils.runningOnUiThread()) {
            task.run();
        } else {
            ThreadUtils.postOnUiThread(task);
        }
        return task;
    }

    public static <T> FutureTask<T> runOnUiThread(Callable<T> c) {
        return ThreadUtils.runOnUiThread(new FutureTask<T>(c));
    }

    public static void runOnUiThread(Runnable r) {
        if (ThreadUtils.runningOnUiThread()) {
            r.run();
        } else {
            ThreadUtils.getUiThreadHandler().post(r);
        }
    }

    public static <T> FutureTask<T> postOnUiThread(FutureTask<T> task) {
        ThreadUtils.getUiThreadHandler().post(task);
        return task;
    }

    public static void postOnUiThread(Runnable r) {
        ThreadUtils.getUiThreadHandler().post(r);
    }

    public static void postOnUiThreadDelayed(Runnable r, long delayMillis) {
        ThreadUtils.getUiThreadHandler().postDelayed(r, delayMillis);
    }

    public static void assertOnUiThread() {
        assert (ThreadUtils.runningOnUiThread());
    }

    public static boolean runningOnUiThread() {
        return ThreadUtils.getUiThreadHandler().getLooper() == Looper.myLooper();
    }

    public static Looper getUiThreadLooper() {
        return ThreadUtils.getUiThreadHandler().getLooper();
    }

    @CalledByNative
    public static void setThreadPriorityAudio(int tid) {
        Process.setThreadPriority(tid, -16);
    }
}

