/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.base;

import android.os.Handler;
import android.os.Message;
import com.android.org.chromium.base.CalledByNative;

class SystemMessageHandler
extends Handler {
    private static final int TIMER_MESSAGE = 1;
    private static final int DELAYED_TIMER_MESSAGE = 2;
    private int mMessagePumpDelegateNative = 0;

    private SystemMessageHandler(int messagePumpDelegateNative) {
        this.mMessagePumpDelegateNative = messagePumpDelegateNative;
    }

    public void handleMessage(Message msg) {
        this.nativeDoRunLoopOnce(this.mMessagePumpDelegateNative);
    }

    @CalledByNative
    private void setTimer() {
        this.sendEmptyMessage(1);
    }

    @CalledByNative
    private void setDelayedTimer(long millis) {
        this.removeMessages(2);
        this.sendEmptyMessageDelayed(2, millis);
    }

    @CalledByNative
    private void removeTimer() {
        this.removeMessages(1);
    }

    @CalledByNative
    private static SystemMessageHandler create(int messagePumpDelegateNative) {
        return new SystemMessageHandler(messagePumpDelegateNative);
    }

    private native void nativeDoRunLoopOnce(int var1);
}

