/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.base;

import android.app.Notification;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;

public class ApiCompatibilityUtils {
    private ApiCompatibilityUtils() {
    }

    public static boolean isLayoutRtl(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return view.getLayoutDirection() == 1;
        }
        return false;
    }

    public static void setLayoutDirection(View view, int layoutDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setLayoutDirection(layoutDirection);
        }
    }

    public static void setMarginEnd(ViewGroup.MarginLayoutParams layoutParams, int end) {
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginEnd(end);
        } else {
            layoutParams.rightMargin = end;
        }
    }

    public static void setMarginStart(ViewGroup.MarginLayoutParams layoutParams, int start) {
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginStart(start);
        } else {
            layoutParams.leftMargin = start;
        }
    }

    public static int getMarginStart(ViewGroup.MarginLayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT >= 17) {
            return layoutParams.getMarginStart();
        }
        return layoutParams.leftMargin;
    }

    public static void postInvalidateOnAnimation(View view) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.postInvalidateOnAnimation();
        } else {
            view.postInvalidate();
        }
    }

    public static void setBackgroundForView(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    public static void removeOnGlobalLayoutListener(View view, ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        } else {
            view.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        }
    }

    public static Notification buildNotification(Notification.Builder builder) {
        if (Build.VERSION.SDK_INT >= 16) {
            return builder.build();
        }
        return builder.getNotification();
    }
}

