/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.util.Log;
import com.android.org.chromium.android_webview.AwContentsClient;
import com.android.org.chromium.android_webview.InterceptedRequestData;
import com.android.org.chromium.base.ThreadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Random;

public class DefaultVideoPosterRequestHandler {
    private static final String TAG = "DefaultVideoPosterRequestHandler";
    private String mDefaultVideoPosterURL = DefaultVideoPosterRequestHandler.GenerateDefaulVideoPosterURL();
    private AwContentsClient mContentClient;

    private static InputStream getInputStream(final AwContentsClient contentClient) throws IOException {
        PipedInputStream inputStream = new PipedInputStream();
        final PipedOutputStream outputStream = new PipedOutputStream(inputStream);
        ThreadUtils.runOnUiThread(new Runnable(){

            public void run() {
                final Bitmap defaultVideoPoster = contentClient.getDefaultVideoPoster();
                if (defaultVideoPoster == null) {
                    DefaultVideoPosterRequestHandler.closeOutputStream(outputStream);
                    return;
                }
                AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            defaultVideoPoster.compress(Bitmap.CompressFormat.PNG, 100, outputStream);
                            outputStream.flush();
                        }
                        catch (IOException e) {
                            Log.e(DefaultVideoPosterRequestHandler.TAG, null, e);
                        }
                        finally {
                            DefaultVideoPosterRequestHandler.closeOutputStream(outputStream);
                        }
                    }
                });
            }
        });
        return inputStream;
    }

    private static void closeOutputStream(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            Log.e(TAG, null, e);
        }
    }

    public DefaultVideoPosterRequestHandler(AwContentsClient contentClient) {
        this.mContentClient = contentClient;
    }

    public InterceptedRequestData shouldInterceptRequest(String url) {
        if (!this.mDefaultVideoPosterURL.equals(url)) {
            return null;
        }
        try {
            return new InterceptedRequestData("image/png", null, DefaultVideoPosterRequestHandler.getInputStream(this.mContentClient));
        }
        catch (IOException e) {
            Log.e(TAG, null, e);
            return null;
        }
    }

    public String getDefaultVideoPosterURL() {
        return this.mDefaultVideoPosterURL;
    }

    private static String GenerateDefaulVideoPosterURL() {
        Random randomGenerator = new Random();
        String path = String.valueOf(randomGenerator.nextLong());
        return "android-webview:default_video_poster/" + path;
    }
}

