/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ZoomButtonsController;
import com.android.org.chromium.android_webview.AwContents;
import com.android.org.chromium.content.browser.ContentViewCore;

class AwZoomControls
implements ContentViewCore.ZoomControlsDelegate {
    private AwContents mAwContents;
    private ZoomButtonsController mZoomButtonsController;

    AwZoomControls(AwContents awContents) {
        this.mAwContents = awContents;
    }

    public void invokeZoomPicker() {
        ZoomButtonsController zoomController = this.getZoomController();
        if (zoomController != null) {
            zoomController.setVisible(true);
        }
    }

    public void dismissZoomPicker() {
        ZoomButtonsController zoomController = this.getZoomController();
        if (zoomController != null) {
            zoomController.setVisible(false);
        }
    }

    public void updateZoomControls() {
        ZoomButtonsController zoomController = this.getZoomController();
        if (zoomController == null) {
            return;
        }
        boolean canZoomIn = this.mAwContents.canZoomIn();
        boolean canZoomOut = this.mAwContents.canZoomOut();
        if (!canZoomIn && !canZoomOut) {
            zoomController.getZoomControls().setVisibility(8);
        } else {
            zoomController.setZoomInEnabled(canZoomIn);
            zoomController.setZoomOutEnabled(canZoomOut);
        }
    }

    View getZoomControlsViewForTest() {
        return this.mZoomButtonsController != null ? this.mZoomButtonsController.getZoomControls() : null;
    }

    private ZoomButtonsController getZoomController() {
        if (this.mZoomButtonsController == null && this.mAwContents.getSettings().shouldDisplayZoomControls()) {
            this.mZoomButtonsController = new ZoomButtonsController(this.mAwContents.getContentViewCore().getContainerView());
            this.mZoomButtonsController.setOnZoomListener(new ZoomListener());
            View controls = this.mZoomButtonsController.getZoomControls();
            ViewGroup.LayoutParams params = controls.getLayoutParams();
            if (params instanceof FrameLayout.LayoutParams) {
                ((FrameLayout.LayoutParams)params).gravity = 5;
            }
        }
        return this.mZoomButtonsController;
    }

    private class ZoomListener
    implements ZoomButtonsController.OnZoomListener {
        private ZoomListener() {
        }

        public void onVisibilityChanged(boolean visible) {
            if (visible) {
                AwZoomControls.this.mZoomButtonsController.getZoomControls().setVisibility(0);
                AwZoomControls.this.updateZoomControls();
            }
        }

        public void onZoom(boolean zoomIn) {
            if (zoomIn) {
                AwZoomControls.this.mAwContents.zoomIn();
            } else {
                AwZoomControls.this.mAwContents.zoomOut();
            }
        }
    }
}

