/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.Rect;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.content.common.CleanupReference;
import java.io.OutputStream;

@JNINamespace(value="android_webview")
class AwPicture
extends Picture {
    private int mNativeAwPicture;
    private CleanupReference mCleanupReference;
    private Rect mClipBoundsTemporary = new Rect();

    AwPicture(int nativeAwPicture) {
        this.mNativeAwPicture = nativeAwPicture;
        this.mCleanupReference = new CleanupReference(this, new DestroyRunnable(nativeAwPicture));
    }

    public Canvas beginRecording(int width, int height) {
        this.unsupportedOperation();
        return null;
    }

    public void endRecording() {
    }

    public int getWidth() {
        return this.nativeGetWidth(this.mNativeAwPicture);
    }

    public int getHeight() {
        return this.nativeGetHeight(this.mNativeAwPicture);
    }

    public void draw(Canvas canvas) {
        canvas.getClipBounds(this.mClipBoundsTemporary);
        this.nativeDraw(this.mNativeAwPicture, canvas, this.mClipBoundsTemporary.left, this.mClipBoundsTemporary.top, this.mClipBoundsTemporary.right, this.mClipBoundsTemporary.bottom);
    }

    public void writeToStream(OutputStream stream) {
        this.unsupportedOperation();
    }

    private void unsupportedOperation() {
        throw new IllegalStateException("Unsupported in AwPicture");
    }

    private static native void nativeDestroy(int var0);

    private native int nativeGetWidth(int var1);

    private native int nativeGetHeight(int var1);

    private native void nativeDraw(int var1, Canvas var2, int var3, int var4, int var5, int var6);

    private static final class DestroyRunnable
    implements Runnable {
        private int mNativeAwPicture;

        private DestroyRunnable(int nativeAwPicture) {
            this.mNativeAwPicture = nativeAwPicture;
        }

        public void run() {
            AwPicture.nativeDestroy(this.mNativeAwPicture);
        }
    }
}

