/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tweener {
    private static final String TAG = "Tweener";
    private static final boolean DEBUG = false;
    ObjectAnimator animator;
    private static HashMap<Object, Tweener> sTweens = new HashMap();
    private static Animator.AnimatorListener mCleanupListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            Tweener.remove(animation);
        }

        public void onAnimationCancel(Animator animation) {
            Tweener.remove(animation);
        }
    };

    public Tweener(ObjectAnimator anim2) {
        this.animator = anim2;
    }

    private static void remove(Animator animator2) {
        Iterator<Map.Entry<Object, Tweener>> iter = sTweens.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Tweener> entry = iter.next();
            if (entry.getValue().animator != animator2) continue;
            iter.remove();
            break;
        }
    }

    public static Tweener to(Object object, long duration, Object ... vars) {
        long delay = 0L;
        ValueAnimator.AnimatorUpdateListener updateListener = null;
        Animator.AnimatorListener listener = null;
        TimeInterpolator interpolator2 = null;
        ArrayList<PropertyValuesHolder> props = new ArrayList<PropertyValuesHolder>(vars.length / 2);
        for (int i = 0; i < vars.length; i += 2) {
            if (!(vars[i] instanceof String)) {
                throw new IllegalArgumentException("Key must be a string: " + vars[i]);
            }
            String key = (String)vars[i];
            Object value = vars[i + 1];
            if ("simultaneousTween".equals(key)) continue;
            if ("ease".equals(key)) {
                interpolator2 = (TimeInterpolator)value;
                continue;
            }
            if ("onUpdate".equals(key) || "onUpdateListener".equals(key)) {
                updateListener = (ValueAnimator.AnimatorUpdateListener)value;
                continue;
            }
            if ("onComplete".equals(key) || "onCompleteListener".equals(key)) {
                listener = (Animator.AnimatorListener)value;
                continue;
            }
            if ("delay".equals(key)) {
                delay = ((Number)value).longValue();
                continue;
            }
            if ("syncWith".equals(key)) continue;
            if (value instanceof float[]) {
                props.add(PropertyValuesHolder.ofFloat(key, ((float[])value)[0], ((float[])value)[1]));
                continue;
            }
            if (value instanceof int[]) {
                props.add(PropertyValuesHolder.ofInt(key, ((int[])value)[0], ((int[])value)[1]));
                continue;
            }
            if (value instanceof Number) {
                float floatValue = ((Number)value).floatValue();
                props.add(PropertyValuesHolder.ofFloat(key, floatValue));
                continue;
            }
            throw new IllegalArgumentException("Bad argument for key \"" + key + "\" with value " + value.getClass());
        }
        Tweener tween = sTweens.get(object);
        ObjectAnimator anim2 = null;
        if (tween == null) {
            anim2 = ObjectAnimator.ofPropertyValuesHolder(object, props.toArray(new PropertyValuesHolder[props.size()]));
            tween = new Tweener(anim2);
            sTweens.put(object, tween);
        } else {
            anim2 = Tweener.sTweens.get((Object)object).animator;
            Tweener.replace(props, object);
        }
        if (interpolator2 != null) {
            anim2.setInterpolator(interpolator2);
        }
        anim2.setStartDelay(delay);
        anim2.setDuration(duration);
        if (updateListener != null) {
            anim2.removeAllUpdateListeners();
            anim2.addUpdateListener(updateListener);
        }
        if (listener != null) {
            anim2.removeAllListeners();
            anim2.addListener(listener);
        }
        anim2.addListener(mCleanupListener);
        return tween;
    }

    Tweener from(Object object, long duration, Object ... vars) {
        return Tweener.to(object, duration, vars);
    }

    public static void reset() {
        sTweens.clear();
    }

    private static void replace(ArrayList<PropertyValuesHolder> props, Object ... args) {
        for (Object killobject : args) {
            Tweener tween = sTweens.get(killobject);
            if (tween == null) continue;
            tween.animator.cancel();
            if (props != null) {
                tween.animator.setValues(props.toArray(new PropertyValuesHolder[props.size()]));
                continue;
            }
            sTweens.remove(tween);
        }
    }
}

