/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.Environment;
import android.telephony.Rlog;
import android.util.Xml;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class VoiceMailConstants {
    private HashMap<String, String[]> CarrierVmMap = new HashMap();
    static final String LOG_TAG = "VoiceMailConstants";
    static final String PARTNER_VOICEMAIL_PATH = "etc/voicemail-conf.xml";
    static final int NAME = 0;
    static final int NUMBER = 1;
    static final int TAG = 2;
    static final int SIZE = 3;

    VoiceMailConstants() {
        this.loadVoiceMail();
    }

    boolean containsCarrier(String carrier) {
        return this.CarrierVmMap.containsKey(carrier);
    }

    String getCarrierName(String carrier) {
        String[] data = this.CarrierVmMap.get(carrier);
        return data[0];
    }

    String getVoiceMailNumber(String carrier) {
        String[] data = this.CarrierVmMap.get(carrier);
        return data[1];
    }

    String getVoiceMailTag(String carrier) {
        String[] data = this.CarrierVmMap.get(carrier);
        return data[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadVoiceMail() {
        block17: {
            FileReader vmReader;
            File vmFile = new File(Environment.getRootDirectory(), PARTNER_VOICEMAIL_PATH);
            try {
                vmReader = new FileReader(vmFile);
            }
            catch (FileNotFoundException e) {
                Rlog.w(LOG_TAG, "Can't open " + Environment.getRootDirectory() + "/" + PARTNER_VOICEMAIL_PATH);
                return;
            }
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(vmReader);
            XmlUtils.beginDocument(parser, "voicemail");
            while (true) {
                XmlUtils.nextElement(parser);
                String name = parser.getName();
                if (!"voicemail".equals(name)) break;
                String[] data = new String[3];
                String numeric = parser.getAttributeValue(null, "numeric");
                data[0] = parser.getAttributeValue(null, "carrier");
                data[1] = parser.getAttributeValue(null, "vmnumber");
                data[2] = parser.getAttributeValue(null, "vmtag");
                this.CarrierVmMap.put(numeric, data);
            }
            Object var8_10 = null;
            try {
                if (vmReader != null) {
                    vmReader.close();
                }
                break block17;
            }
            catch (IOException e2) {}
            break block17;
            {
                catch (XmlPullParserException e) {
                    Rlog.w(LOG_TAG, "Exception in Voicemail parser " + e);
                    Object var8_11 = null;
                    try {
                        if (vmReader != null) {
                            vmReader.close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {}
                    break block17;
                }
                catch (IOException e) {
                    Rlog.w(LOG_TAG, "Exception in Voicemail parser " + e);
                    Object var8_12 = null;
                    try {
                        if (vmReader != null) {
                            vmReader.close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                try {
                    if (vmReader != null) {
                        vmReader.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

