/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;

public final class IsimUiccRecords
extends IccRecords
implements IsimRecords {
    protected static final String LOG_TAG = "IsimUiccRecords";
    private static final boolean DBG = true;
    private static final boolean DUMP_RECORDS = false;
    private static final int EVENT_APP_READY = 1;
    private String mIsimImpi;
    private String mIsimDomain;
    private String[] mIsimImpu;
    private static final int TAG_ISIM_VALUE = 128;

    public String toString() {
        return "IsimUiccRecords: " + super.toString() + " mIsimImpi=" + this.mIsimImpi + " mIsimDomain=" + this.mIsimDomain + " mIsimImpu=" + this.mIsimImpu;
    }

    public IsimUiccRecords(UiccCardApplication app, Context c, CommandsInterface ci) {
        super(app, c, ci);
        this.mRecordsRequested = false;
        this.mRecordsToLoad = 0;
        this.mParentApp.registerForReady(this, 1, null);
        this.log("IsimUiccRecords X ctor this=" + this);
    }

    public void dispose() {
        this.log("Disposing " + this);
        this.mParentApp.unregisterForReady(this);
        this.resetRecords();
        super.dispose();
    }

    public void handleMessage(Message msg) {
        if (this.mDestroyed.get()) {
            Rlog.e(LOG_TAG, "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        try {
            switch (msg.what) {
                case 1: {
                    this.onReady();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                    break;
                }
            }
        }
        catch (RuntimeException exc) {
            Rlog.w(LOG_TAG, "Exception parsing SIM record", exc);
        }
    }

    protected void fetchIsimRecords() {
        this.mRecordsRequested = true;
        this.mFh.loadEFTransparent(28418, this.obtainMessage(100, new EfIsimImpiLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixedAll(28420, this.obtainMessage(100, new EfIsimImpuLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28419, this.obtainMessage(100, new EfIsimDomainLoaded()));
        ++this.mRecordsToLoad;
        this.log("fetchIsimRecords " + this.mRecordsToLoad);
    }

    protected void resetRecords() {
        this.mRecordsRequested = false;
    }

    private static String isimTlvToString(byte[] record) {
        SimTlv tlv = new SimTlv(record, 0, record.length);
        do {
            if (tlv.getTag() != 128) continue;
            return new String(tlv.getData(), Charset.forName("UTF-8"));
        } while (tlv.nextObject());
        Rlog.e(LOG_TAG, "[ISIM] can't find TLV tag in ISIM record, returning null");
        return null;
    }

    protected void onRecordLoaded() {
        --this.mRecordsToLoad;
        if (this.mRecordsToLoad == 0 && this.mRecordsRequested) {
            this.onAllRecordsLoaded();
        } else if (this.mRecordsToLoad < 0) {
            this.loge("recordsToLoad <0, programmer error suspected");
            this.mRecordsToLoad = 0;
        }
    }

    protected void onAllRecordsLoaded() {
        this.mRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
    }

    public String getIsimImpi() {
        return this.mIsimImpi;
    }

    public String getIsimDomain() {
        return this.mIsimDomain;
    }

    public String[] getIsimImpu() {
        return this.mIsimImpu != null ? (String[])this.mIsimImpu.clone() : null;
    }

    public int getDisplayRule(String plmn) {
        return 0;
    }

    public void onReady() {
        this.fetchIsimRecords();
    }

    public void onRefresh(boolean fileChanged, int[] fileList) {
    }

    public void setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
    }

    public void setVoiceMessageWaiting(int line, int countWaiting) {
    }

    protected void log(String s) {
        Rlog.d(LOG_TAG, "[ISIM] " + s);
    }

    protected void loge(String s) {
        Rlog.e(LOG_TAG, "[ISIM] " + s);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("IsimRecords: " + this);
        pw.println(" extends:");
        super.dump(fd, pw, args);
        pw.println(" mIsimImpi=" + this.mIsimImpi);
        pw.println(" mIsimDomain=" + this.mIsimDomain);
        pw.println(" mIsimImpu[]=" + Arrays.toString(this.mIsimImpu));
        pw.flush();
    }

    static /* synthetic */ String[] access$502(IsimUiccRecords x0, String[] x1) {
        x0.mIsimImpu = x1;
        return x1;
    }

    private class EfIsimDomainLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimDomainLoaded() {
        }

        public String getEfName() {
            return "EF_ISIM_DOMAIN";
        }

        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            IsimUiccRecords.this.mIsimDomain = IsimUiccRecords.isimTlvToString(data);
        }
    }

    private class EfIsimImpuLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimImpuLoaded() {
        }

        public String getEfName() {
            return "EF_ISIM_IMPU";
        }

        public void onRecordLoaded(AsyncResult ar) {
            ArrayList impuList = (ArrayList)ar.result;
            IsimUiccRecords.this.log("EF_IMPU record count: " + impuList.size());
            IsimUiccRecords.access$502(IsimUiccRecords.this, new String[impuList.size()]);
            int i = 0;
            for (byte[] identity : impuList) {
                String impu = IsimUiccRecords.isimTlvToString(identity);
                ((IsimUiccRecords)IsimUiccRecords.this).mIsimImpu[i++] = impu;
            }
        }
    }

    private class EfIsimImpiLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimImpiLoaded() {
        }

        public String getEfName() {
            return "EF_ISIM_IMPI";
        }

        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            IsimUiccRecords.this.mIsimImpi = IsimUiccRecords.isimTlvToString(data);
        }
    }
}

