/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.AsyncResult;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.test.SimulatedGsmCallState;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.util.ArrayList;

public final class SimulatedCommands
extends BaseCommands
implements CommandsInterface,
SimulatedRadioControl {
    private static final String LOG_TAG = "SimulatedCommands";
    private static final SimLockState INITIAL_LOCK_STATE = SimLockState.NONE;
    private static final String DEFAULT_SIM_PIN_CODE = "1234";
    private static final String SIM_PUK_CODE = "12345678";
    private static final SimFdnState INITIAL_FDN_STATE = SimFdnState.NONE;
    private static final String DEFAULT_SIM_PIN2_CODE = "5678";
    private static final String SIM_PUK2_CODE = "87654321";
    SimulatedGsmCallState simulatedCallState;
    HandlerThread mHandlerThread;
    SimLockState mSimLockedState;
    boolean mSimLockEnabled;
    int mPinUnlockAttempts;
    int mPukUnlockAttempts;
    String mPinCode;
    SimFdnState mSimFdnEnabledState;
    boolean mSimFdnEnabled;
    int mPin2UnlockAttempts;
    int mPuk2UnlockAttempts;
    int mNetworkType;
    String mPin2Code;
    boolean mSsnNotifyOn = false;
    int mPausedResponseCount;
    ArrayList<Message> mPausedResponses = new ArrayList();
    int mNextCallFailCause = 16;

    public SimulatedCommands() {
        super(null);
        this.mHandlerThread = new HandlerThread(LOG_TAG);
        this.mHandlerThread.start();
        Looper looper = this.mHandlerThread.getLooper();
        this.simulatedCallState = new SimulatedGsmCallState(looper);
        this.setRadioState(CommandsInterface.RadioState.RADIO_OFF);
        this.mSimLockedState = INITIAL_LOCK_STATE;
        this.mSimLockEnabled = this.mSimLockedState != SimLockState.NONE;
        this.mPinCode = DEFAULT_SIM_PIN_CODE;
        this.mSimFdnEnabledState = INITIAL_FDN_STATE;
        this.mSimFdnEnabled = this.mSimFdnEnabledState != SimFdnState.NONE;
        this.mPin2Code = DEFAULT_SIM_PIN2_CODE;
    }

    public void getIccCardStatus(Message result) {
        this.unimplemented(result);
    }

    public void supplyIccPin(String pin, Message result) {
        if (this.mSimLockedState != SimLockState.REQUIRE_PIN) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
            return;
        }
        if (pin != null && pin.equals(this.mPinCode)) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin: success!");
            this.mPinUnlockAttempts = 0;
            this.mSimLockedState = SimLockState.NONE;
            this.mIccStatusChangedRegistrants.notifyRegistrants();
            if (result != null) {
                AsyncResult.forMessage(result, null, null);
                result.sendToTarget();
            }
            return;
        }
        if (result != null) {
            ++this.mPinUnlockAttempts;
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin: failed! attempt=" + this.mPinUnlockAttempts);
            if (this.mPinUnlockAttempts >= 3) {
                Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin: set state to REQUIRE_PUK");
                this.mSimLockedState = SimLockState.REQUIRE_PUK;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
        }
    }

    public void supplyIccPuk(String puk, String newPin, Message result) {
        if (this.mSimLockedState != SimLockState.REQUIRE_PUK) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
            return;
        }
        if (puk != null && puk.equals(SIM_PUK_CODE)) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk: success!");
            this.mSimLockedState = SimLockState.NONE;
            this.mPukUnlockAttempts = 0;
            this.mIccStatusChangedRegistrants.notifyRegistrants();
            if (result != null) {
                AsyncResult.forMessage(result, null, null);
                result.sendToTarget();
            }
            return;
        }
        if (result != null) {
            ++this.mPukUnlockAttempts;
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk: failed! attempt=" + this.mPukUnlockAttempts);
            if (this.mPukUnlockAttempts >= 10) {
                Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk: set state to SIM_PERM_LOCKED");
                this.mSimLockedState = SimLockState.SIM_PERM_LOCKED;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
        }
    }

    public void supplyIccPin2(String pin2, Message result) {
        if (this.mSimFdnEnabledState != SimFdnState.REQUIRE_PIN2) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin2: wrong state, state=" + (Object)((Object)this.mSimFdnEnabledState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
            return;
        }
        if (pin2 != null && pin2.equals(this.mPin2Code)) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin2: success!");
            this.mPin2UnlockAttempts = 0;
            this.mSimFdnEnabledState = SimFdnState.NONE;
            if (result != null) {
                AsyncResult.forMessage(result, null, null);
                result.sendToTarget();
            }
            return;
        }
        if (result != null) {
            ++this.mPin2UnlockAttempts;
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin2: failed! attempt=" + this.mPin2UnlockAttempts);
            if (this.mPin2UnlockAttempts >= 3) {
                Rlog.i(LOG_TAG, "[SimCmd] supplyIccPin2: set state to REQUIRE_PUK2");
                this.mSimFdnEnabledState = SimFdnState.REQUIRE_PUK2;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
        }
    }

    public void supplyIccPuk2(String puk2, String newPin2, Message result) {
        if (this.mSimFdnEnabledState != SimFdnState.REQUIRE_PUK2) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk2: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
            return;
        }
        if (puk2 != null && puk2.equals(SIM_PUK2_CODE)) {
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk2: success!");
            this.mSimFdnEnabledState = SimFdnState.NONE;
            this.mPuk2UnlockAttempts = 0;
            if (result != null) {
                AsyncResult.forMessage(result, null, null);
                result.sendToTarget();
            }
            return;
        }
        if (result != null) {
            ++this.mPuk2UnlockAttempts;
            Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk2: failed! attempt=" + this.mPuk2UnlockAttempts);
            if (this.mPuk2UnlockAttempts >= 10) {
                Rlog.i(LOG_TAG, "[SimCmd] supplyIccPuk2: set state to SIM_PERM_LOCKED");
                this.mSimFdnEnabledState = SimFdnState.SIM_PERM_LOCKED;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
        }
    }

    public void changeIccPin(String oldPin, String newPin, Message result) {
        if (oldPin != null && oldPin.equals(this.mPinCode)) {
            this.mPinCode = newPin;
            if (result != null) {
                AsyncResult.forMessage(result, null, null);
                result.sendToTarget();
            }
            return;
        }
        if (result != null) {
            Rlog.i(LOG_TAG, "[SimCmd] changeIccPin: pin failed!");
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
        }
    }

    public void changeIccPin2(String oldPin2, String newPin2, Message result) {
        if (oldPin2 != null && oldPin2.equals(this.mPin2Code)) {
            this.mPin2Code = newPin2;
            if (result != null) {
                AsyncResult.forMessage(result, null, null);
                result.sendToTarget();
            }
            return;
        }
        if (result != null) {
            Rlog.i(LOG_TAG, "[SimCmd] changeIccPin2: pin2 failed!");
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            AsyncResult.forMessage(result, null, ex);
            result.sendToTarget();
        }
    }

    public void changeBarringPassword(String facility, String oldPwd, String newPwd, Message result) {
        this.unimplemented(result);
    }

    public void setSuppServiceNotifications(boolean enable, Message result) {
        this.resultSuccess(result, null);
        if (enable && this.mSsnNotifyOn) {
            Rlog.w(LOG_TAG, "Supp Service Notifications already enabled!");
        }
        this.mSsnNotifyOn = enable;
    }

    public void queryFacilityLock(String facility, String pin, int serviceClass, Message result) {
        this.queryFacilityLockForApp(facility, pin, serviceClass, null, result);
    }

    public void queryFacilityLockForApp(String facility, String pin, int serviceClass, String appId, Message result) {
        if (facility != null && facility.equals("SC")) {
            if (result != null) {
                int[] r = new int[]{this.mSimLockEnabled ? 1 : 0};
                Rlog.i(LOG_TAG, "[SimCmd] queryFacilityLock: SIM is " + (r[0] == 0 ? "unlocked" : "locked"));
                AsyncResult.forMessage(result, r, null);
                result.sendToTarget();
            }
            return;
        }
        if (facility != null && facility.equals("FD")) {
            if (result != null) {
                int[] r = new int[]{this.mSimFdnEnabled ? 1 : 0};
                Rlog.i(LOG_TAG, "[SimCmd] queryFacilityLock: FDN is " + (r[0] == 0 ? "disabled" : "enabled"));
                AsyncResult.forMessage(result, r, null);
                result.sendToTarget();
            }
            return;
        }
        this.unimplemented(result);
    }

    public void setFacilityLock(String facility, boolean lockEnabled, String pin, int serviceClass, Message result) {
        this.setFacilityLockForApp(facility, lockEnabled, pin, serviceClass, null, result);
    }

    public void setFacilityLockForApp(String facility, boolean lockEnabled, String pin, int serviceClass, String appId, Message result) {
        if (facility != null && facility.equals("SC")) {
            if (pin != null && pin.equals(this.mPinCode)) {
                Rlog.i(LOG_TAG, "[SimCmd] setFacilityLock: pin is valid");
                this.mSimLockEnabled = lockEnabled;
                if (result != null) {
                    AsyncResult.forMessage(result, null, null);
                    result.sendToTarget();
                }
                return;
            }
            if (result != null) {
                Rlog.i(LOG_TAG, "[SimCmd] setFacilityLock: pin failed!");
                CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                AsyncResult.forMessage(result, null, ex);
                result.sendToTarget();
            }
            return;
        }
        if (facility != null && facility.equals("FD")) {
            if (pin != null && pin.equals(this.mPin2Code)) {
                Rlog.i(LOG_TAG, "[SimCmd] setFacilityLock: pin2 is valid");
                this.mSimFdnEnabled = lockEnabled;
                if (result != null) {
                    AsyncResult.forMessage(result, null, null);
                    result.sendToTarget();
                }
                return;
            }
            if (result != null) {
                Rlog.i(LOG_TAG, "[SimCmd] setFacilityLock: pin2 failed!");
                CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                AsyncResult.forMessage(result, null, ex);
                result.sendToTarget();
            }
            return;
        }
        this.unimplemented(result);
    }

    public void supplyNetworkDepersonalization(String netpin, Message result) {
        this.unimplemented(result);
    }

    public void getCurrentCalls(Message result) {
        if (this.mState == CommandsInterface.RadioState.RADIO_ON && !this.isSimLocked()) {
            this.resultSuccess(result, this.simulatedCallState.getDriverCalls());
        } else {
            this.resultFail(result, new CommandException(CommandException.Error.RADIO_NOT_AVAILABLE));
        }
    }

    @Deprecated
    public void getPDPContextList(Message result) {
        this.getDataCallList(result);
    }

    public void getDataCallList(Message result) {
        this.resultSuccess(result, new ArrayList(0));
    }

    public void dial(String address, int clirMode, Message result) {
        this.simulatedCallState.onDial(address);
        this.resultSuccess(result, null);
    }

    public void dial(String address, int clirMode, UUSInfo uusInfo, Message result) {
        this.simulatedCallState.onDial(address);
        this.resultSuccess(result, null);
    }

    public void getIMSI(Message result) {
        this.getIMSIForApp(null, result);
    }

    public void getIMSIForApp(String aid, Message result) {
        this.resultSuccess(result, "012345678901234");
    }

    public void getIMEI(Message result) {
        this.resultSuccess(result, "012345678901234");
    }

    public void getIMEISV(Message result) {
        this.resultSuccess(result, "99");
    }

    public void hangupConnection(int gsmIndex, Message result) {
        boolean success = this.simulatedCallState.onChld('1', (char)(48 + gsmIndex));
        if (!success) {
            Rlog.i("GSM", "[SimCmd] hangupConnection: resultFail");
            this.resultFail(result, new RuntimeException("Hangup Error"));
        } else {
            Rlog.i("GSM", "[SimCmd] hangupConnection: resultSuccess");
            this.resultSuccess(result, null);
        }
    }

    public void hangupWaitingOrBackground(Message result) {
        boolean success = this.simulatedCallState.onChld('0', '\u0000');
        if (!success) {
            this.resultFail(result, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    public void hangupForegroundResumeBackground(Message result) {
        boolean success = this.simulatedCallState.onChld('1', '\u0000');
        if (!success) {
            this.resultFail(result, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    public void switchWaitingOrHoldingAndActive(Message result) {
        boolean success = this.simulatedCallState.onChld('2', '\u0000');
        if (!success) {
            this.resultFail(result, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    public void conference(Message result) {
        boolean success = this.simulatedCallState.onChld('3', '\u0000');
        if (!success) {
            this.resultFail(result, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    public void explicitCallTransfer(Message result) {
        boolean success = this.simulatedCallState.onChld('4', '\u0000');
        if (!success) {
            this.resultFail(result, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    public void separateConnection(int gsmIndex, Message result) {
        char ch = (char)(gsmIndex + 48);
        boolean success = this.simulatedCallState.onChld('2', ch);
        if (!success) {
            this.resultFail(result, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    public void acceptCall(Message result) {
        boolean success = this.simulatedCallState.onAnswer();
        if (!success) {
            this.resultFail(result, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    public void rejectCall(Message result) {
        boolean success = this.simulatedCallState.onChld('0', '\u0000');
        if (!success) {
            this.resultFail(result, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    public void getLastCallFailCause(Message result) {
        int[] ret = new int[]{this.mNextCallFailCause};
        this.resultSuccess(result, ret);
    }

    @Deprecated
    public void getLastPdpFailCause(Message result) {
        this.unimplemented(result);
    }

    public void getLastDataCallFailCause(Message result) {
        this.unimplemented(result);
    }

    public void setMute(boolean enableMute, Message result) {
        this.unimplemented(result);
    }

    public void getMute(Message result) {
        this.unimplemented(result);
    }

    public void getSignalStrength(Message result) {
        int[] ret = new int[]{23, 0};
        this.resultSuccess(result, ret);
    }

    public void setBandMode(int bandMode, Message result) {
        this.resultSuccess(result, null);
    }

    public void queryAvailableBandMode(Message result) {
        int[] ret = new int[]{4, 2, 3, 4};
        this.resultSuccess(result, ret);
    }

    public void sendTerminalResponse(String contents, Message response) {
        this.resultSuccess(response, null);
    }

    public void sendEnvelope(String contents, Message response) {
        this.resultSuccess(response, null);
    }

    public void sendEnvelopeWithStatus(String contents, Message response) {
        this.resultSuccess(response, null);
    }

    public void handleCallSetupRequestFromSim(boolean accept, Message response) {
        this.resultSuccess(response, null);
    }

    public void getVoiceRegistrationState(Message result) {
        String[] ret = new String[]{"5", null, null, null, null, null, null, null, null, null, null, null, null, null};
        this.resultSuccess(result, ret);
    }

    public void getDataRegistrationState(Message result) {
        String[] ret = new String[]{"5", null, null, "2"};
        this.resultSuccess(result, ret);
    }

    public void getOperator(Message result) {
        String[] ret = new String[]{"El Telco Loco", "Telco Loco", "001001"};
        this.resultSuccess(result, ret);
    }

    public void sendDtmf(char c, Message result) {
        this.resultSuccess(result, null);
    }

    public void startDtmf(char c, Message result) {
        this.resultSuccess(result, null);
    }

    public void stopDtmf(Message result) {
        this.resultSuccess(result, null);
    }

    public void sendBurstDtmf(String dtmfString, int on, int off, Message result) {
        this.resultSuccess(result, null);
    }

    public void sendSMS(String smscPDU, String pdu, Message result) {
        this.unimplemented(result);
    }

    public void deleteSmsOnSim(int index, Message response) {
        Rlog.d(LOG_TAG, "Delete message at index " + index);
        this.unimplemented(response);
    }

    public void deleteSmsOnRuim(int index, Message response) {
        Rlog.d(LOG_TAG, "Delete RUIM message at index " + index);
        this.unimplemented(response);
    }

    public void writeSmsToSim(int status, String smsc, String pdu, Message response) {
        Rlog.d(LOG_TAG, "Write SMS to SIM with status " + status);
        this.unimplemented(response);
    }

    public void writeSmsToRuim(int status, String pdu, Message response) {
        Rlog.d(LOG_TAG, "Write SMS to RUIM with status " + status);
        this.unimplemented(response);
    }

    public void setupDataCall(String radioTechnology, String profile, String apn, String user, String password, String authType, String protocol, Message result) {
        this.unimplemented(result);
    }

    public void deactivateDataCall(int cid, int reason, Message result) {
        this.unimplemented(result);
    }

    public void setPreferredNetworkType(int networkType, Message result) {
        this.mNetworkType = networkType;
        this.resultSuccess(result, null);
    }

    public void getPreferredNetworkType(Message result) {
        int[] ret = new int[]{this.mNetworkType};
        this.resultSuccess(result, ret);
    }

    public void getNeighboringCids(Message result) {
        int[] ret = new int[7];
        ret[0] = 6;
        for (int i = 1; i < 7; ++i) {
            ret[i] = i;
        }
        this.resultSuccess(result, ret);
    }

    public void setLocationUpdates(boolean enable, Message response) {
        this.unimplemented(response);
    }

    public void getSmscAddress(Message result) {
        this.unimplemented(result);
    }

    public void setSmscAddress(String address, Message result) {
        this.unimplemented(result);
    }

    public void reportSmsMemoryStatus(boolean available, Message result) {
        this.unimplemented(result);
    }

    public void reportStkServiceIsRunning(Message result) {
        this.resultSuccess(result, null);
    }

    public void getCdmaSubscriptionSource(Message result) {
        this.unimplemented(result);
    }

    private boolean isSimLocked() {
        return this.mSimLockedState != SimLockState.NONE;
    }

    public void setRadioPower(boolean on, Message result) {
        if (on) {
            this.setRadioState(CommandsInterface.RadioState.RADIO_ON);
        } else {
            this.setRadioState(CommandsInterface.RadioState.RADIO_OFF);
        }
    }

    public void acknowledgeLastIncomingGsmSms(boolean success, int cause, Message result) {
        this.unimplemented(result);
    }

    public void acknowledgeLastIncomingCdmaSms(boolean success, int cause, Message result) {
        this.unimplemented(result);
    }

    public void acknowledgeIncomingGsmSmsWithPdu(boolean success, String ackPdu, Message result) {
        this.unimplemented(result);
    }

    public void iccIO(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, Message response) {
        this.iccIOForApp(command, fileid, path, p1, p2, p3, data, pin2, null, response);
    }

    public void iccIOForApp(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, String aid, Message result) {
        this.unimplemented(result);
    }

    public void queryCLIP(Message response) {
        this.unimplemented(response);
    }

    public void getCLIR(Message result) {
        this.unimplemented(result);
    }

    public void setCLIR(int clirMode, Message result) {
        this.unimplemented(result);
    }

    public void queryCallWaiting(int serviceClass, Message response) {
        this.unimplemented(response);
    }

    public void setCallWaiting(boolean enable, int serviceClass, Message response) {
        this.unimplemented(response);
    }

    public void setCallForward(int action, int cfReason, int serviceClass, String number, int timeSeconds, Message result) {
        this.unimplemented(result);
    }

    public void queryCallForwardStatus(int cfReason, int serviceClass, String number, Message result) {
        this.unimplemented(result);
    }

    public void setNetworkSelectionModeAutomatic(Message result) {
        this.unimplemented(result);
    }

    public void exitEmergencyCallbackMode(Message result) {
        this.unimplemented(result);
    }

    public void setNetworkSelectionModeManual(String operatorNumeric, Message result) {
        this.unimplemented(result);
    }

    public void getNetworkSelectionMode(Message result) {
        int[] ret = new int[]{0};
        this.resultSuccess(result, ret);
    }

    public void getAvailableNetworks(Message result) {
        this.unimplemented(result);
    }

    public void getBasebandVersion(Message result) {
        this.resultSuccess(result, LOG_TAG);
    }

    public void triggerIncomingUssd(String statusCode, String message) {
        if (this.mUSSDRegistrant != null) {
            String[] result = new String[]{statusCode, message};
            this.mUSSDRegistrant.notifyResult(result);
        }
    }

    public void sendUSSD(String ussdString, Message result) {
        if (ussdString.equals("#646#")) {
            this.resultSuccess(result, null);
            this.triggerIncomingUssd("0", "You have NNN minutes remaining.");
        } else {
            this.resultSuccess(result, null);
            this.triggerIncomingUssd("0", "All Done");
        }
    }

    public void cancelPendingUssd(Message response) {
        this.resultSuccess(response, null);
    }

    public void resetRadio(Message result) {
        this.unimplemented(result);
    }

    public void invokeOemRilRequestRaw(byte[] data, Message response) {
        if (response != null) {
            AsyncResult.forMessage((Message)response).result = data;
            response.sendToTarget();
        }
    }

    public void invokeOemRilRequestStrings(String[] strings, Message response) {
        if (response != null) {
            AsyncResult.forMessage((Message)response).result = strings;
            response.sendToTarget();
        }
    }

    public void triggerRing(String number) {
        this.simulatedCallState.triggerRing(number);
        this.mCallStateRegistrants.notifyRegistrants();
    }

    public void progressConnectingCallState() {
        this.simulatedCallState.progressConnectingCallState();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    public void progressConnectingToActive() {
        this.simulatedCallState.progressConnectingToActive();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    public void setAutoProgressConnectingCall(boolean b) {
        this.simulatedCallState.setAutoProgressConnectingCall(b);
    }

    public void setNextDialFailImmediately(boolean b) {
        this.simulatedCallState.setNextDialFailImmediately(b);
    }

    public void setNextCallFailCause(int gsmCause) {
        this.mNextCallFailCause = gsmCause;
    }

    public void triggerHangupForeground() {
        this.simulatedCallState.triggerHangupForeground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    public void triggerHangupBackground() {
        this.simulatedCallState.triggerHangupBackground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    public void triggerSsn(int type, int code) {
        SuppServiceNotification not = new SuppServiceNotification();
        not.notificationType = type;
        not.code = code;
        this.mSsnRegistrant.notifyRegistrant(new AsyncResult(null, not, null));
    }

    public void shutdown() {
        this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
        Looper looper = this.mHandlerThread.getLooper();
        if (looper != null) {
            looper.quit();
        }
    }

    public void triggerHangupAll() {
        this.simulatedCallState.triggerHangupAll();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    public void triggerIncomingSMS(String message) {
    }

    public void pauseResponses() {
        ++this.mPausedResponseCount;
    }

    public void resumeResponses() {
        --this.mPausedResponseCount;
        if (this.mPausedResponseCount == 0) {
            int s = this.mPausedResponses.size();
            for (int i = 0; i < s; ++i) {
                this.mPausedResponses.get(i).sendToTarget();
            }
            this.mPausedResponses.clear();
        } else {
            Rlog.e("GSM", "SimulatedCommands.resumeResponses < 0");
        }
    }

    private void unimplemented(Message result) {
        if (result != null) {
            AsyncResult.forMessage((Message)result).exception = new RuntimeException("Unimplemented");
            if (this.mPausedResponseCount > 0) {
                this.mPausedResponses.add(result);
            } else {
                result.sendToTarget();
            }
        }
    }

    private void resultSuccess(Message result, Object ret) {
        if (result != null) {
            AsyncResult.forMessage((Message)result).result = ret;
            if (this.mPausedResponseCount > 0) {
                this.mPausedResponses.add(result);
            } else {
                result.sendToTarget();
            }
        }
    }

    private void resultFail(Message result, Throwable tr) {
        if (result != null) {
            AsyncResult.forMessage((Message)result).exception = tr;
            if (this.mPausedResponseCount > 0) {
                this.mPausedResponses.add(result);
            } else {
                result.sendToTarget();
            }
        }
    }

    public void getDeviceIdentity(Message response) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    public void getCDMASubscription(Message response) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    public void setCdmaSubscriptionSource(int cdmaSubscriptionType, Message response) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    public void queryCdmaRoamingPreference(Message response) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    public void setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    public void setPhoneType(int phoneType) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
    }

    public void getPreferredVoicePrivacy(Message result) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(result);
    }

    public void setPreferredVoicePrivacy(boolean enable, Message result) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(result);
    }

    public void setTTYMode(int ttyMode, Message response) {
        Rlog.w(LOG_TAG, "Not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    public void queryTTYMode(Message response) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    public void sendCDMAFeatureCode(String FeatureCode, Message response) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    public void sendCdmaSms(byte[] pdu, Message response) {
        Rlog.w(LOG_TAG, "CDMA not implemented in SimulatedCommands");
    }

    public void setCdmaBroadcastActivation(boolean activate, Message response) {
        this.unimplemented(response);
    }

    public void getCdmaBroadcastConfig(Message response) {
        this.unimplemented(response);
    }

    public void setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs, Message response) {
        this.unimplemented(response);
    }

    public void forceDataDormancy(Message response) {
        this.unimplemented(response);
    }

    public void setGsmBroadcastActivation(boolean activate, Message response) {
        this.unimplemented(response);
    }

    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] config, Message response) {
        this.unimplemented(response);
    }

    public void getGsmBroadcastConfig(Message response) {
        this.unimplemented(response);
    }

    public void supplyIccPinForApp(String pin, String aid, Message response) {
        this.unimplemented(response);
    }

    public void supplyIccPukForApp(String puk, String newPin, String aid, Message response) {
        this.unimplemented(response);
    }

    public void supplyIccPin2ForApp(String pin2, String aid, Message response) {
        this.unimplemented(response);
    }

    public void supplyIccPuk2ForApp(String puk2, String newPin2, String aid, Message response) {
        this.unimplemented(response);
    }

    public void changeIccPinForApp(String oldPin, String newPin, String aidPtr, Message response) {
        this.unimplemented(response);
    }

    public void changeIccPin2ForApp(String oldPin2, String newPin2, String aidPtr, Message response) {
        this.unimplemented(response);
    }

    public void requestIsimAuthentication(String nonce, Message response) {
        this.unimplemented(response);
    }

    public void getVoiceRadioTechnology(Message response) {
        this.unimplemented(response);
    }

    public void getCellInfoList(Message response) {
        this.unimplemented(response);
    }

    public void setCellInfoListRate(int rateInMillis, Message response) {
        this.unimplemented(response);
    }

    public void setInitialAttachApn(String apn, String protocol, int authType, String username, String password, Message result) {
    }

    public void getImsRegistrationState(Message response) {
        this.unimplemented(response);
    }

    public void sendImsCdmaSms(byte[] pdu, int retry, int messageRef, Message response) {
        this.unimplemented(response);
    }

    public void sendImsGsmSms(String smscPDU, String pdu, int retry, int messageRef, Message response) {
        this.unimplemented(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SimFdnState {
        NONE,
        REQUIRE_PIN2,
        REQUIRE_PUK2,
        SIM_PERM_LOCKED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SimLockState {
        NONE,
        REQUIRE_PIN,
        REQUIRE_PUK,
        SIM_PERM_LOCKED;

    }
}

