/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.StatusBarManager;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.view.WindowManagerPolicy;
import com.android.internal.statusbar.IStatusBarService;
import java.io.PrintWriter;

public class BarController {
    private static final boolean DEBUG = false;
    private static final int TRANSIENT_BAR_NONE = 0;
    private static final int TRANSIENT_BAR_SHOWING = 1;
    private static final int TRANSIENT_BAR_HIDING = 2;
    private static final int TRANSLUCENT_ANIMATION_DELAY_MS = 1000;
    private final String mTag;
    private final int mTransientFlag;
    private final int mUnhideFlag;
    private final int mTranslucentFlag;
    private final int mStatusBarManagerId;
    private final int mTranslucentWmFlag;
    private final Handler mHandler;
    private final Object mServiceAquireLock = new Object();
    private IStatusBarService mStatusBarService;
    private WindowManagerPolicy.WindowState mWin;
    private int mState = 0;
    private int mTransientBarState;
    private boolean mPendingShow;
    private long mLastTranslucent;

    public BarController(String tag, int transientFlag, int unhideFlag, int translucentFlag, int statusBarManagerId, int translucentWmFlag) {
        this.mTag = "BarController." + tag;
        this.mTransientFlag = transientFlag;
        this.mUnhideFlag = unhideFlag;
        this.mTranslucentFlag = translucentFlag;
        this.mStatusBarManagerId = statusBarManagerId;
        this.mTranslucentWmFlag = translucentWmFlag;
        this.mHandler = new Handler();
    }

    public void setWindow(WindowManagerPolicy.WindowState win) {
        this.mWin = win;
    }

    public boolean isHidden() {
        return this.mState == 2;
    }

    public void showTransient() {
        if (this.mWin != null) {
            this.setTransientBarState(1);
        }
    }

    public boolean isTransientShowing() {
        return this.mTransientBarState == 1;
    }

    public boolean wasRecentlyTranslucent() {
        return SystemClock.uptimeMillis() - this.mLastTranslucent < 1000L;
    }

    public void adjustSystemUiVisibilityLw(int oldVis, int vis) {
        if (this.mWin != null && this.mTransientBarState == 1 && (vis & this.mTransientFlag) == 0) {
            this.setTransientBarState(2);
            this.setBarShowingLw(false);
        } else if (this.mWin != null && (oldVis & this.mUnhideFlag) != 0 && (vis & this.mUnhideFlag) == 0) {
            this.setBarShowingLw(true);
        }
    }

    public int applyTranslucentFlagLw(WindowManagerPolicy.WindowState win, int vis, int oldVis) {
        if (this.mWin != null) {
            vis = win != null && (win.getAttrs().privateFlags & 0x200) == 0 ? ((win.getAttrs().flags & this.mTranslucentWmFlag) != 0 ? (vis |= this.mTranslucentFlag) : (vis &= ~this.mTranslucentFlag)) : vis & ~this.mTranslucentFlag | oldVis & this.mTranslucentFlag;
        }
        return vis;
    }

    public boolean setBarShowingLw(boolean show) {
        if (this.mWin == null) {
            return false;
        }
        if (show && this.mTransientBarState == 2) {
            this.mPendingShow = true;
            return false;
        }
        boolean wasVis = this.mWin.isVisibleLw();
        boolean wasAnim = this.mWin.isAnimatingLw();
        boolean change = show ? this.mWin.showLw(true) : this.mWin.hideLw(true);
        int state = this.computeStateLw(wasVis, wasAnim, this.mWin, change);
        this.updateStateLw(state);
        return change;
    }

    private int computeStateLw(boolean wasVis, boolean wasAnim, WindowManagerPolicy.WindowState win, boolean change) {
        if (win.hasDrawnLw()) {
            boolean vis = win.isVisibleLw();
            boolean anim2 = win.isAnimatingLw();
            if (this.mState == 1 && !change && !vis) {
                return 2;
            }
            if (change) {
                if (wasVis && vis && !wasAnim && anim2) {
                    return 1;
                }
                return 0;
            }
        }
        return this.mState;
    }

    private void updateStateLw(final int state) {
        if (state != this.mState) {
            this.mState = state;
            this.mHandler.post(new Runnable(){

                public void run() {
                    try {
                        IStatusBarService statusbar = BarController.this.getStatusBarService();
                        if (statusbar != null) {
                            statusbar.setWindowState(BarController.this.mStatusBarManagerId, state);
                        }
                    }
                    catch (RemoteException e) {
                        BarController.this.mStatusBarService = null;
                    }
                }
            });
        }
    }

    public boolean checkHiddenLw() {
        if (this.mWin != null && this.mWin.hasDrawnLw()) {
            if (!this.mWin.isVisibleLw() && !this.mWin.isAnimatingLw()) {
                this.updateStateLw(2);
            }
            if (this.mTransientBarState == 2 && !this.mWin.isVisibleLw()) {
                this.setTransientBarState(0);
                if (this.mPendingShow) {
                    this.setBarShowingLw(true);
                    this.mPendingShow = false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean checkShowTransientBarLw() {
        if (this.mTransientBarState == 1) {
            return false;
        }
        if (this.mWin == null) {
            return false;
        }
        return !this.mWin.isDisplayedLw();
    }

    public int updateVisibilityLw(boolean transientAllowed, int oldVis, int vis) {
        if (this.mWin == null) {
            return vis;
        }
        if (this.mTransientBarState == 1) {
            if (transientAllowed) {
                vis |= this.mTransientFlag;
                if ((oldVis & this.mTransientFlag) == 0) {
                    vis |= this.mUnhideFlag;
                }
            } else {
                this.setTransientBarState(0);
            }
        }
        if (this.mTransientBarState != 0) {
            vis |= this.mTransientFlag;
            vis &= 0xFFFFFFFE;
        }
        if ((vis & this.mTranslucentFlag) != 0 || (oldVis & this.mTranslucentFlag) != 0) {
            this.mLastTranslucent = SystemClock.uptimeMillis();
        }
        return vis;
    }

    private void setTransientBarState(int state) {
        if (this.mWin != null && state != this.mTransientBarState) {
            if (this.mTransientBarState == 1 || state == 1) {
                this.mLastTranslucent = SystemClock.uptimeMillis();
            }
            this.mTransientBarState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatusBarService getStatusBarService() {
        Object object = this.mServiceAquireLock;
        synchronized (object) {
            if (this.mStatusBarService == null) {
                this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
            }
            return this.mStatusBarService;
        }
    }

    private static String transientBarStateToString(int state) {
        if (state == 2) {
            return "TRANSIENT_BAR_HIDING";
        }
        if (state == 1) {
            return "TRANSIENT_BAR_SHOWING";
        }
        if (state == 0) {
            return "TRANSIENT_BAR_NONE";
        }
        throw new IllegalArgumentException("Unknown state " + state);
    }

    public void dump(PrintWriter pw, String prefix) {
        if (this.mWin != null) {
            pw.print(prefix);
            pw.println(this.mTag);
            pw.print(prefix);
            pw.print("  ");
            pw.print("mState");
            pw.print('=');
            pw.println(StatusBarManager.windowStateToString(this.mState));
            pw.print(prefix);
            pw.print("  ");
            pw.print("mTransientBar");
            pw.print('=');
            pw.println(BarController.transientBarStateToString(this.mTransientBarState));
        }
    }
}

