/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.IntProperty;
import android.util.MathUtils;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListView;
import android.widget.HeaderViewListAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.SectionIndexer;
import android.widget.TextView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FastScroller {
    private static final int DURATION_FADE_OUT = 300;
    private static final int DURATION_FADE_IN = 150;
    private static final int DURATION_CROSS_FADE = 50;
    private static final int DURATION_RESIZE = 100;
    private static final long FADE_TIMEOUT = 1500L;
    private static final int MIN_PAGES = 4;
    private static final int STATE_NONE = 0;
    private static final int STATE_VISIBLE = 1;
    private static final int STATE_DRAGGING = 2;
    private static final int[] ATTRS = new int[]{16843609, 16843574, 16843577, 16843575, 16843576, 16843578};
    private static final int TEXT_COLOR = 0;
    private static final int THUMB_DRAWABLE = 1;
    private static final int TRACK_DRAWABLE = 2;
    private static final int PREVIEW_BACKGROUND_LEFT = 3;
    private static final int PREVIEW_BACKGROUND_RIGHT = 4;
    private static final int OVERLAY_POSITION = 5;
    private static final int OVERLAY_FLOATING = 0;
    private static final int OVERLAY_AT_THUMB = 1;
    private static final int PREVIEW_LEFT = 0;
    private static final int PREVIEW_RIGHT = 1;
    private static final long TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
    private final Rect mTempBounds = new Rect();
    private final Rect mTempMargins = new Rect();
    private final Rect mContainerRect = new Rect();
    private final AbsListView mList;
    private final ViewGroupOverlay mOverlay;
    private final TextView mPrimaryText;
    private final TextView mSecondaryText;
    private final ImageView mThumbImage;
    private final ImageView mTrackImage;
    private final ImageView mPreviewImage;
    private final int[] mPreviewResId = new int[2];
    private final int mPreviewPadding;
    private final boolean mHasTrackImage;
    private final int mWidth;
    private AnimatorSet mDecorAnimation;
    private AnimatorSet mPreviewAnimation;
    private boolean mShowingPrimary;
    private boolean mScrollCompleted;
    private int mFirstVisibleItem;
    private int mHeaderCount;
    private int mCurrentSection = -1;
    private int mScrollbarPosition = -1;
    private boolean mLongList;
    private Object[] mSections;
    private boolean mUpdatingLayout;
    private int mState;
    private BaseAdapter mListAdapter;
    private SectionIndexer mSectionIndexer;
    private boolean mLayoutFromRight;
    private boolean mEnabled;
    private boolean mAlwaysShow;
    private int mOverlayPosition;
    private int mScrollBarStyle;
    private boolean mMatchDragPosition;
    private float mInitialTouchY;
    private boolean mHasPendingDrag;
    private int mScaledTouchSlop;
    private final Runnable mDeferStartDrag = new Runnable(){

        public void run() {
            if (FastScroller.this.mList.isAttachedToWindow()) {
                FastScroller.this.beginDrag();
                float pos = FastScroller.this.getPosFromMotionEvent(FastScroller.this.mInitialTouchY);
                FastScroller.this.scrollTo(pos);
            }
            FastScroller.this.mHasPendingDrag = false;
        }
    };
    private final Runnable mDeferHide = new Runnable(){

        public void run() {
            FastScroller.this.setState(0);
        }
    };
    private final Animator.AnimatorListener mSwitchPrimaryListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            FastScroller.this.mShowingPrimary = !FastScroller.this.mShowingPrimary;
        }
    };
    private static Property<View, Integer> LEFT = new IntProperty<View>("left"){

        @Override
        public void setValue(View object, int value) {
            object.setLeft(value);
        }

        @Override
        public Integer get(View object) {
            return object.getLeft();
        }
    };
    private static Property<View, Integer> TOP = new IntProperty<View>("top"){

        @Override
        public void setValue(View object, int value) {
            object.setTop(value);
        }

        @Override
        public Integer get(View object) {
            return object.getTop();
        }
    };
    private static Property<View, Integer> RIGHT = new IntProperty<View>("right"){

        @Override
        public void setValue(View object, int value) {
            object.setRight(value);
        }

        @Override
        public Integer get(View object) {
            return object.getRight();
        }
    };
    private static Property<View, Integer> BOTTOM = new IntProperty<View>("bottom"){

        @Override
        public void setValue(View object, int value) {
            object.setBottom(value);
        }

        @Override
        public Integer get(View object) {
            return object.getBottom();
        }
    };

    public FastScroller(AbsListView listView) {
        ImageView thumbImage;
        ImageView trackImage;
        this.mList = listView;
        this.mOverlay = listView.getOverlay();
        Context context = listView.getContext();
        this.mScaledTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        Resources res = context.getResources();
        TypedArray ta = context.getTheme().obtainStyledAttributes(ATTRS);
        this.mTrackImage = trackImage = new ImageView(context);
        int width = 0;
        Drawable trackDrawable = ta.getDrawable(2);
        if (trackDrawable != null) {
            this.mHasTrackImage = true;
            trackImage.setBackground(trackDrawable);
            this.mOverlay.add(trackImage);
            width = Math.max(width, trackDrawable.getIntrinsicWidth());
        } else {
            this.mHasTrackImage = false;
        }
        this.mThumbImage = thumbImage = new ImageView(context);
        Drawable thumbDrawable = ta.getDrawable(1);
        if (thumbDrawable != null) {
            thumbImage.setImageDrawable(thumbDrawable);
            this.mOverlay.add(thumbImage);
            width = Math.max(width, thumbDrawable.getIntrinsicWidth());
        }
        if (thumbDrawable.getIntrinsicWidth() <= 0 || thumbDrawable.getIntrinsicHeight() <= 0) {
            int minWidth = res.getDimensionPixelSize(17104920);
            thumbImage.setMinimumWidth(minWidth);
            thumbImage.setMinimumHeight(res.getDimensionPixelSize(17104921));
            width = Math.max(width, minWidth);
        }
        this.mWidth = width;
        int previewSize = res.getDimensionPixelSize(0x1050015);
        this.mPreviewImage = new ImageView(context);
        this.mPreviewImage.setMinimumWidth(previewSize);
        this.mPreviewImage.setMinimumHeight(previewSize);
        this.mPreviewImage.setAlpha(0.0f);
        this.mOverlay.add(this.mPreviewImage);
        this.mPreviewPadding = res.getDimensionPixelSize(17104919);
        int textMinSize = Math.max(0, previewSize - this.mPreviewPadding);
        this.mPrimaryText = this.createPreviewTextView(context, ta);
        this.mPrimaryText.setMinimumWidth(textMinSize);
        this.mPrimaryText.setMinimumHeight(textMinSize);
        this.mOverlay.add(this.mPrimaryText);
        this.mSecondaryText = this.createPreviewTextView(context, ta);
        this.mSecondaryText.setMinimumWidth(textMinSize);
        this.mSecondaryText.setMinimumHeight(textMinSize);
        this.mOverlay.add(this.mSecondaryText);
        this.mPreviewResId[0] = ta.getResourceId(3, 0);
        this.mPreviewResId[1] = ta.getResourceId(4, 0);
        this.mOverlayPosition = ta.getInt(5, 0);
        ta.recycle();
        this.mScrollBarStyle = listView.getScrollBarStyle();
        this.mScrollCompleted = true;
        this.mState = 1;
        this.mMatchDragPosition = context.getApplicationInfo().targetSdkVersion >= 11;
        this.getSectionsFromIndexer();
        this.refreshDrawablePressedState();
        this.updateLongList(listView.getChildCount(), listView.getCount());
        this.setScrollbarPosition(this.mList.getVerticalScrollbarPosition());
        this.postAutoHide();
    }

    public void remove() {
        this.mOverlay.remove(this.mTrackImage);
        this.mOverlay.remove(this.mThumbImage);
        this.mOverlay.remove(this.mPreviewImage);
        this.mOverlay.remove(this.mPrimaryText);
        this.mOverlay.remove(this.mSecondaryText);
    }

    public void setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            this.onStateDependencyChanged();
        }
    }

    public boolean isEnabled() {
        return this.mEnabled && (this.mLongList || this.mAlwaysShow);
    }

    public void setAlwaysShow(boolean alwaysShow) {
        if (this.mAlwaysShow != alwaysShow) {
            this.mAlwaysShow = alwaysShow;
            this.onStateDependencyChanged();
        }
    }

    public boolean isAlwaysShowEnabled() {
        return this.mAlwaysShow;
    }

    private void onStateDependencyChanged() {
        if (this.isEnabled()) {
            if (this.isAlwaysShowEnabled()) {
                this.setState(1);
            } else if (this.mState == 1) {
                this.postAutoHide();
            }
        } else {
            this.stop();
        }
        this.mList.resolvePadding();
    }

    public void setScrollBarStyle(int style2) {
        if (this.mScrollBarStyle != style2) {
            this.mScrollBarStyle = style2;
            this.updateLayout();
        }
    }

    public void stop() {
        this.setState(0);
    }

    public void setScrollbarPosition(int position) {
        if (position == 0) {
            int n = position = this.mList.isLayoutRtl() ? 1 : 2;
        }
        if (this.mScrollbarPosition != position) {
            this.mScrollbarPosition = position;
            this.mLayoutFromRight = position != 1;
            int previewResId = this.mPreviewResId[this.mLayoutFromRight ? 1 : 0];
            this.mPreviewImage.setBackgroundResource(previewResId);
            Drawable background = this.mPreviewImage.getBackground();
            if (background != null) {
                Rect padding = this.mTempBounds;
                background.getPadding(padding);
                padding.offset(this.mPreviewPadding, this.mPreviewPadding);
                this.mPreviewImage.setPadding(padding.left, padding.top, padding.right, padding.bottom);
            }
            this.updateLayout();
        }
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateLayout();
    }

    public void onItemCountChanged(int totalItemCount) {
        boolean hasMoreItems;
        int visibleItemCount = this.mList.getChildCount();
        boolean bl = hasMoreItems = totalItemCount - visibleItemCount > 0;
        if (hasMoreItems && this.mState != 2) {
            int firstVisibleItem = this.mList.getFirstVisiblePosition();
            this.setThumbPos(this.getPosFromItemCount(firstVisibleItem, visibleItemCount, totalItemCount));
        }
        this.updateLongList(visibleItemCount, totalItemCount);
    }

    private void updateLongList(int visibleItemCount, int totalItemCount) {
        boolean longList;
        boolean bl = longList = visibleItemCount > 0 && totalItemCount / visibleItemCount >= 4;
        if (this.mLongList != longList) {
            this.mLongList = longList;
            this.onStateDependencyChanged();
        }
    }

    private TextView createPreviewTextView(Context context, TypedArray ta) {
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        Resources res = context.getResources();
        int minSize = res.getDimensionPixelSize(0x1050015);
        ColorStateList textColor = ta.getColorStateList(0);
        float textSize = res.getDimensionPixelSize(17104918);
        TextView textView = new TextView(context);
        textView.setLayoutParams(params);
        textView.setTextColor(textColor);
        textView.setTextSize(0, textSize);
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        textView.setGravity(17);
        textView.setAlpha(0.0f);
        textView.setLayoutDirection(this.mList.getLayoutDirection());
        return textView;
    }

    public void updateLayout() {
        if (this.mUpdatingLayout) {
            return;
        }
        this.mUpdatingLayout = true;
        this.updateContainerRect();
        this.layoutThumb();
        this.layoutTrack();
        Rect bounds = this.mTempBounds;
        this.measurePreview(this.mPrimaryText, bounds);
        this.applyLayout(this.mPrimaryText, bounds);
        this.measurePreview(this.mSecondaryText, bounds);
        this.applyLayout(this.mSecondaryText, bounds);
        if (this.mPreviewImage != null) {
            bounds.left -= this.mPreviewImage.getPaddingLeft();
            bounds.top -= this.mPreviewImage.getPaddingTop();
            bounds.right += this.mPreviewImage.getPaddingRight();
            bounds.bottom += this.mPreviewImage.getPaddingBottom();
            this.applyLayout(this.mPreviewImage, bounds);
        }
        this.mUpdatingLayout = false;
    }

    private void applyLayout(View view, Rect bounds) {
        view.layout(bounds.left, bounds.top, bounds.right, bounds.bottom);
        view.setPivotX(this.mLayoutFromRight ? (float)(bounds.right - bounds.left) : 0.0f);
    }

    private void measurePreview(View v, Rect out) {
        Rect margins = this.mTempMargins;
        margins.left = this.mPreviewImage.getPaddingLeft();
        margins.top = this.mPreviewImage.getPaddingTop();
        margins.right = this.mPreviewImage.getPaddingRight();
        margins.bottom = this.mPreviewImage.getPaddingBottom();
        if (this.mOverlayPosition == 1) {
            this.measureViewToSide(v, this.mThumbImage, margins, out);
        } else {
            this.measureFloating(v, margins, out);
        }
    }

    private void measureViewToSide(View view, View adjacent, Rect margins, Rect out) {
        int left;
        int right;
        int marginRight;
        int marginTop;
        int marginLeft;
        if (margins == null) {
            marginLeft = 0;
            marginTop = 0;
            marginRight = 0;
        } else {
            marginLeft = margins.left;
            marginTop = margins.top;
            marginRight = margins.right;
        }
        Rect container = this.mContainerRect;
        int containerWidth = container.width();
        int maxWidth = adjacent == null ? containerWidth : (this.mLayoutFromRight ? adjacent.getLeft() : containerWidth - adjacent.getRight());
        int adjMaxWidth = maxWidth - marginLeft - marginRight;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(adjMaxWidth, Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        view.measure(widthMeasureSpec, heightMeasureSpec);
        int width = view.getMeasuredWidth();
        if (this.mLayoutFromRight) {
            right = (adjacent == null ? container.right : adjacent.getLeft()) - marginRight;
            left = right - width;
        } else {
            left = (adjacent == null ? container.left : adjacent.getRight()) + marginLeft;
            right = left + width;
        }
        int top = marginTop;
        int bottom = top + view.getMeasuredHeight();
        out.set(left, top, right, bottom);
    }

    private void measureFloating(View preview, Rect margins, Rect out) {
        int marginRight;
        int marginTop;
        int marginLeft;
        if (margins == null) {
            marginLeft = 0;
            marginTop = 0;
            marginRight = 0;
        } else {
            marginLeft = margins.left;
            marginTop = margins.top;
            marginRight = margins.right;
        }
        Rect container = this.mContainerRect;
        int containerWidth = container.width();
        int adjMaxWidth = containerWidth - marginLeft - marginRight;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(adjMaxWidth, Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        preview.measure(widthMeasureSpec, heightMeasureSpec);
        int containerHeight = container.height();
        int width = preview.getMeasuredWidth();
        int top = containerHeight / 10 + marginTop + container.top;
        int bottom = top + preview.getMeasuredHeight();
        int left = (containerWidth - width) / 2 + container.left;
        int right = left + width;
        out.set(left, top, right, bottom);
    }

    private void updateContainerRect() {
        AbsListView list = this.mList;
        list.resolvePadding();
        Rect container = this.mContainerRect;
        container.left = 0;
        container.top = 0;
        container.right = list.getWidth();
        container.bottom = list.getHeight();
        int scrollbarStyle = this.mScrollBarStyle;
        if (scrollbarStyle == 0x1000000 || scrollbarStyle == 0) {
            container.left += list.getPaddingLeft();
            container.top += list.getPaddingTop();
            container.right -= list.getPaddingRight();
            container.bottom -= list.getPaddingBottom();
            if (scrollbarStyle == 0x1000000) {
                int width = this.getWidth();
                if (this.mScrollbarPosition == 2) {
                    container.right += width;
                } else {
                    container.left -= width;
                }
            }
        }
    }

    private void layoutThumb() {
        Rect bounds = this.mTempBounds;
        this.measureViewToSide(this.mThumbImage, null, null, bounds);
        this.applyLayout(this.mThumbImage, bounds);
    }

    private void layoutTrack() {
        ImageView track = this.mTrackImage;
        ImageView thumb = this.mThumbImage;
        Rect container = this.mContainerRect;
        int containerWidth = container.width();
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(containerWidth, Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        track.measure(widthMeasureSpec, heightMeasureSpec);
        int trackWidth = track.getMeasuredWidth();
        int thumbHalfHeight = thumb == null ? 0 : thumb.getHeight() / 2;
        int left = thumb.getLeft() + (thumb.getWidth() - trackWidth) / 2;
        int right = left + trackWidth;
        int top = container.top + thumbHalfHeight;
        int bottom = container.bottom - thumbHalfHeight;
        track.layout(left, top, right, bottom);
    }

    private void setState(int state) {
        this.mList.removeCallbacks(this.mDeferHide);
        if (this.mAlwaysShow && state == 0) {
            state = 1;
        }
        if (state == this.mState) {
            return;
        }
        switch (state) {
            case 0: {
                this.transitionToHidden();
                break;
            }
            case 1: {
                this.transitionToVisible();
                break;
            }
            case 2: {
                if (this.transitionPreviewLayout(this.mCurrentSection)) {
                    this.transitionToDragging();
                    break;
                }
                this.transitionToVisible();
            }
        }
        this.mState = state;
        this.refreshDrawablePressedState();
    }

    private void refreshDrawablePressedState() {
        boolean isPressed = this.mState == 2;
        this.mThumbImage.setPressed(isPressed);
        this.mTrackImage.setPressed(isPressed);
    }

    private void transitionToHidden() {
        if (this.mDecorAnimation != null) {
            this.mDecorAnimation.cancel();
        }
        Animator fadeOut = FastScroller.groupAnimatorOfFloat(View.ALPHA, 0.0f, this.mThumbImage, this.mTrackImage, this.mPreviewImage, this.mPrimaryText, this.mSecondaryText).setDuration(300L);
        float offset = this.mLayoutFromRight ? (float)this.mThumbImage.getWidth() : (float)(-this.mThumbImage.getWidth());
        Animator slideOut = FastScroller.groupAnimatorOfFloat(View.TRANSLATION_X, offset, this.mThumbImage, this.mTrackImage).setDuration(300L);
        this.mDecorAnimation = new AnimatorSet();
        this.mDecorAnimation.playTogether(fadeOut, slideOut);
        this.mDecorAnimation.start();
    }

    private void transitionToVisible() {
        if (this.mDecorAnimation != null) {
            this.mDecorAnimation.cancel();
        }
        Animator fadeIn = FastScroller.groupAnimatorOfFloat(View.ALPHA, 1.0f, this.mThumbImage, this.mTrackImage).setDuration(150L);
        Animator fadeOut = FastScroller.groupAnimatorOfFloat(View.ALPHA, 0.0f, this.mPreviewImage, this.mPrimaryText, this.mSecondaryText).setDuration(300L);
        Animator slideIn = FastScroller.groupAnimatorOfFloat(View.TRANSLATION_X, 0.0f, this.mThumbImage, this.mTrackImage).setDuration(150L);
        this.mDecorAnimation = new AnimatorSet();
        this.mDecorAnimation.playTogether(fadeIn, fadeOut, slideIn);
        this.mDecorAnimation.start();
    }

    private void transitionToDragging() {
        if (this.mDecorAnimation != null) {
            this.mDecorAnimation.cancel();
        }
        Animator fadeIn = FastScroller.groupAnimatorOfFloat(View.ALPHA, 1.0f, this.mThumbImage, this.mTrackImage, this.mPreviewImage).setDuration(150L);
        Animator slideIn = FastScroller.groupAnimatorOfFloat(View.TRANSLATION_X, 0.0f, this.mThumbImage, this.mTrackImage).setDuration(150L);
        this.mDecorAnimation = new AnimatorSet();
        this.mDecorAnimation.playTogether(fadeIn, slideIn);
        this.mDecorAnimation.start();
    }

    private void postAutoHide() {
        this.mList.removeCallbacks(this.mDeferHide);
        this.mList.postDelayed(this.mDeferHide, 1500L);
    }

    public void onScroll(int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        boolean hasMoreItems;
        if (!this.isEnabled()) {
            this.setState(0);
            return;
        }
        boolean bl = hasMoreItems = totalItemCount - visibleItemCount > 0;
        if (hasMoreItems && this.mState != 2) {
            this.setThumbPos(this.getPosFromItemCount(firstVisibleItem, visibleItemCount, totalItemCount));
        }
        this.mScrollCompleted = true;
        if (this.mFirstVisibleItem != firstVisibleItem) {
            this.mFirstVisibleItem = firstVisibleItem;
            if (this.mState != 2) {
                this.setState(1);
                this.postAutoHide();
            }
        }
    }

    private void getSectionsFromIndexer() {
        this.mSectionIndexer = null;
        Object adapter = this.mList.getAdapter();
        if (adapter instanceof HeaderViewListAdapter) {
            this.mHeaderCount = ((HeaderViewListAdapter)adapter).getHeadersCount();
            adapter = ((HeaderViewListAdapter)adapter).getWrappedAdapter();
        }
        if (adapter instanceof ExpandableListConnector) {
            ExpandableListAdapter expAdapter = ((ExpandableListConnector)adapter).getAdapter();
            if (expAdapter instanceof SectionIndexer) {
                this.mSectionIndexer = (SectionIndexer)((Object)expAdapter);
                this.mListAdapter = (BaseAdapter)adapter;
                this.mSections = this.mSectionIndexer.getSections();
            }
        } else if (adapter instanceof SectionIndexer) {
            this.mListAdapter = (BaseAdapter)adapter;
            this.mSectionIndexer = (SectionIndexer)adapter;
            this.mSections = this.mSectionIndexer.getSections();
        } else {
            this.mListAdapter = (BaseAdapter)adapter;
            this.mSections = null;
        }
    }

    public void onSectionsChanged() {
        this.mListAdapter = null;
    }

    private void scrollTo(float position) {
        int sectionIndex;
        int sectionCount;
        this.mScrollCompleted = false;
        int count = this.mList.getCount();
        Object[] sections = this.mSections;
        int n = sectionCount = sections == null ? 0 : sections.length;
        if (sections != null && sectionCount > 1) {
            int exactSection;
            int targetSection = exactSection = MathUtils.constrain((int)(position * (float)sectionCount), 0, sectionCount - 1);
            int targetIndex = this.mSectionIndexer.getPositionForSection(targetSection);
            sectionIndex = targetSection;
            int nextIndex = count;
            int prevIndex = targetIndex;
            int prevSection = targetSection;
            int nextSection = targetSection + 1;
            if (targetSection < sectionCount - 1) {
                nextIndex = this.mSectionIndexer.getPositionForSection(targetSection + 1);
            }
            if (nextIndex == targetIndex) {
                while (targetSection > 0) {
                    if ((prevIndex = this.mSectionIndexer.getPositionForSection(--targetSection)) != targetIndex) {
                        prevSection = targetSection;
                        sectionIndex = targetSection;
                        break;
                    }
                    if (targetSection != 0) continue;
                    sectionIndex = 0;
                    break;
                }
            }
            int nextNextSection = nextSection + 1;
            while (nextNextSection < sectionCount && this.mSectionIndexer.getPositionForSection(nextNextSection) == nextIndex) {
                ++nextNextSection;
                ++nextSection;
            }
            float prevPosition = (float)prevSection / (float)sectionCount;
            float nextPosition = (float)nextSection / (float)sectionCount;
            float snapThreshold = count == 0 ? Float.MAX_VALUE : 0.125f / (float)count;
            targetIndex = prevSection == exactSection && position - prevPosition < snapThreshold ? prevIndex : prevIndex + (int)((float)(nextIndex - prevIndex) * (position - prevPosition) / (nextPosition - prevPosition));
            targetIndex = MathUtils.constrain(targetIndex, 0, count - 1);
            if (this.mList instanceof ExpandableListView) {
                ExpandableListView expList = (ExpandableListView)this.mList;
                expList.setSelectionFromTop(expList.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(targetIndex + this.mHeaderCount)), 0);
            } else if (this.mList instanceof ListView) {
                ((ListView)this.mList).setSelectionFromTop(targetIndex + this.mHeaderCount, 0);
            } else {
                this.mList.setSelection(targetIndex + this.mHeaderCount);
            }
        } else {
            int index = MathUtils.constrain((int)(position * (float)count), 0, count - 1);
            if (this.mList instanceof ExpandableListView) {
                ExpandableListView expList = (ExpandableListView)this.mList;
                expList.setSelectionFromTop(expList.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(index + this.mHeaderCount)), 0);
            } else if (this.mList instanceof ListView) {
                ((ListView)this.mList).setSelectionFromTop(index + this.mHeaderCount, 0);
            } else {
                this.mList.setSelection(index + this.mHeaderCount);
            }
            sectionIndex = -1;
        }
        if (this.mCurrentSection != sectionIndex) {
            this.mCurrentSection = sectionIndex;
            if (this.transitionPreviewLayout(sectionIndex)) {
                this.transitionToDragging();
            } else {
                this.transitionToVisible();
            }
        }
    }

    private boolean transitionPreviewLayout(int sectionIndex) {
        TextView target;
        TextView showing;
        Object section;
        Object[] sections = this.mSections;
        String text = null;
        if (sections != null && sectionIndex >= 0 && sectionIndex < sections.length && (section = sections[sectionIndex]) != null) {
            text = section.toString();
        }
        Rect bounds = this.mTempBounds;
        ImageView preview = this.mPreviewImage;
        if (this.mShowingPrimary) {
            showing = this.mPrimaryText;
            target = this.mSecondaryText;
        } else {
            showing = this.mSecondaryText;
            target = this.mPrimaryText;
        }
        target.setText(text);
        this.measurePreview(target, bounds);
        this.applyLayout(target, bounds);
        if (this.mPreviewAnimation != null) {
            this.mPreviewAnimation.cancel();
        }
        Animator showTarget = FastScroller.animateAlpha(target, 1.0f).setDuration(50L);
        Animator hideShowing = FastScroller.animateAlpha(showing, 0.0f).setDuration(50L);
        hideShowing.addListener(this.mSwitchPrimaryListener);
        bounds.left -= this.mPreviewImage.getPaddingLeft();
        bounds.top -= this.mPreviewImage.getPaddingTop();
        bounds.right += this.mPreviewImage.getPaddingRight();
        bounds.bottom += this.mPreviewImage.getPaddingBottom();
        Animator resizePreview = FastScroller.animateBounds(preview, bounds);
        resizePreview.setDuration(100L);
        this.mPreviewAnimation = new AnimatorSet();
        AnimatorSet.Builder builder = this.mPreviewAnimation.play(hideShowing).with(showTarget);
        builder.with(resizePreview);
        int previewWidth = preview.getWidth() - preview.getPaddingLeft() - preview.getPaddingRight();
        int targetWidth = target.getWidth();
        if (targetWidth > previewWidth) {
            target.setScaleX((float)previewWidth / (float)targetWidth);
            Animator scaleAnim = FastScroller.animateScaleX(target, 1.0f).setDuration(100L);
            builder.with(scaleAnim);
        } else {
            target.setScaleX(1.0f);
        }
        int showingWidth = showing.getWidth();
        if (showingWidth > targetWidth) {
            float scale = (float)targetWidth / (float)showingWidth;
            Animator scaleAnim = FastScroller.animateScaleX(showing, scale).setDuration(100L);
            builder.with(scaleAnim);
        }
        this.mPreviewAnimation.start();
        return text != null && text.length() > 0;
    }

    private void setThumbPos(float position) {
        Rect container = this.mContainerRect;
        int top = container.top;
        int bottom = container.bottom;
        ImageView trackImage = this.mTrackImage;
        ImageView thumbImage = this.mThumbImage;
        float min = trackImage.getTop();
        float max = trackImage.getBottom();
        float offset = min;
        float range = max - min;
        float thumbMiddle = position * range + offset;
        thumbImage.setTranslationY(thumbMiddle - (float)(thumbImage.getHeight() / 2));
        float previewPos = this.mOverlayPosition == 1 ? thumbMiddle : 0.0f;
        ImageView previewImage = this.mPreviewImage;
        float previewHalfHeight = (float)previewImage.getHeight() / 2.0f;
        float minP = (float)top + previewHalfHeight;
        float maxP = (float)bottom - previewHalfHeight;
        float previewMiddle = MathUtils.constrain(previewPos, minP, maxP);
        float previewTop = previewMiddle - previewHalfHeight;
        previewImage.setTranslationY(previewTop);
        this.mPrimaryText.setTranslationY(previewTop);
        this.mSecondaryText.setTranslationY(previewTop);
    }

    private float getPosFromMotionEvent(float y) {
        Rect container = this.mContainerRect;
        int top = container.top;
        int bottom = container.bottom;
        ImageView trackImage = this.mTrackImage;
        float min = trackImage.getTop();
        float max = trackImage.getBottom();
        float offset = min;
        float range = max - min;
        if (range <= 0.0f) {
            return 0.0f;
        }
        return MathUtils.constrain((y - offset) / range, 0.0f, 1.0f);
    }

    private float getPosFromItemCount(int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int positionsInSection;
        boolean hasSections;
        if (this.mSectionIndexer == null || this.mListAdapter == null) {
            this.getSectionsFromIndexer();
        }
        boolean bl = hasSections = this.mSectionIndexer != null && this.mSections != null && this.mSections.length > 0;
        if (!hasSections || !this.mMatchDragPosition) {
            return (float)firstVisibleItem / (float)(totalItemCount - visibleItemCount);
        }
        if ((firstVisibleItem -= this.mHeaderCount) < 0) {
            return 0.0f;
        }
        totalItemCount -= this.mHeaderCount;
        View child = this.mList.getChildAt(0);
        float incrementalPos = child == null || child.getHeight() == 0 ? 0.0f : (float)(this.mList.getPaddingTop() - child.getTop()) / (float)child.getHeight();
        int section = this.mSectionIndexer.getSectionForPosition(firstVisibleItem);
        int sectionPos = this.mSectionIndexer.getPositionForSection(section);
        int sectionCount = this.mSections.length;
        if (section < sectionCount - 1) {
            int nextSectionPos = section + 1 < sectionCount ? this.mSectionIndexer.getPositionForSection(section + 1) : totalItemCount - 1;
            positionsInSection = nextSectionPos - sectionPos;
        } else {
            positionsInSection = totalItemCount - sectionPos;
        }
        float posWithinSection = positionsInSection == 0 ? 0.0f : ((float)firstVisibleItem + incrementalPos - (float)sectionPos) / (float)positionsInSection;
        return ((float)section + posWithinSection) / (float)sectionCount;
    }

    private void cancelFling() {
        MotionEvent cancelFling = MotionEvent.obtain(0L, 0L, 3, 0.0f, 0.0f, 0);
        this.mList.onTouchEvent(cancelFling);
        cancelFling.recycle();
    }

    private void cancelPendingDrag() {
        this.mList.removeCallbacks(this.mDeferStartDrag);
        this.mHasPendingDrag = false;
    }

    private void startPendingDrag() {
        this.mHasPendingDrag = true;
        this.mList.postDelayed(this.mDeferStartDrag, TAP_TIMEOUT);
    }

    private void beginDrag() {
        this.setState(2);
        if (this.mListAdapter == null && this.mList != null) {
            this.getSectionsFromIndexer();
        }
        if (this.mList != null) {
            this.mList.requestDisallowInterceptTouchEvent(true);
            this.mList.reportScrollStateChange(1);
        }
        this.cancelFling();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (ev.getActionMasked()) {
            case 0: {
                if (!this.isPointInside(ev.getX(), ev.getY())) break;
                if (!this.mList.isInScrollingContainer()) {
                    this.beginDrag();
                    return true;
                }
                this.mInitialTouchY = ev.getY();
                this.startPendingDrag();
                break;
            }
            case 2: {
                if (this.isPointInside(ev.getX(), ev.getY())) break;
                this.cancelPendingDrag();
                break;
            }
            case 1: 
            case 3: {
                this.cancelPendingDrag();
            }
        }
        return false;
    }

    public boolean onInterceptHoverEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return false;
        }
        int actionMasked = ev.getActionMasked();
        if ((actionMasked == 9 || actionMasked == 7) && this.mState == 0 && this.isPointInside(ev.getX(), ev.getY())) {
            this.setState(1);
            this.postAutoHide();
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent me) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (me.getActionMasked()) {
            case 1: {
                if (this.mHasPendingDrag) {
                    this.beginDrag();
                    float pos = this.getPosFromMotionEvent(me.getY());
                    this.setThumbPos(pos);
                    this.scrollTo(pos);
                    this.cancelPendingDrag();
                }
                if (this.mState != 2) break;
                if (this.mList != null) {
                    this.mList.requestDisallowInterceptTouchEvent(false);
                    this.mList.reportScrollStateChange(0);
                }
                this.setState(1);
                this.postAutoHide();
                return true;
            }
            case 2: {
                if (this.mHasPendingDrag && Math.abs(me.getY() - this.mInitialTouchY) > (float)this.mScaledTouchSlop) {
                    this.setState(2);
                    if (this.mListAdapter == null && this.mList != null) {
                        this.getSectionsFromIndexer();
                    }
                    if (this.mList != null) {
                        this.mList.requestDisallowInterceptTouchEvent(true);
                        this.mList.reportScrollStateChange(1);
                    }
                    this.cancelFling();
                    this.cancelPendingDrag();
                }
                if (this.mState != 2) break;
                float pos = this.getPosFromMotionEvent(me.getY());
                this.setThumbPos(pos);
                if (this.mScrollCompleted) {
                    this.scrollTo(pos);
                }
                return true;
            }
            case 3: {
                this.cancelPendingDrag();
            }
        }
        return false;
    }

    private boolean isPointInside(float x, float y) {
        return this.isPointInsideX(x) && (this.mHasTrackImage || this.isPointInsideY(y));
    }

    private boolean isPointInsideX(float x) {
        if (this.mLayoutFromRight) {
            return x >= (float)this.mThumbImage.getLeft();
        }
        return x <= (float)this.mThumbImage.getRight();
    }

    private boolean isPointInsideY(float y) {
        float offset = this.mThumbImage.getTranslationY();
        float top = (float)this.mThumbImage.getTop() + offset;
        float bottom = (float)this.mThumbImage.getBottom() + offset;
        return y >= top && y <= bottom;
    }

    private static Animator groupAnimatorOfFloat(Property<View, Float> property, float value, View ... views) {
        AnimatorSet animSet = new AnimatorSet();
        AnimatorSet.Builder builder = null;
        for (int i = views.length - 1; i >= 0; --i) {
            ObjectAnimator anim2 = ObjectAnimator.ofFloat(views[i], property, value);
            if (builder == null) {
                builder = animSet.play(anim2);
                continue;
            }
            builder.with(anim2);
        }
        return animSet;
    }

    private static Animator animateScaleX(View v, float target) {
        return ObjectAnimator.ofFloat(v, View.SCALE_X, target);
    }

    private static Animator animateAlpha(View v, float alpha) {
        return ObjectAnimator.ofFloat(v, View.ALPHA, alpha);
    }

    private static Animator animateBounds(View v, Rect bounds) {
        PropertyValuesHolder left = PropertyValuesHolder.ofInt(LEFT, bounds.left);
        PropertyValuesHolder top = PropertyValuesHolder.ofInt(TOP, bounds.top);
        PropertyValuesHolder right = PropertyValuesHolder.ofInt(RIGHT, bounds.right);
        PropertyValuesHolder bottom = PropertyValuesHolder.ofInt(BOTTOM, bounds.bottom);
        return ObjectAnimator.ofPropertyValuesHolder(v, left, top, right, bottom);
    }
}

