/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Pools;
import android.util.SparseArray;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InputQueue {
    private final SparseArray<ActiveInputEvent> mActiveEventArray = new SparseArray(20);
    private final Pools.Pool<ActiveInputEvent> mActiveInputEventPool = new Pools.SimplePool<ActiveInputEvent>(20);
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private int mPtr = InputQueue.nativeInit(new WeakReference<InputQueue>(this), Looper.myQueue());

    private static native int nativeInit(WeakReference<InputQueue> var0, MessageQueue var1);

    private static native int nativeSendKeyEvent(int var0, KeyEvent var1, boolean var2);

    private static native int nativeSendMotionEvent(int var0, MotionEvent var1);

    private static native void nativeDispose(int var0);

    public InputQueue() {
        this.mCloseGuard.open("dispose");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mPtr != 0) {
            InputQueue.nativeDispose(this.mPtr);
            this.mPtr = 0;
        }
    }

    public int getNativePtr() {
        return this.mPtr;
    }

    public void sendInputEvent(InputEvent e, Object token, boolean predispatch, FinishedInputEventCallback callback) {
        ActiveInputEvent event = this.obtainActiveInputEvent(token, callback);
        int id2 = e instanceof KeyEvent ? InputQueue.nativeSendKeyEvent(this.mPtr, (KeyEvent)e, predispatch) : InputQueue.nativeSendMotionEvent(this.mPtr, (MotionEvent)e);
        this.mActiveEventArray.put(id2, event);
    }

    private void finishInputEvent(int id2, boolean handled) {
        int index = this.mActiveEventArray.indexOfKey(id2);
        if (index >= 0) {
            ActiveInputEvent e = this.mActiveEventArray.valueAt(index);
            this.mActiveEventArray.removeAt(index);
            e.mCallback.onFinishedInputEvent(e.mToken, handled);
            this.recycleActiveInputEvent(e);
        }
    }

    private ActiveInputEvent obtainActiveInputEvent(Object token, FinishedInputEventCallback callback) {
        ActiveInputEvent e = this.mActiveInputEventPool.acquire();
        if (e == null) {
            e = new ActiveInputEvent();
        }
        e.mToken = token;
        e.mCallback = callback;
        return e;
    }

    private void recycleActiveInputEvent(ActiveInputEvent e) {
        e.recycle();
        this.mActiveInputEventPool.release(e);
    }

    public static interface FinishedInputEventCallback {
        public void onFinishedInputEvent(Object var1, boolean var2);
    }

    public static interface Callback {
        public void onInputQueueCreated(InputQueue var1);

        public void onInputQueueDestroyed(InputQueue var1);
    }

    private final class ActiveInputEvent {
        public Object mToken;
        public FinishedInputEventCallback mCallback;

        private ActiveInputEvent() {
        }

        public void recycle() {
            this.mToken = null;
            this.mCallback = null;
        }
    }
}

