/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.view.LayoutInflater;

public class ContextThemeWrapper
extends ContextWrapper {
    private Context mBase;
    private int mThemeResource;
    private Resources.Theme mTheme;
    private LayoutInflater mInflater;
    private Configuration mOverrideConfiguration;
    private Resources mResources;

    public ContextThemeWrapper() {
        super(null);
    }

    public ContextThemeWrapper(Context base, int themeres) {
        super(base);
        this.mBase = base;
        this.mThemeResource = themeres;
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(newBase);
        this.mBase = newBase;
    }

    public void applyOverrideConfiguration(Configuration overrideConfiguration) {
        if (this.mResources != null) {
            throw new IllegalStateException("getResources() has already been called");
        }
        if (this.mOverrideConfiguration != null) {
            throw new IllegalStateException("Override configuration has already been set");
        }
        this.mOverrideConfiguration = new Configuration(overrideConfiguration);
    }

    public Resources getResources() {
        if (this.mResources != null) {
            return this.mResources;
        }
        if (this.mOverrideConfiguration == null) {
            this.mResources = super.getResources();
            return this.mResources;
        }
        Context resc = this.createConfigurationContext(this.mOverrideConfiguration);
        this.mResources = resc.getResources();
        return this.mResources;
    }

    public void setTheme(int resid) {
        this.mThemeResource = resid;
        this.initializeTheme();
    }

    public int getThemeResId() {
        return this.mThemeResource;
    }

    public Resources.Theme getTheme() {
        if (this.mTheme != null) {
            return this.mTheme;
        }
        this.mThemeResource = Resources.selectDefaultTheme(this.mThemeResource, this.getApplicationInfo().targetSdkVersion);
        this.initializeTheme();
        return this.mTheme;
    }

    public Object getSystemService(String name) {
        if ("layout_inflater".equals(name)) {
            if (this.mInflater == null) {
                this.mInflater = LayoutInflater.from(this.mBase).cloneInContext(this);
            }
            return this.mInflater;
        }
        return this.mBase.getSystemService(name);
    }

    protected void onApplyThemeResource(Resources.Theme theme, int resid, boolean first) {
        theme.applyStyle(resid, true);
    }

    private void initializeTheme() {
        boolean first;
        boolean bl = first = this.mTheme == null;
        if (first) {
            this.mTheme = this.getResources().newTheme();
            Resources.Theme theme = this.mBase.getTheme();
            if (theme != null) {
                this.mTheme.setTo(theme);
            }
        }
        this.onApplyThemeResource(this.mTheme, this.mThemeResource, first);
    }
}

