/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.transition.AutoTransition;
import android.transition.Scene;
import android.transition.Transition;
import android.util.ArrayMap;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionManager {
    private static String LOG_TAG = "TransitionManager";
    private static Transition sDefaultTransition = new AutoTransition();
    ArrayMap<Scene, Transition> mSceneTransitions = new ArrayMap();
    ArrayMap<Scene, ArrayMap<Scene, Transition>> mScenePairTransitions = new ArrayMap();
    private static ThreadLocal<WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>>> sRunningTransitions = new ThreadLocal();
    private static ArrayList<ViewGroup> sPendingTransitions = new ArrayList();

    public void setDefaultTransition(Transition transition) {
        sDefaultTransition = transition;
    }

    public static Transition getDefaultTransition() {
        return sDefaultTransition;
    }

    public void setTransition(Scene scene, Transition transition) {
        this.mSceneTransitions.put(scene, transition);
    }

    public void setTransition(Scene fromScene, Scene toScene, Transition transition) {
        ArrayMap<Scene, Transition> sceneTransitionMap = this.mScenePairTransitions.get(toScene);
        if (sceneTransitionMap == null) {
            sceneTransitionMap = new ArrayMap();
            this.mScenePairTransitions.put(toScene, sceneTransitionMap);
        }
        sceneTransitionMap.put(fromScene, transition);
    }

    private Transition getTransition(Scene scene) {
        ArrayMap<Scene, Transition> sceneTransitionMap;
        Scene currScene;
        Transition transition = null;
        ViewGroup sceneRoot = scene.getSceneRoot();
        if (sceneRoot != null && (currScene = Scene.getCurrentScene(sceneRoot)) != null && (sceneTransitionMap = this.mScenePairTransitions.get(scene)) != null && (transition = sceneTransitionMap.get(currScene)) != null) {
            return transition;
        }
        transition = this.mSceneTransitions.get(scene);
        return transition != null ? transition : sDefaultTransition;
    }

    private static void changeScene(Scene scene, Transition transition) {
        ViewGroup sceneRoot = scene.getSceneRoot();
        Transition transitionClone = transition.clone();
        transitionClone.setSceneRoot(sceneRoot);
        Scene oldScene = Scene.getCurrentScene(sceneRoot);
        if (oldScene != null && oldScene.isCreatedFromLayoutResource()) {
            transitionClone.setCanRemoveViews(true);
        }
        TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
        scene.enter();
        TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
    }

    private static ArrayMap<ViewGroup, ArrayList<Transition>> getRunningTransitions() {
        WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>> runningTransitions = sRunningTransitions.get();
        if (runningTransitions == null || runningTransitions.get() == null) {
            ArrayMap transitions = new ArrayMap();
            runningTransitions = new WeakReference(transitions);
            sRunningTransitions.set(runningTransitions);
        }
        return (ArrayMap)runningTransitions.get();
    }

    private static void sceneChangeRunTransition(final ViewGroup sceneRoot, final Transition transition) {
        if (transition != null) {
            ViewTreeObserver observer = sceneRoot.getViewTreeObserver();
            ViewTreeObserver.OnPreDrawListener listener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    sceneRoot.getViewTreeObserver().removeOnPreDrawListener(this);
                    sPendingTransitions.remove(sceneRoot);
                    final ArrayMap runningTransitions = TransitionManager.getRunningTransitions();
                    ArrayList<Transition> currentTransitions = (ArrayList<Transition>)runningTransitions.get(sceneRoot);
                    ArrayList previousRunningTransitions = null;
                    if (currentTransitions == null) {
                        currentTransitions = new ArrayList<Transition>();
                        runningTransitions.put(sceneRoot, currentTransitions);
                    } else if (currentTransitions.size() > 0) {
                        previousRunningTransitions = new ArrayList(currentTransitions);
                    }
                    currentTransitions.add(transition);
                    transition.addListener(new Transition.TransitionListenerAdapter(){

                        public void onTransitionEnd(Transition transition) {
                            ArrayList currentTransitions = (ArrayList)runningTransitions.get(sceneRoot);
                            currentTransitions.remove(transition);
                        }
                    });
                    transition.captureValues(sceneRoot, false);
                    if (previousRunningTransitions != null) {
                        for (Transition runningTransition : previousRunningTransitions) {
                            runningTransition.resume();
                        }
                    }
                    transition.playTransition(sceneRoot);
                    return true;
                }
            };
            observer.addOnPreDrawListener(listener);
        }
    }

    private static void sceneChangeSetup(ViewGroup sceneRoot, Transition transition) {
        Scene previousScene;
        ArrayList<Transition> runningTransitions = TransitionManager.getRunningTransitions().get(sceneRoot);
        if (runningTransitions != null && runningTransitions.size() > 0) {
            for (Transition runningTransition : runningTransitions) {
                runningTransition.pause();
            }
        }
        if (transition != null) {
            transition.captureValues(sceneRoot, true);
        }
        if ((previousScene = Scene.getCurrentScene(sceneRoot)) != null) {
            previousScene.exit();
        }
    }

    public void transitionTo(Scene scene) {
        TransitionManager.changeScene(scene, this.getTransition(scene));
    }

    public static void go(Scene scene) {
        TransitionManager.changeScene(scene, sDefaultTransition);
    }

    public static void go(Scene scene, Transition transition) {
        TransitionManager.changeScene(scene, transition);
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot) {
        TransitionManager.beginDelayedTransition(sceneRoot, null);
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot, Transition transition) {
        if (!sPendingTransitions.contains(sceneRoot) && sceneRoot.isLaidOut()) {
            sPendingTransitions.add(sceneRoot);
            if (transition == null) {
                transition = sDefaultTransition;
            }
            Transition transitionClone = transition.clone();
            TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
            Scene.setCurrentScene(sceneRoot, null);
            TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
        }
    }
}

