/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.transition.TransitionSet;
import android.transition.TransitionValues;
import android.transition.TransitionValuesMaps;
import android.util.ArrayMap;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transition
implements Cloneable {
    private static final String LOG_TAG = "Transition";
    static final boolean DBG = false;
    private String mName = this.getClass().getName();
    long mStartDelay = -1L;
    long mDuration = -1L;
    TimeInterpolator mInterpolator = null;
    ArrayList<Integer> mTargetIds = new ArrayList();
    ArrayList<View> mTargets = new ArrayList();
    ArrayList<Integer> mTargetIdExcludes = null;
    ArrayList<View> mTargetExcludes = null;
    ArrayList<Class> mTargetTypeExcludes = null;
    ArrayList<Integer> mTargetIdChildExcludes = null;
    ArrayList<View> mTargetChildExcludes = null;
    ArrayList<Class> mTargetTypeChildExcludes = null;
    private TransitionValuesMaps mStartValues = new TransitionValuesMaps();
    private TransitionValuesMaps mEndValues = new TransitionValuesMaps();
    TransitionSet mParent = null;
    private static ThreadLocal<ArrayMap<Animator, AnimationInfo>> sRunningAnimators = new ThreadLocal();
    ViewGroup mSceneRoot = null;
    boolean mCanRemoveViews = false;
    private ArrayList<Animator> mCurrentAnimators = new ArrayList();
    int mNumInstances = 0;
    boolean mPaused = false;
    private boolean mEnded = false;
    ArrayList<TransitionListener> mListeners = null;
    ArrayList<Animator> mAnimators = new ArrayList();

    public Transition setDuration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public Transition setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
        return this;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    public Transition setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
        return this;
    }

    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public String[] getTransitionProperties() {
        return null;
    }

    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    protected void createAnimators(ViewGroup sceneRoot, TransitionValuesMaps startValues, TransitionValuesMaps endValues) {
        ArrayMap endCopy = new ArrayMap(endValues.viewValues);
        SparseArray<TransitionValues> endIdCopy = new SparseArray<TransitionValues>(endValues.idValues.size());
        for (int i = 0; i < endValues.idValues.size(); ++i) {
            int id2 = endValues.idValues.keyAt(i);
            endIdCopy.put(id2, endValues.idValues.valueAt(i));
        }
        LongSparseArray<TransitionValues> endItemIdCopy = new LongSparseArray<TransitionValues>(endValues.itemIdValues.size());
        for (int i = 0; i < endValues.itemIdValues.size(); ++i) {
            long id3 = endValues.itemIdValues.keyAt(i);
            endItemIdCopy.put(id3, endValues.itemIdValues.valueAt(i));
        }
        ArrayList<TransitionValues> startValuesList = new ArrayList<TransitionValues>();
        ArrayList<TransitionValues> endValuesList = new ArrayList<TransitionValues>();
        for (View view : startValues.viewValues.keySet()) {
            TransitionValues start = null;
            TransitionValues end = null;
            boolean isInListView = false;
            if (view.getParent() instanceof ListView) {
                isInListView = true;
            }
            if (!isInListView) {
                int id4 = view.getId();
                TransitionValues transitionValues = start = startValues.viewValues.get(view) != null ? startValues.viewValues.get(view) : startValues.idValues.get(id4);
                if (endValues.viewValues.get(view) != null) {
                    end = endValues.viewValues.get(view);
                    endCopy.remove(view);
                } else if (id4 != -1) {
                    end = endValues.idValues.get(id4);
                    View removeView = null;
                    for (View viewToRemove : endCopy.keySet()) {
                        if (viewToRemove.getId() != id4) continue;
                        removeView = viewToRemove;
                    }
                    if (removeView != null) {
                        endCopy.remove(removeView);
                    }
                }
                endIdCopy.remove(id4);
                if (!this.isValidTarget(view, id4)) continue;
                startValuesList.add(start);
                endValuesList.add(end);
                continue;
            }
            ListView parent = (ListView)view.getParent();
            if (!parent.getAdapter().hasStableIds()) continue;
            int position = parent.getPositionForView(view);
            long itemId = parent.getItemIdAtPosition(position);
            start = startValues.itemIdValues.get(itemId);
            endItemIdCopy.remove(itemId);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        int startItemIdCopySize = startValues.itemIdValues.size();
        for (int i = 0; i < startItemIdCopySize; ++i) {
            long id5 = startValues.itemIdValues.keyAt(i);
            if (!this.isValidTarget(null, id5)) continue;
            TransitionValues start = startValues.itemIdValues.get(id5);
            TransitionValues end = endValues.itemIdValues.get(id5);
            endItemIdCopy.remove(id5);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        for (View view : endCopy.keySet()) {
            int id6;
            if (!this.isValidTarget(view, id6 = view.getId())) continue;
            TransitionValues start = startValues.viewValues.get(view) != null ? startValues.viewValues.get(view) : startValues.idValues.get(id6);
            TransitionValues end = (TransitionValues)endCopy.get(view);
            endIdCopy.remove(id6);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        int endIdCopySize = endIdCopy.size();
        for (int i = 0; i < endIdCopySize; ++i) {
            int id7 = endIdCopy.keyAt(i);
            if (!this.isValidTarget(null, id7)) continue;
            TransitionValues start = startValues.idValues.get(id7);
            TransitionValues end = (TransitionValues)endIdCopy.get(id7);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        int endItemIdCopySize = endItemIdCopy.size();
        for (int i = 0; i < endItemIdCopySize; ++i) {
            long id8 = endItemIdCopy.keyAt(i);
            TransitionValues start = startValues.itemIdValues.get(id8);
            TransitionValues end = (TransitionValues)endItemIdCopy.get(id8);
            startValuesList.add(start);
            endValuesList.add(end);
        }
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        for (int i = 0; i < startValuesList.size(); ++i) {
            Animator animator2;
            TransitionValues start = (TransitionValues)startValuesList.get(i);
            TransitionValues end = (TransitionValues)endValuesList.get(i);
            if (start == null && end == null || start != null && start.equals(end) || (animator2 = this.createAnimator(sceneRoot, start, end)) == null) continue;
            View view = null;
            TransitionValues infoValues = null;
            if (end != null) {
                view = end.view;
                String[] properties = this.getTransitionProperties();
                if (view != null && properties != null && properties.length > 0) {
                    infoValues = new TransitionValues();
                    infoValues.view = view;
                    TransitionValues newValues = endValues.viewValues.get(view);
                    if (newValues != null) {
                        for (int j = 0; j < properties.length; ++j) {
                            infoValues.values.put(properties[j], newValues.values.get(properties[j]));
                        }
                    }
                    int numExistingAnims = runningAnimators.size();
                    for (int j = 0; j < numExistingAnims; ++j) {
                        Animator anim2 = runningAnimators.keyAt(j);
                        AnimationInfo info = runningAnimators.get(anim2);
                        if (info.values == null || info.view != view || (info.name != null || this.getName() != null) && !info.name.equals(this.getName()) || !info.values.equals(infoValues)) continue;
                        animator2 = null;
                        break;
                    }
                }
            } else {
                View view2 = view = start != null ? start.view : null;
            }
            if (animator2 == null) continue;
            AnimationInfo info = new AnimationInfo(view, this.getName(), infoValues);
            runningAnimators.put(animator2, info);
            this.mAnimators.add(animator2);
        }
    }

    boolean isValidTarget(View target, long targetId) {
        int i;
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(targetId)) {
            return false;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(target)) {
            return false;
        }
        if (this.mTargetTypeExcludes != null && target != null) {
            int numTypes = this.mTargetTypeExcludes.size();
            for (int i2 = 0; i2 < numTypes; ++i2) {
                Class type = this.mTargetTypeExcludes.get(i2);
                if (!type.isInstance(target)) continue;
                return false;
            }
        }
        if (this.mTargetIds.size() == 0 && this.mTargets.size() == 0) {
            return true;
        }
        if (this.mTargetIds.size() > 0) {
            for (i = 0; i < this.mTargetIds.size(); ++i) {
                if ((long)this.mTargetIds.get(i).intValue() != targetId) continue;
                return true;
            }
        }
        if (target != null && this.mTargets.size() > 0) {
            for (i = 0; i < this.mTargets.size(); ++i) {
                if (this.mTargets.get(i) != target) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayMap<Animator, AnimationInfo> getRunningAnimators() {
        ArrayMap<Animator, AnimationInfo> runningAnimators = sRunningAnimators.get();
        if (runningAnimators == null) {
            runningAnimators = new ArrayMap();
            sRunningAnimators.set(runningAnimators);
        }
        return runningAnimators;
    }

    protected void runAnimators() {
        this.start();
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        for (Animator anim2 : this.mAnimators) {
            if (!runningAnimators.containsKey(anim2)) continue;
            this.start();
            this.runAnimator(anim2, runningAnimators);
        }
        this.mAnimators.clear();
        this.end();
    }

    private void runAnimator(Animator animator2, final ArrayMap<Animator, AnimationInfo> runningAnimators) {
        if (animator2 != null) {
            animator2.addListener(new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    Transition.this.mCurrentAnimators.add(animation);
                }

                public void onAnimationEnd(Animator animation) {
                    runningAnimators.remove(animation);
                    Transition.this.mCurrentAnimators.remove(animation);
                }
            });
            this.animate(animator2);
        }
    }

    public abstract void captureStartValues(TransitionValues var1);

    public abstract void captureEndValues(TransitionValues var1);

    public Transition addTarget(int targetId) {
        if (targetId > 0) {
            this.mTargetIds.add(targetId);
        }
        return this;
    }

    public Transition removeTarget(int targetId) {
        if (targetId > 0) {
            this.mTargetIds.remove(targetId);
        }
        return this;
    }

    public Transition excludeTarget(int targetId, boolean exclude) {
        this.mTargetIdExcludes = this.excludeId(this.mTargetIdExcludes, targetId, exclude);
        return this;
    }

    public Transition excludeChildren(int targetId, boolean exclude) {
        this.mTargetIdChildExcludes = this.excludeId(this.mTargetIdChildExcludes, targetId, exclude);
        return this;
    }

    private ArrayList<Integer> excludeId(ArrayList<Integer> list, int targetId, boolean exclude) {
        if (targetId > 0) {
            list = exclude ? ArrayListManager.add(list, targetId) : ArrayListManager.remove(list, targetId);
        }
        return list;
    }

    public Transition excludeTarget(View target, boolean exclude) {
        this.mTargetExcludes = this.excludeView(this.mTargetExcludes, target, exclude);
        return this;
    }

    public Transition excludeChildren(View target, boolean exclude) {
        this.mTargetChildExcludes = this.excludeView(this.mTargetChildExcludes, target, exclude);
        return this;
    }

    private ArrayList<View> excludeView(ArrayList<View> list, View target, boolean exclude) {
        if (target != null) {
            list = exclude ? ArrayListManager.add(list, target) : ArrayListManager.remove(list, target);
        }
        return list;
    }

    public Transition excludeTarget(Class type, boolean exclude) {
        this.mTargetTypeExcludes = this.excludeType(this.mTargetTypeExcludes, type, exclude);
        return this;
    }

    public Transition excludeChildren(Class type, boolean exclude) {
        this.mTargetTypeChildExcludes = this.excludeType(this.mTargetTypeChildExcludes, type, exclude);
        return this;
    }

    private ArrayList<Class> excludeType(ArrayList<Class> list, Class type, boolean exclude) {
        if (type != null) {
            list = exclude ? ArrayListManager.add(list, type) : ArrayListManager.remove(list, type);
        }
        return list;
    }

    public Transition addTarget(View target) {
        this.mTargets.add(target);
        return this;
    }

    public Transition removeTarget(View target) {
        if (target != null) {
            this.mTargets.remove(target);
        }
        return this;
    }

    public List<Integer> getTargetIds() {
        return this.mTargetIds;
    }

    public List<View> getTargets() {
        return this.mTargets;
    }

    void captureValues(ViewGroup sceneRoot, boolean start) {
        if (start) {
            this.mStartValues.viewValues.clear();
            this.mStartValues.idValues.clear();
            this.mStartValues.itemIdValues.clear();
        } else {
            this.mEndValues.viewValues.clear();
            this.mEndValues.idValues.clear();
            this.mEndValues.itemIdValues.clear();
        }
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            int i;
            if (this.mTargetIds.size() > 0) {
                for (i = 0; i < this.mTargetIds.size(); ++i) {
                    int id2 = this.mTargetIds.get(i);
                    View view = sceneRoot.findViewById(id2);
                    if (view == null) continue;
                    TransitionValues values = new TransitionValues();
                    values.view = view;
                    if (start) {
                        this.captureStartValues(values);
                    } else {
                        this.captureEndValues(values);
                    }
                    if (start) {
                        this.mStartValues.viewValues.put(view, values);
                        if (id2 < 0) continue;
                        this.mStartValues.idValues.put(id2, values);
                        continue;
                    }
                    this.mEndValues.viewValues.put(view, values);
                    if (id2 < 0) continue;
                    this.mEndValues.idValues.put(id2, values);
                }
            }
            if (this.mTargets.size() > 0) {
                for (i = 0; i < this.mTargets.size(); ++i) {
                    View view = this.mTargets.get(i);
                    if (view == null) continue;
                    TransitionValues values = new TransitionValues();
                    values.view = view;
                    if (start) {
                        this.captureStartValues(values);
                    } else {
                        this.captureEndValues(values);
                    }
                    if (start) {
                        this.mStartValues.viewValues.put(view, values);
                        continue;
                    }
                    this.mEndValues.viewValues.put(view, values);
                }
            }
        } else {
            this.captureHierarchy(sceneRoot, start);
        }
    }

    private void captureHierarchy(View view, boolean start) {
        if (view == null) {
            return;
        }
        boolean isListViewItem = false;
        if (view.getParent() instanceof ListView) {
            isListViewItem = true;
        }
        if (isListViewItem && !((ListView)view.getParent()).getAdapter().hasStableIds()) {
            return;
        }
        int id2 = -1;
        long itemId = -1L;
        if (!isListViewItem) {
            id2 = view.getId();
        } else {
            ListView listview = (ListView)view.getParent();
            int position = listview.getPositionForView(view);
            itemId = listview.getItemIdAtPosition(position);
            view.setHasTransientState(true);
        }
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(id2)) {
            return;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(view)) {
            return;
        }
        if (this.mTargetTypeExcludes != null && view != null) {
            int numTypes = this.mTargetTypeExcludes.size();
            for (int i = 0; i < numTypes; ++i) {
                if (!this.mTargetTypeExcludes.get(i).isInstance(view)) continue;
                return;
            }
        }
        TransitionValues values = new TransitionValues();
        values.view = view;
        if (start) {
            this.captureStartValues(values);
        } else {
            this.captureEndValues(values);
        }
        if (start) {
            if (!isListViewItem) {
                this.mStartValues.viewValues.put(view, values);
                if (id2 >= 0) {
                    this.mStartValues.idValues.put(id2, values);
                }
            } else {
                this.mStartValues.itemIdValues.put(itemId, values);
            }
        } else if (!isListViewItem) {
            this.mEndValues.viewValues.put(view, values);
            if (id2 >= 0) {
                this.mEndValues.idValues.put(id2, values);
            }
        } else {
            this.mEndValues.itemIdValues.put(itemId, values);
        }
        if (view instanceof ViewGroup) {
            int i;
            if (this.mTargetIdChildExcludes != null && this.mTargetIdChildExcludes.contains(id2)) {
                return;
            }
            if (this.mTargetChildExcludes != null && this.mTargetChildExcludes.contains(view)) {
                return;
            }
            if (this.mTargetTypeChildExcludes != null && view != null) {
                int numTypes = this.mTargetTypeChildExcludes.size();
                for (i = 0; i < numTypes; ++i) {
                    if (!this.mTargetTypeChildExcludes.get(i).isInstance(view)) continue;
                    return;
                }
            }
            ViewGroup parent = (ViewGroup)view;
            for (i = 0; i < parent.getChildCount(); ++i) {
                this.captureHierarchy(parent.getChildAt(i), start);
            }
        }
    }

    public TransitionValues getTransitionValues(View view, boolean start) {
        if (this.mParent != null) {
            return this.mParent.getTransitionValues(view, start);
        }
        TransitionValuesMaps valuesMaps = start ? this.mStartValues : this.mEndValues;
        TransitionValues values = valuesMaps.viewValues.get(view);
        if (values == null) {
            int id2 = view.getId();
            if (id2 >= 0) {
                values = valuesMaps.idValues.get(id2);
            }
            if (values == null && view.getParent() instanceof ListView) {
                ListView listview = (ListView)view.getParent();
                int position = listview.getPositionForView(view);
                long itemId = listview.getItemIdAtPosition(position);
                values = valuesMaps.itemIdValues.get(itemId);
            }
        }
        return values;
    }

    public void pause() {
        if (!this.mEnded) {
            ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
            int numOldAnims = runningAnimators.size();
            for (int i = numOldAnims - 1; i >= 0; --i) {
                Animator anim2 = runningAnimators.keyAt(i);
                anim2.pause();
            }
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((TransitionListener)tmpListeners.get(i)).onTransitionPause(this);
                }
            }
            this.mPaused = true;
        }
    }

    public void resume() {
        if (this.mPaused) {
            if (!this.mEnded) {
                ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
                int numOldAnims = runningAnimators.size();
                for (int i = numOldAnims - 1; i >= 0; --i) {
                    Animator anim2 = runningAnimators.keyAt(i);
                    anim2.resume();
                }
                if (this.mListeners != null && this.mListeners.size() > 0) {
                    ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                    int numListeners = tmpListeners.size();
                    for (int i = 0; i < numListeners; ++i) {
                        ((TransitionListener)tmpListeners.get(i)).onTransitionResume(this);
                    }
                }
            }
            this.mPaused = false;
        }
    }

    void playTransition(ViewGroup sceneRoot) {
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        int numOldAnims = runningAnimators.size();
        for (int i = numOldAnims - 1; i >= 0; --i) {
            TransitionValues newValues;
            AnimationInfo oldInfo;
            Animator anim2 = runningAnimators.keyAt(i);
            if (anim2 == null || (oldInfo = runningAnimators.get(anim2)) == null) continue;
            boolean cancel = false;
            TransitionValues oldValues = oldInfo.values;
            View oldView = oldInfo.view;
            TransitionValues transitionValues = newValues = this.mEndValues.viewValues != null ? this.mEndValues.viewValues.get(oldView) : null;
            if (newValues == null) {
                newValues = this.mEndValues.idValues.get(oldView.getId());
            }
            if (oldValues != null && newValues != null) {
                for (String key : oldValues.values.keySet()) {
                    Object oldValue = oldValues.values.get(key);
                    Object newValue = newValues.values.get(key);
                    if (oldValue == null || newValue == null || oldValue.equals(newValue)) continue;
                    cancel = true;
                    break;
                }
            }
            if (!cancel) continue;
            if (anim2.isRunning() || anim2.isStarted()) {
                anim2.cancel();
                continue;
            }
            runningAnimators.remove(anim2);
        }
        this.createAnimators(sceneRoot, this.mStartValues, this.mEndValues);
        this.runAnimators();
    }

    protected void animate(Animator animator2) {
        if (animator2 == null) {
            this.end();
        } else {
            if (this.getDuration() >= 0L) {
                animator2.setDuration(this.getDuration());
            }
            if (this.getStartDelay() >= 0L) {
                animator2.setStartDelay(this.getStartDelay());
            }
            if (this.getInterpolator() != null) {
                animator2.setInterpolator(this.getInterpolator());
            }
            animator2.addListener(new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    Transition.this.end();
                    animation.removeListener(this);
                }
            });
            animator2.start();
        }
    }

    protected void start() {
        if (this.mNumInstances == 0) {
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((TransitionListener)tmpListeners.get(i)).onTransitionStart(this);
                }
            }
            this.mEnded = false;
        }
        ++this.mNumInstances;
    }

    protected void end() {
        --this.mNumInstances;
        if (this.mNumInstances == 0) {
            int i;
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i2 = 0; i2 < numListeners; ++i2) {
                    ((TransitionListener)tmpListeners.get(i2)).onTransitionEnd(this);
                }
            }
            for (i = 0; i < this.mStartValues.itemIdValues.size(); ++i) {
                TransitionValues tv = this.mStartValues.itemIdValues.valueAt(i);
                View v = tv.view;
                if (!v.hasTransientState()) continue;
                v.setHasTransientState(false);
            }
            for (i = 0; i < this.mEndValues.itemIdValues.size(); ++i) {
                TransitionValues tv = this.mEndValues.itemIdValues.valueAt(i);
                View v = tv.view;
                if (!v.hasTransientState()) continue;
                v.setHasTransientState(false);
            }
            this.mEnded = true;
        }
    }

    protected void cancel() {
        int numAnimators = this.mCurrentAnimators.size();
        for (int i = numAnimators - 1; i >= 0; --i) {
            Animator animator2 = this.mCurrentAnimators.get(i);
            animator2.cancel();
        }
        if (this.mListeners != null && this.mListeners.size() > 0) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((TransitionListener)tmpListeners.get(i)).onTransitionCancel(this);
            }
        }
    }

    public Transition addListener(TransitionListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
        return this;
    }

    public Transition removeListener(TransitionListener listener) {
        if (this.mListeners == null) {
            return this;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
        return this;
    }

    Transition setSceneRoot(ViewGroup sceneRoot) {
        this.mSceneRoot = sceneRoot;
        return this;
    }

    void setCanRemoveViews(boolean canRemoveViews) {
        this.mCanRemoveViews = canRemoveViews;
    }

    public String toString() {
        return this.toString("");
    }

    public Transition clone() {
        Transition clone = null;
        try {
            clone = (Transition)super.clone();
            clone.mAnimators = new ArrayList();
            clone.mStartValues = new TransitionValuesMaps();
            clone.mEndValues = new TransitionValuesMaps();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String getName() {
        return this.mName;
    }

    String toString(String indent) {
        String result = indent + this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": ";
        if (this.mDuration != -1L) {
            result = result + "dur(" + this.mDuration + ") ";
        }
        if (this.mStartDelay != -1L) {
            result = result + "dly(" + this.mStartDelay + ") ";
        }
        if (this.mInterpolator != null) {
            result = result + "interp(" + this.mInterpolator + ") ";
        }
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            int i;
            result = result + "tgts(";
            if (this.mTargetIds.size() > 0) {
                for (i = 0; i < this.mTargetIds.size(); ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.mTargetIds.get(i);
                }
            }
            if (this.mTargets.size() > 0) {
                for (i = 0; i < this.mTargets.size(); ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.mTargets.get(i);
                }
            }
            result = result + ")";
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayListManager {
        private ArrayListManager() {
        }

        static <T> ArrayList<T> add(ArrayList<T> list, T item) {
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(item)) {
                list.add(item);
            }
            return list;
        }

        static <T> ArrayList<T> remove(ArrayList<T> list, T item) {
            if (list != null) {
                list.remove(item);
                if (list.isEmpty()) {
                    list = null;
                }
            }
            return list;
        }
    }

    private static class AnimationInfo {
        View view;
        String name;
        TransitionValues values;

        AnimationInfo(View view, String name, TransitionValues values) {
            this.view = view;
            this.name = name;
            this.values = values;
        }
    }

    public static class TransitionListenerAdapter
    implements TransitionListener {
        public void onTransitionStart(Transition transition) {
        }

        public void onTransitionEnd(Transition transition) {
        }

        public void onTransitionCancel(Transition transition) {
        }

        public void onTransitionPause(Transition transition) {
        }

        public void onTransitionResume(Transition transition) {
        }
    }

    public static interface TransitionListener {
        public void onTransitionStart(Transition var1);

        public void onTransitionEnd(Transition var1);

        public void onTransitionCancel(Transition var1);

        public void onTransitionPause(Transition var1);

        public void onTransitionResume(Transition var1);
    }
}

