/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.PhoneConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelephonyManager {
    private static final String TAG = "TelephonyManager";
    private static ITelephonyRegistry sRegistry;
    private final Context mContext;
    private static TelephonyManager sInstance;
    public static final String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static final String ACTION_RESPOND_VIA_MESSAGE = "android.intent.action.RESPOND_VIA_MESSAGE";
    public static final String EXTRA_STATE = "state";
    public static final String EXTRA_STATE_IDLE;
    public static final String EXTRA_STATE_RINGING;
    public static final String EXTRA_STATE_OFFHOOK;
    public static final String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static final int PHONE_TYPE_NONE = 0;
    public static final int PHONE_TYPE_GSM = 1;
    public static final int PHONE_TYPE_CDMA = 2;
    public static final int PHONE_TYPE_SIP = 3;
    private static final String sKernelCmdLine;
    private static final Pattern sProductTypePattern;
    private static final String sLteOnCdmaProductType;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_CLASS_2_G = 1;
    public static final int NETWORK_CLASS_3_G = 2;
    public static final int NETWORK_CLASS_4_G = 3;
    public static final int SIM_STATE_UNKNOWN = 0;
    public static final int SIM_STATE_ABSENT = 1;
    public static final int SIM_STATE_PIN_REQUIRED = 2;
    public static final int SIM_STATE_PUK_REQUIRED = 3;
    public static final int SIM_STATE_NETWORK_LOCKED = 4;
    public static final int SIM_STATE_READY = 5;
    public static final int CALL_STATE_IDLE = 0;
    public static final int CALL_STATE_RINGING = 1;
    public static final int CALL_STATE_OFFHOOK = 2;
    public static final int DATA_ACTIVITY_NONE = 0;
    public static final int DATA_ACTIVITY_IN = 1;
    public static final int DATA_ACTIVITY_OUT = 2;
    public static final int DATA_ACTIVITY_INOUT = 3;
    public static final int DATA_ACTIVITY_DORMANT = 4;
    public static final int DATA_UNKNOWN = -1;
    public static final int DATA_DISCONNECTED = 0;
    public static final int DATA_CONNECTING = 1;
    public static final int DATA_CONNECTED = 2;
    public static final int DATA_SUSPENDED = 3;

    public TelephonyManager(Context context) {
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null ? appContext : context;
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    private TelephonyManager() {
        this.mContext = null;
    }

    public static TelephonyManager getDefault() {
        return sInstance;
    }

    public static TelephonyManager from(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    public String getDeviceSoftwareVersion() {
        try {
            return this.getSubscriberInfo().getDeviceSvn();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getDeviceId() {
        try {
            return this.getSubscriberInfo().getDeviceId();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public CellLocation getCellLocation() {
        try {
            Bundle bundle = this.getITelephony().getCellLocation();
            if (bundle.isEmpty()) {
                return null;
            }
            CellLocation cl = CellLocation.newFromBundle(bundle);
            if (cl.isEmpty()) {
                return null;
            }
            return cl;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void enableLocationUpdates() {
        try {
            this.getITelephony().enableLocationUpdates();
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void disableLocationUpdates() {
        try {
            this.getITelephony().disableLocationUpdates();
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        try {
            return this.getITelephony().getNeighboringCellInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getCurrentPhoneType() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActivePhoneType();
            }
            return this.getPhoneTypeFromProperty();
        }
        catch (RemoteException ex) {
            return this.getPhoneTypeFromProperty();
        }
        catch (NullPointerException ex) {
            return this.getPhoneTypeFromProperty();
        }
    }

    public int getPhoneType() {
        if (!this.isVoiceCapable()) {
            return 0;
        }
        return this.getCurrentPhoneType();
    }

    private int getPhoneTypeFromProperty() {
        int type = SystemProperties.getInt("gsm.current.phone-type", this.getPhoneTypeFromNetworkType());
        return type;
    }

    private int getPhoneTypeFromNetworkType() {
        int mode = SystemProperties.getInt("ro.telephony.default_network", -1);
        if (mode == -1) {
            return 0;
        }
        return TelephonyManager.getPhoneType(mode);
    }

    public static int getPhoneType(int networkMode) {
        switch (networkMode) {
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: {
                return 1;
            }
            case 7: 
            case 8: {
                return 2;
            }
            case 11: {
                if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcCmdLine() {
        String cmdline = "";
        FileInputStream is = null;
        try {
            is = new FileInputStream("/proc/cmdline");
            byte[] buffer = new byte[2048];
            int count = is.read(buffer);
            if (count > 0) {
                cmdline = new String(buffer, 0, count);
            }
        }
        catch (IOException e) {
            Rlog.d(TAG, "No /proc/cmdline exception=" + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Rlog.d(TAG, "/proc/cmdline=" + cmdline);
        return cmdline;
    }

    public static int getLteOnCdmaModeStatic() {
        String productType = "";
        int curVal = SystemProperties.getInt("telephony.lteOnCdmaDevice", -1);
        int retVal = curVal;
        if (retVal == -1) {
            Matcher matcher = sProductTypePattern.matcher(sKernelCmdLine);
            retVal = matcher.find() ? (sLteOnCdmaProductType.equals(productType = matcher.group(1)) ? 1 : 0) : 0;
        }
        Rlog.d(TAG, "getLteOnCdmaMode=" + retVal + " curVal=" + curVal + " product_type='" + productType + "' lteOnCdmaProductType='" + sLteOnCdmaProductType + "'");
        return retVal;
    }

    public String getNetworkOperatorName() {
        return SystemProperties.get("gsm.operator.alpha");
    }

    public String getNetworkOperator() {
        return SystemProperties.get("gsm.operator.numeric");
    }

    public boolean isNetworkRoaming() {
        return "true".equals(SystemProperties.get("gsm.operator.isroaming"));
    }

    public String getNetworkCountryIso() {
        return SystemProperties.get("gsm.operator.iso-country");
    }

    public int getNetworkType() {
        return this.getDataNetworkType();
    }

    public int getDataNetworkType() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataNetworkType();
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getVoiceNetworkType() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceNetworkType();
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public static int getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }

    public String getNetworkTypeName() {
        return TelephonyManager.getNetworkTypeName(this.getNetworkType());
    }

    public static String getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "CDMA - eHRPD";
            }
            case 11: {
                return "iDEN";
            }
            case 15: {
                return "HSPA+";
            }
        }
        return "UNKNOWN";
    }

    public boolean hasIccCard() {
        try {
            return this.getITelephony().hasIccCard();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public int getSimState() {
        String prop = SystemProperties.get("gsm.sim.state");
        if ("ABSENT".equals(prop)) {
            return 1;
        }
        if ("PIN_REQUIRED".equals(prop)) {
            return 2;
        }
        if ("PUK_REQUIRED".equals(prop)) {
            return 3;
        }
        if ("NETWORK_LOCKED".equals(prop)) {
            return 4;
        }
        if ("READY".equals(prop)) {
            return 5;
        }
        return 0;
    }

    public String getSimOperator() {
        return SystemProperties.get("gsm.sim.operator.numeric");
    }

    public String getSimOperatorName() {
        return SystemProperties.get("gsm.sim.operator.alpha");
    }

    public String getSimCountryIso() {
        return SystemProperties.get("gsm.sim.operator.iso-country");
    }

    public String getSimSerialNumber() {
        try {
            return this.getSubscriberInfo().getIccSerialNumber();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getLteOnCdmaMode() {
        try {
            return this.getITelephony().getLteOnCdmaMode();
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public String getSubscriberId() {
        try {
            return this.getSubscriberInfo().getSubscriberId();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getGroupIdLevel1() {
        try {
            return this.getSubscriberInfo().getGroupIdLevel1();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getLine1Number() {
        try {
            return this.getSubscriberInfo().getLine1Number();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getLine1AlphaTag() {
        try {
            return this.getSubscriberInfo().getLine1AlphaTag();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getMsisdn() {
        try {
            return this.getSubscriberInfo().getMsisdn();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getVoiceMailNumber() {
        try {
            return this.getSubscriberInfo().getVoiceMailNumber();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getCompleteVoiceMailNumber() {
        try {
            return this.getSubscriberInfo().getCompleteVoiceMailNumber();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getVoiceMessageCount() {
        try {
            return this.getITelephony().getVoiceMessageCount();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public String getVoiceMailAlphaTag() {
        try {
            return this.getSubscriberInfo().getVoiceMailAlphaTag();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimImpi() {
        try {
            return this.getSubscriberInfo().getIsimImpi();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimDomain() {
        try {
            return this.getSubscriberInfo().getIsimDomain();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getIsimImpu() {
        try {
            return this.getSubscriberInfo().getIsimImpu();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private IPhoneSubInfo getSubscriberInfo() {
        return IPhoneSubInfo.Stub.asInterface(ServiceManager.getService("iphonesubinfo"));
    }

    public int getCallState() {
        try {
            return this.getITelephony().getCallState();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataActivity() {
        try {
            return this.getITelephony().getDataActivity();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataState() {
        try {
            return this.getITelephony().getDataState();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private ITelephony getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    public void listen(PhoneStateListener listener, int events) {
        String pkgForDebug = this.mContext != null ? this.mContext.getPackageName() : "<unknown>";
        try {
            Boolean notifyNow = true;
            sRegistry.listen(pkgForDebug, listener.callback, events, notifyNow);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public int getCdmaEriIconIndex() {
        try {
            return this.getITelephony().getCdmaEriIconIndex();
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public int getCdmaEriIconMode() {
        try {
            return this.getITelephony().getCdmaEriIconMode();
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public String getCdmaEriText() {
        try {
            return this.getITelephony().getCdmaEriText();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean isVoiceCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17891385);
    }

    public boolean isSmsCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17891386);
    }

    public List<CellInfo> getAllCellInfo() {
        try {
            return this.getITelephony().getAllCellInfo();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void setCellInfoListRate(int rateInMillis) {
        try {
            this.getITelephony().setCellInfoListRate(rateInMillis);
        }
        catch (RemoteException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getMmsUserAgent() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039405);
    }

    public String getMmsUAProfUrl() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039406);
    }

    static {
        sInstance = new TelephonyManager();
        EXTRA_STATE_IDLE = PhoneConstants.State.IDLE.toString();
        EXTRA_STATE_RINGING = PhoneConstants.State.RINGING.toString();
        EXTRA_STATE_OFFHOOK = PhoneConstants.State.OFFHOOK.toString();
        sKernelCmdLine = TelephonyManager.getProcCmdLine();
        sProductTypePattern = Pattern.compile("\\sproduct_type\\s*=\\s*(\\w+)");
        sLteOnCdmaProductType = SystemProperties.get("telephony.lteOnCdmaProductType", "");
    }
}

