/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;
import android.telephony.SignalStrength;

public final class CellSignalStrengthLte
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthLte";
    private static final boolean DBG = false;
    private int mSignalStrength;
    private int mRsrp;
    private int mRsrq;
    private int mRssnr;
    private int mCqi;
    private int mTimingAdvance;
    public static final Parcelable.Creator<CellSignalStrengthLte> CREATOR = new Parcelable.Creator<CellSignalStrengthLte>(){

        @Override
        public CellSignalStrengthLte createFromParcel(Parcel in) {
            return new CellSignalStrengthLte(in);
        }

        public CellSignalStrengthLte[] newArray(int size) {
            return new CellSignalStrengthLte[size];
        }
    };

    public CellSignalStrengthLte() {
        this.setDefaultValues();
    }

    public CellSignalStrengthLte(int signalStrength, int rsrp, int rsrq, int rssnr, int cqi, int timingAdvance) {
        this.initialize(signalStrength, rsrp, rsrq, rssnr, cqi, timingAdvance);
    }

    public CellSignalStrengthLte(CellSignalStrengthLte s) {
        this.copyFrom(s);
    }

    public void initialize(int lteSignalStrength, int rsrp, int rsrq, int rssnr, int cqi, int timingAdvance) {
        this.mSignalStrength = lteSignalStrength;
        this.mRsrp = rsrp;
        this.mRsrq = rsrq;
        this.mRssnr = rssnr;
        this.mCqi = cqi;
        this.mTimingAdvance = timingAdvance;
    }

    public void initialize(SignalStrength ss, int timingAdvance) {
        this.mSignalStrength = ss.getLteSignalStrength();
        this.mRsrp = ss.getLteRsrp();
        this.mRsrq = ss.getLteRsrq();
        this.mRssnr = ss.getLteRssnr();
        this.mCqi = ss.getLteCqi();
        this.mTimingAdvance = timingAdvance;
    }

    protected void copyFrom(CellSignalStrengthLte s) {
        this.mSignalStrength = s.mSignalStrength;
        this.mRsrp = s.mRsrp;
        this.mRsrq = s.mRsrq;
        this.mRssnr = s.mRssnr;
        this.mCqi = s.mCqi;
        this.mTimingAdvance = s.mTimingAdvance;
    }

    public CellSignalStrengthLte copy() {
        return new CellSignalStrengthLte(this);
    }

    public void setDefaultValues() {
        this.mSignalStrength = Integer.MAX_VALUE;
        this.mRsrp = Integer.MAX_VALUE;
        this.mRsrq = Integer.MAX_VALUE;
        this.mRssnr = Integer.MAX_VALUE;
        this.mCqi = Integer.MAX_VALUE;
        this.mTimingAdvance = Integer.MAX_VALUE;
    }

    public int getLevel() {
        int levelRsrp = 0;
        int levelRssnr = 0;
        levelRsrp = this.mRsrp == Integer.MAX_VALUE ? 0 : (this.mRsrp >= -95 ? 4 : (this.mRsrp >= -105 ? 3 : (this.mRsrp >= -115 ? 2 : 1)));
        levelRssnr = this.mRssnr == Integer.MAX_VALUE ? 0 : (this.mRssnr >= 45 ? 4 : (this.mRssnr >= 10 ? 3 : (this.mRssnr >= -30 ? 2 : 1)));
        int level = this.mRsrp == Integer.MAX_VALUE ? levelRssnr : (this.mRssnr == Integer.MAX_VALUE ? levelRsrp : (levelRssnr < levelRsrp ? levelRssnr : levelRsrp));
        return level;
    }

    public int getDbm() {
        return this.mRsrp;
    }

    public int getAsuLevel() {
        int lteAsuLevel = 99;
        int lteDbm = this.getDbm();
        lteAsuLevel = lteDbm <= -140 ? 0 : (lteDbm >= -43 ? 97 : lteDbm + 140);
        return lteAsuLevel;
    }

    public int getTimingAdvance() {
        return this.mTimingAdvance;
    }

    public int hashCode() {
        int primeNum = 31;
        return this.mSignalStrength * primeNum + this.mRsrp * primeNum + this.mRsrq * primeNum + this.mRssnr * primeNum + this.mCqi * primeNum + this.mTimingAdvance * primeNum;
    }

    public boolean equals(Object o) {
        CellSignalStrengthLte s;
        try {
            s = (CellSignalStrengthLte)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mSignalStrength == s.mSignalStrength && this.mRsrp == s.mRsrp && this.mRsrq == s.mRsrq && this.mRssnr == s.mRssnr && this.mCqi == s.mCqi && this.mTimingAdvance == s.mTimingAdvance;
    }

    public String toString() {
        return "CellSignalStrengthLte: ss=" + this.mSignalStrength + " rsrp=" + this.mRsrp + " rsrq=" + this.mRsrq + " rssnr=" + this.mRssnr + " cqi=" + this.mCqi + " ta=" + this.mTimingAdvance;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSignalStrength);
        dest.writeInt(this.mRsrp * -1);
        dest.writeInt(this.mRsrq * -1);
        dest.writeInt(this.mRssnr);
        dest.writeInt(this.mCqi);
        dest.writeInt(this.mTimingAdvance);
    }

    private CellSignalStrengthLte(Parcel in) {
        this.mSignalStrength = in.readInt();
        this.mRsrp = in.readInt() * -1;
        this.mRsrq = in.readInt() * -1;
        this.mRssnr = in.readInt();
        this.mCqi = in.readInt();
        this.mTimingAdvance = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }
}

