/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TtsEngines {
    private static final String TAG = "TtsEngines";
    private static final boolean DBG = false;
    private static final String LOCALE_DELIMITER = "-";
    private final Context mContext;
    private static final String XML_TAG_NAME = "tts-engine";

    public TtsEngines(Context ctx) {
        this.mContext = ctx;
    }

    public String getDefaultEngine() {
        String engine = Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_synth");
        return this.isEngineInstalled(engine) ? engine : this.getHighestRankedEngineName();
    }

    public String getHighestRankedEngineName() {
        List<TextToSpeech.EngineInfo> engines = this.getEngines();
        if (engines.size() > 0 && engines.get((int)0).system) {
            return engines.get((int)0).name;
        }
        return null;
    }

    public TextToSpeech.EngineInfo getEngineInfo(String packageName) {
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(packageName);
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(intent, 65536);
        if (resolveInfos != null && resolveInfos.size() == 1) {
            return this.getEngineInfo(resolveInfos.get(0), pm);
        }
        return null;
    }

    public List<TextToSpeech.EngineInfo> getEngines() {
        Intent intent;
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(intent = new Intent("android.intent.action.TTS_SERVICE"), 65536);
        if (resolveInfos == null) {
            return Collections.emptyList();
        }
        ArrayList<TextToSpeech.EngineInfo> engines = new ArrayList<TextToSpeech.EngineInfo>(resolveInfos.size());
        for (ResolveInfo resolveInfo : resolveInfos) {
            TextToSpeech.EngineInfo engine = this.getEngineInfo(resolveInfo, pm);
            if (engine == null) continue;
            engines.add(engine);
        }
        Collections.sort(engines, EngineInfoComparator.INSTANCE);
        return engines;
    }

    private boolean isSystemEngine(ServiceInfo info) {
        ApplicationInfo appInfo = info.applicationInfo;
        return appInfo != null && (appInfo.flags & 1) != 0;
    }

    public boolean isEngineInstalled(String engine) {
        if (engine == null) {
            return false;
        }
        return this.getEngineInfo(engine) != null;
    }

    public Intent getSettingsIntent(String engine) {
        String settings;
        ServiceInfo service;
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(engine);
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(intent, 65664);
        if (resolveInfos != null && resolveInfos.size() == 1 && (service = resolveInfos.get((int)0).serviceInfo) != null && (settings = this.settingsActivityFromServiceInfo(service, pm)) != null) {
            Intent i = new Intent();
            i.setClassName(engine, settings);
            return i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String settingsActivityFromServiceInfo(ServiceInfo si, PackageManager pm) {
        XmlResourceParser parser = null;
        try {
            int type;
            parser = si.loadXmlMetaData(pm, "android.speech.tts");
            if (parser == null) {
                Log.w(TAG, "No meta-data found for :" + si);
                String string2 = null;
                return string2;
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                if (!XML_TAG_NAME.equals(parser.getName())) {
                    Log.w(TAG, "Package " + si + " uses unknown tag :" + parser.getName());
                    String string3 = null;
                    return string3;
                }
                AttributeSet attrs = Xml.asAttributeSet(parser);
                TypedArray array2 = res.obtainAttributes(attrs, R.styleable.TextToSpeechEngine);
                String settings = array2.getString(0);
                array2.recycle();
                String string4 = settings;
                return string4;
            }
            String string5 = null;
            return string5;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Could not load resources for : " + si);
            String string6 = null;
            return string6;
        }
        catch (XmlPullParserException e) {
            Log.w(TAG, "Error parsing metadata for " + si + ":" + e);
            String string7 = null;
            return string7;
        }
        catch (IOException e) {
            Log.w(TAG, "Error parsing metadata for " + si + ":" + e);
            String string8 = null;
            return string8;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    private TextToSpeech.EngineInfo getEngineInfo(ResolveInfo resolve, PackageManager pm) {
        ServiceInfo service = resolve.serviceInfo;
        if (service != null) {
            TextToSpeech.EngineInfo engine = new TextToSpeech.EngineInfo();
            engine.name = service.packageName;
            CharSequence label = service.loadLabel(pm);
            engine.label = TextUtils.isEmpty(label) ? engine.name : ((Object)label).toString();
            engine.icon = service.getIconResource();
            engine.priority = resolve.priority;
            engine.system = this.isSystemEngine(service);
            return engine;
        }
        return null;
    }

    public String getLocalePrefForEngine(String engineName) {
        String locale = TtsEngines.parseEnginePrefFromList(Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale"), engineName);
        if (TextUtils.isEmpty(locale)) {
            locale = this.getV1Locale();
        }
        return locale;
    }

    public static String[] parseLocalePref(String pref) {
        String[] returnVal = new String[]{"", "", ""};
        if (!TextUtils.isEmpty(pref)) {
            String[] split = pref.split(LOCALE_DELIMITER);
            System.arraycopy(split, 0, returnVal, 0, split.length);
        }
        return returnVal;
    }

    private String getV1Locale() {
        ContentResolver cr = this.mContext.getContentResolver();
        String lang = Settings.Secure.getString(cr, "tts_default_lang");
        String country = Settings.Secure.getString(cr, "tts_default_country");
        String variant = Settings.Secure.getString(cr, "tts_default_variant");
        if (TextUtils.isEmpty(lang)) {
            return this.getDefaultLocale();
        }
        String v1Locale = lang;
        if (TextUtils.isEmpty(country)) {
            return v1Locale;
        }
        v1Locale = v1Locale + LOCALE_DELIMITER + country;
        if (!TextUtils.isEmpty(variant)) {
            v1Locale = v1Locale + LOCALE_DELIMITER + variant;
        }
        return v1Locale;
    }

    public String getDefaultLocale() {
        Locale locale = Locale.getDefault();
        String defaultLocale = locale.getISO3Language();
        if (TextUtils.isEmpty(defaultLocale)) {
            Log.w(TAG, "Default locale is empty.");
            return "";
        }
        if (TextUtils.isEmpty(locale.getISO3Country())) {
            return defaultLocale;
        }
        defaultLocale = defaultLocale + LOCALE_DELIMITER + locale.getISO3Country();
        if (!TextUtils.isEmpty(locale.getVariant())) {
            defaultLocale = defaultLocale + LOCALE_DELIMITER + locale.getVariant();
        }
        return defaultLocale;
    }

    private static String parseEnginePrefFromList(String prefValue, String engineName) {
        String[] prefValues;
        if (TextUtils.isEmpty(prefValue)) {
            return null;
        }
        for (String value : prefValues = prefValue.split(",")) {
            int delimiter = value.indexOf(58);
            if (delimiter <= 0 || !engineName.equals(value.substring(0, delimiter))) continue;
            return value.substring(delimiter + 1);
        }
        return null;
    }

    public synchronized void updateLocalePrefForEngine(String name, String newLocale) {
        String prefList = Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale");
        String newPrefList = this.updateValueInCommaSeparatedList(prefList, name, newLocale);
        Settings.Secure.putString(this.mContext.getContentResolver(), "tts_default_locale", newPrefList.toString());
    }

    private String updateValueInCommaSeparatedList(String list, String key, String newValue) {
        StringBuilder newPrefList = new StringBuilder();
        if (TextUtils.isEmpty(list)) {
            newPrefList.append(key).append(':').append(newValue);
        } else {
            String[] prefValues = list.split(",");
            boolean first = true;
            boolean found = false;
            for (String value : prefValues) {
                int delimiter = value.indexOf(58);
                if (delimiter <= 0) continue;
                if (key.equals(value.substring(0, delimiter))) {
                    if (first) {
                        first = false;
                    } else {
                        newPrefList.append(',');
                    }
                    found = true;
                    newPrefList.append(key).append(':').append(newValue);
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    newPrefList.append(',');
                }
                newPrefList.append(value);
            }
            if (!found) {
                newPrefList.append(',');
                newPrefList.append(key).append(':').append(newValue);
            }
        }
        return newPrefList.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EngineInfoComparator
    implements Comparator<TextToSpeech.EngineInfo> {
        static EngineInfoComparator INSTANCE = new EngineInfoComparator();

        private EngineInfoComparator() {
        }

        @Override
        public int compare(TextToSpeech.EngineInfo lhs, TextToSpeech.EngineInfo rhs) {
            if (lhs.system && !rhs.system) {
                return -1;
            }
            if (rhs.system && !lhs.system) {
                return 1;
            }
            return rhs.priority - lhs.priority;
        }
    }
}

