/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.AbstractSynthesisCallback;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

class FileSynthesisCallback
extends AbstractSynthesisCallback {
    private static final String TAG = "FileSynthesisRequest";
    private static final boolean DBG = false;
    private static final int MAX_AUDIO_BUFFER_SIZE = 8192;
    private static final int WAV_HEADER_LENGTH = 44;
    private static final short WAV_FORMAT_PCM = 1;
    private final Object mStateLock = new Object();
    private int mSampleRateInHz;
    private int mAudioFormat;
    private int mChannelCount;
    private FileChannel mFileChannel;
    private boolean mStarted = false;
    private boolean mStopped = false;
    private boolean mDone = false;

    FileSynthesisCallback(FileChannel fileChannel) {
        this.mFileChannel = fileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.mStopped = true;
            this.cleanUp();
        }
    }

    private void cleanUp() {
        this.closeFile();
    }

    private void closeFile() {
        try {
            if (this.mFileChannel != null) {
                this.mFileChannel.close();
                this.mFileChannel = null;
            }
        }
        catch (IOException ex) {
            Log.e(TAG, "Failed to close output file descriptor", ex);
        }
    }

    public int getMaxBufferSize() {
        return 8192;
    }

    boolean isDone() {
        return this.mDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(int sampleRateInHz, int audioFormat, int channelCount) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStopped) {
                return -1;
            }
            if (this.mStarted) {
                this.cleanUp();
                throw new IllegalArgumentException("FileSynthesisRequest.start() called twice");
            }
            this.mStarted = true;
            this.mSampleRateInHz = sampleRateInHz;
            this.mAudioFormat = audioFormat;
            this.mChannelCount = channelCount;
            try {
                this.mFileChannel.write(ByteBuffer.allocate(44));
                return 0;
            }
            catch (IOException ex) {
                Log.e(TAG, "Failed to write wav header to output file descriptor" + ex);
                this.cleanUp();
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int audioAvailable(byte[] buffer, int offset, int length) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStopped) {
                return -1;
            }
            if (this.mFileChannel == null) {
                Log.e(TAG, "File not open");
                return -1;
            }
            try {
                this.mFileChannel.write(ByteBuffer.wrap(buffer, offset, length));
                return 0;
            }
            catch (IOException ex) {
                Log.e(TAG, "Failed to write to output file descriptor", ex);
                this.cleanUp();
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int done() {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                return -1;
            }
            if (this.mStopped) {
                return -1;
            }
            if (this.mFileChannel == null) {
                Log.e(TAG, "File not open");
                return -1;
            }
            try {
                this.mFileChannel.position(0L);
                int dataLength = (int)(this.mFileChannel.size() - 44L);
                this.mFileChannel.write(this.makeWavHeader(this.mSampleRateInHz, this.mAudioFormat, this.mChannelCount, dataLength));
                this.closeFile();
                this.mDone = true;
                return 0;
            }
            catch (IOException ex) {
                Log.e(TAG, "Failed to write to output file descriptor", ex);
                this.cleanUp();
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.cleanUp();
        }
    }

    private ByteBuffer makeWavHeader(int sampleRateInHz, int audioFormat, int channelCount, int dataLength) {
        int sampleSizeInBytes = audioFormat == 3 ? 1 : 2;
        int byteRate = sampleRateInHz * sampleSizeInBytes * channelCount;
        short blockAlign = (short)(sampleSizeInBytes * channelCount);
        short bitsPerSample = (short)(sampleSizeInBytes * 8);
        byte[] headerBuf = new byte[44];
        ByteBuffer header = ByteBuffer.wrap(headerBuf);
        header.order(ByteOrder.LITTLE_ENDIAN);
        header.put(new byte[]{82, 73, 70, 70});
        header.putInt(dataLength + 44 - 8);
        header.put(new byte[]{87, 65, 86, 69});
        header.put(new byte[]{102, 109, 116, 32});
        header.putInt(16);
        header.putShort((short)1);
        header.putShort((short)channelCount);
        header.putInt(sampleRateInHz);
        header.putInt(byteRate);
        header.putShort(blockAlign);
        header.putShort(bitsPerSample);
        header.put(new byte[]{100, 97, 116, 97});
        header.putInt(dataLength);
        header.flip();
        return header;
    }
}

