/*
 * Decompiled with CFR 0.152.
 */
package android.service.dreams;

import android.app.Service;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.os.IBinder;
import android.os.ServiceManager;
import android.service.dreams.IDreamManager;
import android.service.dreams.IDreamService;
import android.util.Slog;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.policy.PolicyManager;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class DreamService
extends Service
implements Window.Callback {
    private final String TAG = DreamService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    public static final String DREAM_SERVICE = "dreams";
    public static final String SERVICE_INTERFACE = "android.service.dreams.DreamService";
    public static final String DREAM_META_DATA = "android.service.dream";
    private final Handler mHandler = new Handler();
    private IBinder mWindowToken;
    private Window mWindow;
    private WindowManager mWindowManager;
    private IDreamManager mSandman;
    private boolean mInteractive = false;
    private boolean mLowProfile = true;
    private boolean mFullscreen = false;
    private boolean mScreenBright = true;
    private boolean mFinished;
    private boolean mDebug = false;

    public void setDebug(boolean dbg) {
        this.mDebug = dbg;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Finishing on keyEvent");
            }
            this.safelyFinish();
            return true;
        }
        if (event.getKeyCode() == 4) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Finishing on back key");
            }
            this.safelyFinish();
            return true;
        }
        return this.mWindow.superDispatchKeyEvent(event);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Finishing on keyShortcutEvent");
            }
            this.safelyFinish();
            return true;
        }
        return this.mWindow.superDispatchKeyShortcutEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Finishing on touchEvent");
            }
            this.safelyFinish();
            return true;
        }
        return this.mWindow.superDispatchTouchEvent(event);
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Finishing on trackballEvent");
            }
            this.safelyFinish();
            return true;
        }
        return this.mWindow.superDispatchTrackballEvent(event);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Finishing on genericMotionEvent");
            }
            this.safelyFinish();
            return true;
        }
        return this.mWindow.superDispatchGenericMotionEvent(event);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return false;
    }

    public View onCreatePanelView(int featureId) {
        return null;
    }

    public boolean onCreatePanelMenu(int featureId, Menu menu2) {
        return false;
    }

    public boolean onPreparePanel(int featureId, View view, Menu menu2) {
        return false;
    }

    public boolean onMenuOpened(int featureId, Menu menu2) {
        return false;
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        return false;
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams attrs) {
    }

    public void onContentChanged() {
    }

    public void onWindowFocusChanged(boolean hasFocus) {
    }

    public void onAttachedToWindow() {
    }

    public void onDetachedFromWindow() {
    }

    public void onPanelClosed(int featureId, Menu menu2) {
    }

    public boolean onSearchRequested() {
        return false;
    }

    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        return null;
    }

    public void onActionModeStarted(ActionMode mode) {
    }

    public void onActionModeFinished(ActionMode mode) {
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public Window getWindow() {
        return this.mWindow;
    }

    public void setContentView(int layoutResID) {
        this.getWindow().setContentView(layoutResID);
    }

    public void setContentView(View view) {
        this.getWindow().setContentView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        this.getWindow().setContentView(view, params);
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        this.getWindow().addContentView(view, params);
    }

    public View findViewById(int id2) {
        return this.getWindow().findViewById(id2);
    }

    public void setInteractive(boolean interactive) {
        this.mInteractive = interactive;
    }

    public boolean isInteractive() {
        return this.mInteractive;
    }

    public void setLowProfile(boolean lowProfile) {
        this.mLowProfile = lowProfile;
        int flag = 1;
        this.applySystemUiVisibilityFlags(this.mLowProfile ? flag : 0, flag);
    }

    public boolean isLowProfile() {
        return this.getSystemUiVisibilityFlagValue(1, this.mLowProfile);
    }

    public void setFullscreen(boolean fullscreen) {
        this.mFullscreen = fullscreen;
        int flag = 1024;
        this.applyWindowFlags(this.mFullscreen ? flag : 0, flag);
    }

    public boolean isFullscreen() {
        return this.mFullscreen;
    }

    public void setScreenBright(boolean screenBright) {
        this.mScreenBright = screenBright;
        int flag = 128;
        this.applyWindowFlags(this.mScreenBright ? flag : 0, flag);
    }

    public boolean isScreenBright() {
        return this.getWindowFlagValue(128, this.mScreenBright);
    }

    public void onCreate() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onCreate() on thread " + Thread.currentThread().getId());
        }
        super.onCreate();
    }

    public void onDreamingStarted() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onDreamingStarted()");
        }
    }

    public void onDreamingStopped() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onDreamingStopped()");
        }
    }

    public final IBinder onBind(Intent intent) {
        if (this.mDebug) {
            Slog.v(this.TAG, "onBind() intent = " + intent);
        }
        return new DreamServiceWrapper();
    }

    public final void finish() {
        if (this.mDebug) {
            Slog.v(this.TAG, "finish()");
        }
        this.finishInternal();
    }

    public void onDestroy() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onDestroy()");
        }
        this.detach();
        super.onDestroy();
    }

    private void loadSandman() {
        this.mSandman = IDreamManager.Stub.asInterface(ServiceManager.getService(DREAM_SERVICE));
    }

    private final void detach() {
        if (this.mWindow == null) {
            return;
        }
        try {
            this.onDreamingStopped();
        }
        catch (Throwable t) {
            Slog.w(this.TAG, "Crashed in onDreamingStopped()", t);
        }
        if (this.mDebug) {
            Slog.v(this.TAG, "detach(): Removing window from window manager");
        }
        try {
            this.mWindowManager.removeViewImmediate(this.mWindow.getDecorView());
            WindowManagerGlobal.getInstance().closeAll(this.mWindowToken, this.getClass().getName(), "Dream");
        }
        catch (Throwable t) {
            Slog.w(this.TAG, "Crashed removing window view", t);
        }
        this.mWindow = null;
        this.mWindowToken = null;
    }

    private final void attach(IBinder windowToken) {
        if (this.mWindowToken != null) {
            Slog.e(this.TAG, "attach() called when already attached with token=" + this.mWindowToken);
            return;
        }
        if (this.mDebug) {
            Slog.v(this.TAG, "Attached on thread " + Thread.currentThread().getId());
        }
        if (this.mSandman == null) {
            this.loadSandman();
        }
        this.mWindowToken = windowToken;
        this.mWindow = PolicyManager.makeNewWindow(this);
        this.mWindow.setCallback(this);
        this.mWindow.requestFeature(1);
        this.mWindow.setBackgroundDrawable(new ColorDrawable(-16777216));
        this.mWindow.setFormat(-1);
        if (this.mDebug) {
            Slog.v(this.TAG, String.format("Attaching window token: %s to window of type %s", windowToken, 2023));
        }
        WindowManager.LayoutParams lp = this.mWindow.getAttributes();
        lp.type = 2023;
        lp.token = windowToken;
        lp.windowAnimations = 16974329;
        lp.flags = lp.flags | (0x490101 | (this.mFullscreen ? 1024 : 0) | (this.mScreenBright ? 128 : 0));
        this.mWindow.setAttributes(lp);
        if (this.mDebug) {
            Slog.v(this.TAG, "Created and attached window: " + this.mWindow);
        }
        this.mWindow.setWindowManager(null, windowToken, "dream", true);
        this.mWindowManager = this.mWindow.getWindowManager();
        if (this.mDebug) {
            Slog.v(this.TAG, "Window added on thread " + Thread.currentThread().getId());
        }
        try {
            this.applySystemUiVisibilityFlags(this.mLowProfile ? 1 : 0, 1);
            this.getWindowManager().addView(this.mWindow.getDecorView(), this.mWindow.getAttributes());
        }
        catch (Throwable t) {
            Slog.w(this.TAG, "Crashed adding window view", t);
            this.safelyFinish();
            return;
        }
        this.mHandler.post(new Runnable(){

            public void run() {
                try {
                    DreamService.this.onDreamingStarted();
                }
                catch (Throwable t) {
                    Slog.w(DreamService.this.TAG, "Crashed in onDreamingStarted()", t);
                    DreamService.this.safelyFinish();
                }
            }
        });
    }

    private void safelyFinish() {
        if (this.mDebug) {
            Slog.v(this.TAG, "safelyFinish()");
        }
        try {
            this.finish();
        }
        catch (Throwable t) {
            Slog.w(this.TAG, "Crashed in safelyFinish()", t);
            this.finishInternal();
            return;
        }
        if (!this.mFinished) {
            Slog.w(this.TAG, "Bad dream, did not call super.finish()");
            this.finishInternal();
        }
    }

    private void finishInternal() {
        if (this.mDebug) {
            Slog.v(this.TAG, "finishInternal() mFinished = " + this.mFinished);
        }
        if (this.mFinished) {
            return;
        }
        try {
            this.mFinished = true;
            if (this.mSandman != null) {
                this.mSandman.finishSelf(this.mWindowToken);
            } else {
                Slog.w(this.TAG, "No dream manager found");
            }
            this.stopSelf();
        }
        catch (Throwable t) {
            Slog.w(this.TAG, "Crashed in finishInternal()", t);
        }
    }

    private boolean getWindowFlagValue(int flag, boolean defaultValue) {
        return this.mWindow == null ? defaultValue : (this.mWindow.getAttributes().flags & flag) != 0;
    }

    private void applyWindowFlags(int flags, int mask) {
        if (this.mWindow != null) {
            WindowManager.LayoutParams lp = this.mWindow.getAttributes();
            lp.flags = this.applyFlags(lp.flags, flags, mask);
            this.mWindow.setAttributes(lp);
            this.mWindowManager.updateViewLayout(this.mWindow.getDecorView(), lp);
        }
    }

    private boolean getSystemUiVisibilityFlagValue(int flag, boolean defaultValue) {
        View v;
        View view = v = this.mWindow == null ? null : this.mWindow.getDecorView();
        return v == null ? defaultValue : (v.getSystemUiVisibility() & flag) != 0;
    }

    private void applySystemUiVisibilityFlags(int flags, int mask) {
        View v;
        View view = v = this.mWindow == null ? null : this.mWindow.getDecorView();
        if (v != null) {
            v.setSystemUiVisibility(this.applyFlags(v.getSystemUiVisibility(), flags, mask));
        }
    }

    private int applyFlags(int oldFlags, int flags, int mask) {
        return oldFlags & ~mask | flags & mask;
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        pw.print(this.TAG + ": ");
        if (this.mWindowToken == null) {
            pw.println("stopped");
        } else {
            pw.println("running (token=" + this.mWindowToken + ")");
        }
        pw.println("  window: " + this.mWindow);
        pw.print("  flags:");
        if (this.isInteractive()) {
            pw.print(" interactive");
        }
        if (this.isLowProfile()) {
            pw.print(" lowprofile");
        }
        if (this.isFullscreen()) {
            pw.print(" fullscreen");
        }
        if (this.isScreenBright()) {
            pw.print(" bright");
        }
        pw.println();
    }

    private class DreamServiceWrapper
    extends IDreamService.Stub {
        private DreamServiceWrapper() {
        }

        public void attach(final IBinder windowToken) {
            DreamService.this.mHandler.post(new Runnable(){

                public void run() {
                    DreamService.this.attach(windowToken);
                }
            });
        }

        public void detach() {
            DreamService.this.mHandler.post(new Runnable(){

                public void run() {
                    DreamService.this.detach();
                }
            });
        }
    }
}

